/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.process;

import com.wewebu.ooa.OwActionObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class OwProcessStreamSubject
implements Runnable {
    private OwActionObserver actionObserver;
    private InputStream stream;
    private String logPrefix;
    private String logMode;
    private Thread thread = null;

    public OwProcessStreamSubject(InputStream stream_p, OwActionObserver actionObserver_p, String logPrefix_p, String logMode_p) {
        this.actionObserver = actionObserver_p;
        this.stream = stream_p;
        this.logPrefix = logPrefix_p;
        this.logMode = logMode_p;
    }

    public synchronized Thread start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
        return this.thread;
    }

    public synchronized void stop() {
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            this.actionObserver.log("warn", this.logPrefix + "Could not stop stream-eater thread!", e);
        }
    }

    public void run() {
        ReadableByteChannel chanel = Channels.newChannel(this.stream);
        InputStream chanelInputStream = Channels.newInputStream(chanel);
        InputStreamReader streamReader = new InputStreamReader(chanelInputStream);
        BufferedReader buffReader = new BufferedReader(streamReader);
        try {
            String line = null;
            while (!Thread.currentThread().isInterrupted() && (line = buffReader.readLine()) != null) {
                this.actionObserver.log(this.logMode, this.logPrefix + line, null);
            }
        }
        catch (IOException e) {
            this.actionObserver.log("error", this.logPrefix + "Error reading stream!", e);
        }
    }
}

