/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwDocumentImportItemContentCollection;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.plug.owdms.OwSaveDlgDialog;
import com.wewebu.ow.server.plug.owdms.OwSaveDlgDocument;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.util.List;

public class OwSaveDialog
extends OwSaveDlgDialog {
    protected static final int DIALOG_STATUS_NONE = 0;
    protected static final int DIALOG_STATUS_OK = 1;
    protected static final int DIALOG_STATUS_FAILED = 2;
    protected int m_dialogStatus = 0;

    public OwSaveDialog(OwObject saveObject_p, List documentImporters_p) throws Exception {
        super(saveObject_p.getResource(), true, documentImporters_p);
        ((OwSaveDlgDocument)this.getDocument()).setObjectTemplate(saveObject_p);
    }

    public int getStatus() {
        return this.m_dialogStatus;
    }

    public String getTitle() {
        String strTitle = this.getContext().localize("owsavedialog.OwSaveDialog.title", "Save Document:");
        try {
            strTitle = strTitle + OwHTMLHelper.encodeToSecureHTML((String)this.getCurrentDocument().getObjectTemplate().getName());
        }
        catch (IOException ex) {
            strTitle = strTitle + this.getCurrentDocument().getObjectTemplate().getName().replaceAll("[:<:]", "&#60;").replaceAll("[:>:]", "&#62;");
        }
        return strTitle;
    }

    @Override
    protected void performSave() throws Exception {
        try {
            OwDocumentImportItem documentImportItem = this.getCurrentDocument().getImportedDocument();
            if (documentImportItem == null) {
                throw new IllegalStateException("OwSaveDialog.performSave() has been invoked without an OwDocumentImportItem set at the OwSaveDlgDocument");
            }
            OwDocumentImportItemContentCollection contentCollection = new OwDocumentImportItemContentCollection(documentImportItem);
            OwObject obj = this.getCurrentDocument().getObjectTemplate();
            if (obj.hasVersionSeries()) {
                obj.getVersion().save((OwContentCollection)contentCollection, documentImportItem.getContentMimeType(0), documentImportItem.getContentMimeParameter(0));
            } else {
                obj.setContentCollection((OwContentCollection)contentCollection);
            }
            this.openPostProcessingView(this.getCurrentDocument().getDocumentImporter(), obj);
            documentImportItem.release();
        }
        catch (Exception e) {
            this.m_dialogStatus = 2;
            throw e;
        }
        this.close();
    }

    private void close() throws Exception {
        if (!this.isPostProcessDialogOpen()) {
            this.m_dialogStatus = 1;
            this.cleanup();
            this.closeDialog();
        }
    }

    @Override
    protected void onPostProcessDialogClose(OwDialog dialog_p) throws Exception {
        this.close();
    }
}

