/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsearch;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.plug.owsearch.OwSearchView;
import com.wewebu.ow.server.plug.owsearch.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtilPlaceholderFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwSearchDocument
extends OwMasterDocument
implements OwObjectListView.OwObjectListViewEventListner {
    private static final String CONFIG_NODE_PAGEABLE = "pageable";
    boolean pageSearchEnabled = false;
    private static final Logger LOG = OwLog.getLogger(OwSearchDocument.class);
    public static final String CONFIG_NODE_ENABLEDDOCUMENTFUNCTIONS = "EnabledDocumentFunctions";
    public static final String PLUGIN_LIST_ENABLED_ATTRIBUTE = "enable";
    OwObjectCollection m_SearchResultList;
    OwIterable<OwObject> m_searchResultIterable;
    private int m_iActiveSearchTemplateIndex = -1;
    private HashMap m_TemplateMap = new HashMap();
    private Collection m_OrderedTemplateVector = new Vector();
    private OwRepositorySearchTemplate m_ActiveTemplate;
    private OwNavigationView m_navView;
    private int m_lastMaxListSize;
    private OwSort m_lastSort;

    private OwObjectListView getObjectListView() {
        return ((OwSearchView)this.getMasterView()).getObjectListView();
    }

    protected Map getRepositories() {
        HashMap<String, Object> repositories = new HashMap<String, Object>();
        repositories.put("OW_HISTORY", ((OwMainAppContext)this.getContext()).getHistoryManager());
        repositories.put("OW_ECM_ADAPTER", ((OwMainAppContext)this.getContext()).getNetwork());
        return repositories;
    }

    protected void init() throws Exception {
        super.init();
        Iterator itReps = this.getConfigNode().getSafeNodeList("SearchTemplates").iterator();
        while (itReps.hasNext()) {
            OwStandardXMLUtil repositoryNode = new OwStandardXMLUtil((Node)itReps.next());
            String repName = repositoryNode.getSafeStringAttributeValue("repname", null);
            OwRepository repository = (OwRepository)this.getRepositories().get(repName);
            if (repository == null) {
                String msg = "OwSearchDocument.init: Repository is not existing, name = " + repName;
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.repositorynotdefined", "Das Repository existiert nicht:") + " " + repName);
            }
            String strSearchTemplates = repositoryNode.getNode().getFirstChild().getNodeValue();
            if (strSearchTemplates == null) {
                String msg = "OwSearchDocument.init: Search template category has not been defined at the Search Plugin.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.templatesnotdefined", "Es wurde keine Suchtemplatekategory im Suchen Plugin definiert."));
            }
            Collection SearchTemplateObjects = ((OwMainAppContext)this.getContext()).getNetwork().getApplicationObjects(3, strSearchTemplates, false);
            if (SearchTemplateObjects == null) continue;
            for (OwSearchTemplate searchtemplate : SearchTemplateObjects) {
                try {
                    OwRepositorySearchTemplate reptemplate = new OwRepositorySearchTemplate(searchtemplate, repository);
                    this.m_OrderedTemplateVector.add(reptemplate);
                    if (this.m_TemplateMap.containsKey(reptemplate.getName())) {
                        String msg = "OwSearchDocument.init: Name of searchtemplate is already assigned, RepositorySearchTemplate = " + reptemplate.getName() + ", SearchTemplate = " + searchtemplate.getName();
                        LOG.warn((Object)msg);
                        throw new OwConfigurationException(this.getContext().localize1("owsearch.OwSearchDocument.namealreadydefined", "Name of search form is already assigned: %1", reptemplate.getName()));
                    }
                    this.m_TemplateMap.put(reptemplate.getName(), reptemplate);
                }
                catch (Exception e) {
                    String msg = "OwSearchDocument.init: Search form could not be loaded, SearchTemplate = " + searchtemplate.getName();
                    LOG.error((Object)msg, (Throwable)e);
                    throw new OwConfigurationException(this.getContext().localize1("owsearch.OwSearchDocument.searchtemplateload_failed", "Search form could not be loaded: %1", searchtemplate.getName()), (Throwable)e);
                }
            }
        }
    }

    public OwSearchTemplate setSearchTemplatName(String strSearchTemplateName_p) throws Exception {
        OwRepositorySearchTemplate newtemplate = (OwRepositorySearchTemplate)this.m_TemplateMap.get(strSearchTemplateName_p);
        if (newtemplate != this.m_ActiveTemplate) {
            OwSort sort = newtemplate.getSearchTemplate().getSort(((OwMainAppContext)this.getContext()).getMaxSortCriteriaCount());
            this.getObjectListView().setSort(sort);
        }
        this.m_ActiveTemplate = newtemplate;
        return this.m_ActiveTemplate.getSearchTemplate();
    }

    public OwSearchTemplate getCurrentSearchTemplate() throws Exception {
        return this.m_ActiveTemplate.getSearchTemplate();
    }

    public Collection getSearchTemplates() throws Exception {
        return this.m_OrderedTemplateVector;
    }

    protected OwSort getFilteredSort(OwSort sort_p, Collection properties_p) {
        OwSort Sort = new OwSort(sort_p.getMaxSize(), sort_p.getDefaultAsc());
        for (OwSort.OwSortCriteria Criteria : sort_p.getCriteriaCollection()) {
            if (!properties_p.contains(Criteria.getPropertyName())) continue;
            Sort.addCriteria(Criteria);
        }
        return Sort;
    }

    public void setNavigationView(OwNavigationView navView_p) {
        this.m_navView = navView_p;
    }

    public boolean canGoBackToSearchTemplate() {
        return this.m_iActiveSearchTemplateIndex != -1;
    }

    public void goBackToSearchTemplate() throws Exception {
        if (this.canGoBackToSearchTemplate()) {
            this.m_navView.navigate(this.m_iActiveSearchTemplateIndex);
        }
    }

    public void doSearch(int iMaxListSize_p) throws Exception {
        this.doSearch(iMaxListSize_p, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSearch(int iMaxListSize_p, OwSort sort) throws Exception {
        this.m_iActiveSearchTemplateIndex = this.m_navView.getNavigationIndex();
        OwObjectListView objectListView = this.getObjectListView();
        objectListView.setColumnInfo(this.m_ActiveTemplate.getSearchTemplate().getColumnInfoList());
        Collection PropertyNames = objectListView.getRetrievalPropertyNames();
        OwSort newSort = sort;
        if (newSort == null) {
            newSort = this.getFilteredSort(objectListView.getSort(), PropertyNames);
        }
        objectListView.setSort(newSort);
        boolean pageSearchEnabled = this.isPageable();
        if (pageSearchEnabled) {
            if (!(objectListView instanceof OwPageableListView)) throw new OwNotSupportedException("List view type does not support page-search : " + objectListView.getClass() + ". " + OwPageableListView.class.getName() + " extension expected.");
            if (!this.m_ActiveTemplate.getRepository().canPageSearch()) throw new OwNotSupportedException("The repository does not support page search.");
            OwLoadContext loadContext = new OwLoadContext();
            loadContext.setSorting(newSort);
            loadContext.setPropertyNames(PropertyNames);
            loadContext.setMaxSize((long)iMaxListSize_p);
            loadContext.setVersionSelection(this.m_ActiveTemplate.getSearchTemplate().getVersionSelection());
            this.m_searchResultIterable = this.m_ActiveTemplate.getRepository().doSearch(this.m_ActiveTemplate.getSearchTemplate().getSearch(false), loadContext);
            this.m_SearchResultList = null;
            ((OwPageableListView)objectListView).setObjectIterable(this.m_searchResultIterable, null);
        } else {
            this.m_SearchResultList = this.m_ActiveTemplate.getRepository().doSearch(this.m_ActiveTemplate.getSearchTemplate().getSearch(false), newSort, PropertyNames, iMaxListSize_p, this.m_ActiveTemplate.getSearchTemplate().getVersionSelection());
            this.m_searchResultIterable = null;
            objectListView.setObjectList(this.m_SearchResultList, null);
        }
        objectListView.setCurrentPage(0);
        this.m_lastSort = newSort;
        this.m_lastMaxListSize = iMaxListSize_p;
    }

    boolean isPageable() {
        return this.getConfigNode().getSafeBooleanValue(CONFIG_NODE_PAGEABLE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeatLastSearch() throws Exception {
        int activeSearchTemplateIndex = this.m_iActiveSearchTemplateIndex;
        try {
            OwObjectListView objectListView = this.getObjectListView();
            int currentPage = objectListView.getCurrentPage();
            this.doSearch(this.m_lastMaxListSize, this.m_lastSort);
            objectListView.setCurrentPage(currentPage);
        }
        finally {
            this.m_iActiveSearchTemplateIndex = activeSearchTemplateIndex;
        }
    }

    public Object onDispatch(int iCode_p, Object param1_p, Object param2_p) throws Exception {
        switch (iCode_p) {
            case 1: {
                Map parameterMap = (Map)param2_p;
                StringTokenizer param1tokenizer = new StringTokenizer((String)param1_p, ",");
                String sTemplateName = param1tokenizer.nextToken();
                int iMaxSize = Integer.parseInt(param1tokenizer.nextToken());
                ((OwSearchView)this.getMasterView()).navigate(sTemplateName);
                OwSearchNode searchNode = this.getCurrentSearchTemplate().getSearch(true);
                if (this.isFullTextSearch(parameterMap, searchNode)) {
                    LOG.error((Object)"The Search Template contains a full text search. Full text search is not supported from a remote plugin call.");
                    this.getMasterView().activate();
                    throw new OwNotSupportedException(this.getContext().localize("owsearch.OwSearchDocument.fulltextsearch_not_supported", "Full text search is not supported from a remote plugin call."));
                }
                Map criterias = searchNode.getCriteriaMap(0);
                for (Map.Entry mapEntry : criterias.entrySet()) {
                    OwSearchCriteria critEntry = (OwSearchCriteria)mapEntry.getValue();
                    int attribute = critEntry.getAttributes() % 4;
                    if (attribute != 0 && attribute < 4) continue;
                    critEntry.setValue(critEntry.getDefaultValue());
                }
                for (Map.Entry mapEntry : parameterMap.entrySet()) {
                    OwSearchCriteria crit = (OwSearchCriteria)criterias.get(mapEntry.getKey());
                    if (null == crit) {
                        throw new OwInvalidOperationException("OwSearchDocument.onDispatch: Property = " + mapEntry.getKey() + " not found");
                    }
                    crit.setValue(crit.getFieldDefinition().getValueFromString((String)mapEntry.getValue()));
                }
                this.doSearch(iMaxSize);
                this.update((OwEventTarget)this, 0, null);
                if (this.isAutoOpenSingleRecord()) break;
                this.getMasterView().activate();
                break;
            }
            case 16: {
                OwSearchView searchView = (OwSearchView)this.getMasterView();
                searchView.navigate((String)param1_p);
                OwSearchTemplate searchtemplate = this.getCurrentSearchTemplate();
                searchtemplate.setSavedSearch((String)param2_p);
                searchView.updateSearchCriteria(searchtemplate);
            }
        }
        return null;
    }

    private boolean isFullTextSearch(Map parameterMap_p, OwSearchNode searchNode_p) {
        boolean result = false;
        OwSearchNode cbrNode = searchNode_p.findSearchNode(3);
        if (cbrNode != null) {
            Map contentBasedCriteria = cbrNode.getCriteriaMap(0);
            for (String sPropertyName : parameterMap_p.keySet()) {
                OwSearchCriteria crit = (OwSearchCriteria)contentBasedCriteria.get(sPropertyName);
                if (null == crit) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public int getResultSize() {
        if (this.m_searchResultIterable != null) {
            return (int)this.m_searchResultIterable.getTotalNumItems();
        }
        if (this.m_SearchResultList != null) {
            return this.m_SearchResultList.size();
        }
        return 0;
    }

    public OwObject getResultObject(int index) {
        int iSize;
        if (this.m_searchResultIterable != null) {
            OwIterable page = this.m_searchResultIterable.skipTo((long)index);
            Iterator i = page.iterator();
            if (i.hasNext()) {
                return (OwObject)i.next();
            }
        } else if (this.m_SearchResultList != null && (iSize = this.m_SearchResultList.size()) > index) {
            return (OwObject)this.m_SearchResultList.get(index);
        }
        return null;
    }

    public OwIterable<OwObject> getResultIterable() {
        return this.m_searchResultIterable;
    }

    public OwObjectCollection getResultList() {
        return this.m_SearchResultList;
    }

    protected boolean autoOpenFirstObject(OwObject obj_p, int iSize_p) {
        if (OwStandardObjectClass.isContainerType((int)obj_p.getType())) {
            return iSize_p == 1 && this.isAutoOpenSingleRecord();
        }
        return this.isAutoOpenFirstDocument();
    }

    protected boolean isAutoOpenSingleRecord() {
        return this.getConfigNode().getSafeBooleanValue("AutoOpenSingleRecord", false);
    }

    protected boolean isAutoOpenFirstDocument() {
        return this.getConfigNode().getSafeBooleanValue("AutoOpenFirstDocument", false);
    }

    protected OwXMLUtil getDocumentFunctionsNode() throws Exception {
        Node xmlNode = this.getConfigNode().getSubNode(CONFIG_NODE_ENABLEDDOCUMENTFUNCTIONS);
        return xmlNode == null ? null : new OwXMLUtilPlaceholderFilter(xmlNode, (OwAttributeBag)((OwMainAppContext)this.getContext()).getConfiguration());
    }

    public void onObjectListViewFilterChange(OwSearchNode filterNode_p, OwObject parent_p) throws Exception {
    }

    public String onObjectListViewGetRowClassName(int iIndex_p, OwObject obj_p) {
        return null;
    }

    public boolean onObjectListViewItemClick(OwObject obj_p) throws Exception {
        return false;
    }

    public void onObjectListViewSelect(OwObject object_p, OwObject parent_p) throws Exception {
    }

    public void onObjectListViewSort(OwSort newSort_p, String strSortProperty_p) throws Exception {
        OwObjectListView objectListView = this.getObjectListView();
        int currentPage = objectListView.getCurrentPage();
        this.doSearch(this.m_lastMaxListSize, newSort_p);
        objectListView.setCurrentPage(currentPage);
    }

    public class OwRepositorySearchTemplate {
        protected OwSearchTemplate m_searchTemplate;
        protected OwRepository m_repository;

        public OwRepositorySearchTemplate(OwSearchTemplate searchTemplate_p, OwRepository repository_p) {
            this.m_searchTemplate = searchTemplate_p;
            this.m_repository = repository_p;
        }

        public OwSearchTemplate getSearchTemplate() throws Exception {
            if (!this.m_searchTemplate.isInitalized()) {
                this.m_searchTemplate.init((OwFieldDefinitionProvider)this.m_repository);
            }
            return this.m_searchTemplate;
        }

        public OwRepository getRepository() {
            return this.m_repository;
        }

        public String getName() throws Exception {
            return this.m_searchTemplate.getName();
        }

        public String getDisplayName(Locale locale_p) throws Exception {
            return this.m_searchTemplate.getDisplayName(locale_p);
        }

        public String getIcon() throws Exception {
            return this.m_searchTemplate.getIcon();
        }
    }
}

