/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owsearch;

import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwInsertLabelHelper;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwMaxMinButtonControlView;
import com.wewebu.ow.server.app.OwSearchCriteriaView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.plug.owsearch.OwSearchDocument;
import com.wewebu.ow.server.plug.owsearch.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwKeyAction;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwOSFamilyKeyAction;
import com.wewebu.ow.server.ui.OwOSFamilyKeyCodeSetting;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwSearchTemplateView
extends OwLayout {
    private static final Logger LOG = OwLog.getLogger(OwSearchTemplateView.class);
    public static final int MAX_SIZE_REGION = 1;
    public static final int BUTTON_REGION = 2;
    public static final int TEMPLATE_REGION = 3;
    public static final int MIN_MAX_CONTROL_VIEW = 4;
    public static final int DEBUG_SEARCH_DUMP_REGION = 5;
    public static final int SAVED_SEARCHES_SELECT_REGION = 6;
    public static final int SAVED_SEARCH_DELETE_BUTTON_REGION = 9;
    public static final int DEFAULT_RESULT_SIZE = 50;
    public static final int ERRORS_REGION = 10;
    private static final String SELECTED_SAVED_SEARCH_KEY = "owselectedsavesearch";
    protected static final String MAX_RESULT_LIST_KEY = "reslistsize";
    private static final String NOTHING_SELECTED = "nothing_selected";
    protected static final String SEARCH_LABEL_ID = "owsearch.OwSearchTemplateView.search";
    protected static final String RESET_LABEL_ID = "owsearch.OwSearchTemplateView.reset";
    protected int m_iMaxSizeMax;
    protected int m_iMaxSize;
    protected OwSubMenuView m_MenuView;
    protected OwMaxMinButtonControlView m_MaxMinButtonControlView;
    protected OwSearchCriteriaView m_SearchCriteriaView;
    protected int m_iSubmitBtnIndex;
    protected int m_iResetBtnIndex;
    private OwOSFamilyKeyCodeSetting searchKeySettings;
    private OwOSFamilyKeyCodeSetting resetKeySettings;

    protected void init() throws Exception {
        super.init();
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 2, null);
        this.m_SearchCriteriaView = this.createSearchCriteriaView();
        this.m_SearchCriteriaView.setExternalFormTarget(this.getFormTarget());
        this.addView((OwView)this.m_SearchCriteriaView, 3, null);
        this.m_iSubmitBtnIndex = this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize(SEARCH_LABEL_ID, "Search"), "DoSearch", null);
        this.m_iResetBtnIndex = this.m_MenuView.addMenuItem((OwEventTarget)this, this.getContext().localize(RESET_LABEL_ID, "Reset"), "DoReset", null);
        this.m_MaxMinButtonControlView = new OwMaxMinButtonControlView((OwView)this);
        this.addView((OwView)this.m_MaxMinButtonControlView, 4, null);
        this.m_iMaxSizeMax = ((OwMasterDocument)this.getDocument()).getConfigNode().getSafeIntegerValue("MaxSizeMax", 200);
        OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode osX = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.OS_X, 13, 0);
        OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode win = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.WINDOWS, 13, 0);
        OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode unknown = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.UNKNOWN, 13, 0);
        this.searchKeySettings = new OwOSFamilyKeyCodeSetting(SEARCH_LABEL_ID, new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode[]{osX, win, unknown});
        osX = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.OS_X, 13, 2048);
        win = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.WINDOWS, 13, 512);
        unknown = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(OwOSFamily.UNKNOWN, 13, 512);
        this.resetKeySettings = new OwOSFamilyKeyCodeSetting(RESET_LABEL_ID, new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode[]{osX, win, unknown});
    }

    public String getTitle() {
        return this.getContext().localize("plug.owsearch.OwSearchTemplateView.title", "Search Template");
    }

    protected void onActivate(int iIndex_p, Object oReason_p) throws Exception {
        OwSearchTemplate templateObject = ((OwSearchDocument)this.getDocument()).setSearchTemplatName((String)oReason_p);
        this.updateSearchTemplate(templateObject);
    }

    protected void updateSearchCriteriaView(OwSearchTemplate templateObject_p) throws Exception {
        this.m_SearchCriteriaView.resetErrors();
        if (templateObject_p != null) {
            List criteriaList = templateObject_p.getSearch(false).getCriteriaList(1);
            this.m_SearchCriteriaView.setCriteriaList(criteriaList);
            this.m_SearchCriteriaView.setHTMLFormular(templateObject_p.getHtmlLayout());
            this.m_SearchCriteriaView.setJspFormular(templateObject_p.getJspLayoutPage());
            this.m_SearchCriteriaView.setFieldProvider((OwFieldProvider)templateObject_p);
        } else {
            this.m_SearchCriteriaView.setCriteriaList(null);
            this.m_SearchCriteriaView.setHTMLFormular(null);
            this.m_SearchCriteriaView.setJspFormular(null);
            this.m_SearchCriteriaView.setFieldProvider(null);
        }
    }

    protected void updateSearchTemplate(OwSearchTemplate templateObject_p) throws Exception {
        if (templateObject_p != null) {
            this.m_SearchCriteriaView.resetErrors();
            if (((OwSearchDocument)this.getDocument()).getConfigNode().getSafeBooleanValue("AlwaysClearCriteria", false)) {
                this.m_SearchCriteriaView.setCriteriaList(templateObject_p.getSearch(true).getCriteriaList(1));
            } else {
                this.m_SearchCriteriaView.setCriteriaList(templateObject_p.getSearch(false).getCriteriaList(1));
            }
            this.m_SearchCriteriaView.setHTMLFormular(templateObject_p.getHtmlLayout());
            this.m_SearchCriteriaView.setJspFormular(templateObject_p.getJspLayoutPage());
            this.m_SearchCriteriaView.setFieldProvider((OwFieldProvider)templateObject_p);
        } else {
            this.m_SearchCriteriaView.setCriteriaList(null);
            this.m_SearchCriteriaView.setHTMLFormular(null);
            this.m_SearchCriteriaView.setJspFormular(null);
            this.m_SearchCriteriaView.setFieldProvider(null);
        }
    }

    protected String usesFormWithAttributes() {
        return "action='" + this.m_MenuView.getNavigationFormAction(this.m_iSubmitBtnIndex) + "'";
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owsearch/OwSearchTemplateView.jsp", w_p);
        String searchUrl = this.getFormEventURL("DoSearch", null);
        String resetUrl = this.getFormEventURL("DoReset", null);
        OwOSFamilyKeyAction searchAction = new OwOSFamilyKeyAction(this.searchKeySettings, searchUrl, this.getContext().localize(SEARCH_LABEL_ID, "Search"));
        OwOSFamilyKeyAction resetAction = new OwOSFamilyKeyAction(this.resetKeySettings, resetUrl, this.getContext().localize(RESET_LABEL_ID, "Reset"));
        this.getContext().registerKeyAction((OwKeyAction)searchAction);
        this.getContext().registerKeyAction((OwKeyAction)resetAction);
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 10: {
                this.m_SearchCriteriaView.renderRegion(w_p, 9);
                break;
            }
            case 9: {
                w_p.write("<input type=\"button\" onclick=\"");
                w_p.write(this.getFormEventURL("DeleteSearch", null));
                w_p.write("\" value='");
                String deleteSavedSearchTooltip = this.getContext().localize("plug.owsearch.OwSearchTemplateView.deletesearchtooltip", "Delete saved search");
                w_p.write(deleteSavedSearchTooltip);
                w_p.write("'/>");
                break;
            }
            case 6: {
                if (!this.isEnabledStoredSearch()) break;
                this.renderSavedSearchesRegion(w_p);
                break;
            }
            case 1: {
                if (this.isPageable()) break;
                this.renderMaxSizeRegion(w_p);
                break;
            }
            case 5: {
                OwSearchTemplate TemplateObject = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
                if (TemplateObject == null) break;
                TemplateObject.getSearch(false).dump(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private void renderMaxSizeRegion(Writer w_p) throws IOException {
        w_p.write("\n<div class=\"OwPropertyBlock\"><div class=\"OwPropertyLabel\"><label for=\"maxresultlistsizeId\">");
        w_p.write(this.getContext().localize("owsearch.OwSearchTemplateView.maxresultlistsize", "Maximum number of results"));
        w_p.write("</label></div><div class=\"OwPropertyValue\"><input id=\"maxresultlistsizeId\" type=\"text\" class=\"DefaultInput\" size=\"4\" name=\"");
        w_p.write(MAX_RESULT_LIST_KEY);
        w_p.write("\" value=\"");
        w_p.write(String.valueOf(this.getQueryMaxSize()));
        w_p.write("\"></div></div>\n");
    }

    private void renderSavedSearchesRegion(Writer w_p) throws Exception {
        OwSearchTemplate searchtemplate = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
        if (null == searchtemplate) {
            return;
        }
        Collection searches = searchtemplate.getSavedSearches();
        if (null == searches || searches.size() == 0) {
            return;
        }
        w_p.write("<script>\n");
        w_p.write("     function selectSavedSearch(){\n");
        w_p.write(this.getFormEventURL("SelectSavedSearch", null));
        w_p.write("\n      }\n");
        w_p.write("</script>\n");
        LinkedList<OwDefaultComboItem> comboItems = new LinkedList<OwDefaultComboItem>();
        comboItems.add(new OwDefaultComboItem(NOTHING_SELECTED, this.getContext().localize("plug.owsearch.OwSearchTemplateView.savedsearcheselectinfo", "Saved searches are available...")));
        for (String name : searches) {
            StringWriter writer = new StringWriter();
            OwHTMLHelper.writeSecureHTML((Writer)writer, (String)name);
            OwDefaultComboItem item = new OwDefaultComboItem(name, writer.toString());
            comboItems.add(item);
        }
        OwDefaultComboModel model = new OwDefaultComboModel(false, false, searchtemplate.getSavedSearch(), comboItems);
        OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer((OwComboModel)model, SELECTED_SAVED_SEARCH_KEY, null, null, new OwString("plug.owsearch.OwSearchTemplateView.saved.searches.title", "Saved searches"));
        renderer.addEvent("onchange", "selectSavedSearch()");
        String displayName = this.getContext().localize("OwSearchTemplateView.selectSavedSearch", "Select saved search");
        OwInsertLabelHelper.insertLabelValue((Writer)w_p, (String)displayName, (String)SELECTED_SAVED_SEARCH_KEY);
        renderer.renderCombo(w_p);
    }

    public boolean isRegion(int region_p) {
        OwSearchDocument doc = (OwSearchDocument)this.getDocument();
        switch (region_p) {
            case 9: {
                try {
                    Collection savedSearches = doc.getCurrentSearchTemplate().getSavedSearches();
                    if (savedSearches.isEmpty()) {
                        doc.getCurrentSearchTemplate().setSavedSearch(null);
                        return false;
                    }
                    String savedSearch = doc.getCurrentSearchTemplate().getSavedSearch();
                    boolean canDelete = doc.getCurrentSearchTemplate().canDeleteSearch();
                    return savedSearch != null && canDelete;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case 6: {
                try {
                    return doc.getCurrentSearchTemplate().getSavedSearches().size() > 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return super.isRegion(region_p);
    }

    public void onDeleteSearch(HttpServletRequest request_p) throws Exception {
        OwSearchTemplate searchtemplate = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
        if (null == searchtemplate) {
            return;
        }
        String name = request_p.getParameter(SELECTED_SAVED_SEARCH_KEY);
        if (null != name && name.length() > 0 && !NOTHING_SELECTED.equalsIgnoreCase(name)) {
            searchtemplate.deleteSavedSearch(name);
        }
    }

    public void onSelectSavedSearch(HttpServletRequest request_p) throws Exception {
        OwSearchTemplate searchtemplate = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
        if (null == searchtemplate) {
            return;
        }
        String name = request_p.getParameter(SELECTED_SAVED_SEARCH_KEY);
        if (null != name && name.length() == 0 || NOTHING_SELECTED.equalsIgnoreCase(name)) {
            name = null;
        }
        searchtemplate.setSavedSearch(name);
        this.updateSearchTemplate(searchtemplate);
    }

    public void onDoReset(HttpServletRequest request_p) throws Exception {
        this.onDoReset(request_p, null);
    }

    public void onDoReset(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwSearchTemplate TemplateObject = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate();
        if (TemplateObject != null) {
            this.m_SearchCriteriaView.setCriteriaList(TemplateObject.getSearch(true).getCriteriaList(1));
            this.m_SearchCriteriaView.setJspFormular(TemplateObject.getJspLayoutPage());
            this.m_SearchCriteriaView.setHTMLFormular(TemplateObject.getHtmlLayout());
        }
    }

    public void onDoSearch(HttpServletRequest request_p) throws Exception {
        this.onDoSearch(request_p, null);
    }

    public void onDoSearch(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (!this.m_SearchCriteriaView.onSubmitSearch(request_p)) {
            return;
        }
        OwAttributeBagWriteable attributes = this.getDocument().getPersistentAttributeBagWriteable();
        String currentSearchTemplateName = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate().getName();
        attributes.setAttribute("OwSearchView_LastTemplate", (Object)currentSearchTemplateName);
        attributes.save();
        try {
            String size = request_p.getParameter(MAX_RESULT_LIST_KEY);
            if (size != null) {
                this.setQueryMaxSize(Integer.parseInt(size));
            }
        }
        catch (NumberFormatException e) {
            throw new OwInvalidOperationException(this.getContext().localize1("plug.owsearch.OwSearchTemplateView.maxsizeexceeded", "Maximum number of results must be set between 1 to %1", String.valueOf(this.m_iMaxSizeMax)), (Throwable)e);
        }
        ((OwSearchDocument)this.getDocument()).doSearch(this.getQueryMaxSize());
        this.getDocument().update((OwEventTarget)this, 0, null);
    }

    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return this.m_SearchCriteriaView.updateExternalFormTarget(request_p, fSave_p);
    }

    protected OwSearchCriteriaView createSearchCriteriaView() {
        return new OwSearchCriteriaView();
    }

    protected boolean isEnabledStoredSearch() {
        return ((OwSearchDocument)this.getDocument()).getConfigNode().getSafeBooleanValue("EnableStoredSearches", true);
    }

    protected boolean isPageable() {
        return ((OwSearchDocument)this.getDocument()).isPageable();
    }

    protected int getQueryMaxSize() {
        if (this.m_iMaxSize > 0) {
            return this.m_iMaxSize;
        }
        try {
            int tempSize = ((OwSearchDocument)this.getDocument()).getCurrentSearchTemplate().getDefaultMaxSize();
            return tempSize > this.m_iMaxSizeMax ? this.m_iMaxSizeMax : (tempSize > 0 ? tempSize : 50);
        }
        catch (Exception e) {
            LOG.warn((Object)"Faild to get max size of current searchtemplate, set back to default");
            return 50;
        }
    }

    protected void setQueryMaxSize(int newMax_p) throws OwInvalidOperationException {
        if (this.m_iMaxSize >= 0) {
            this.m_iMaxSize = newMax_p;
        } else {
            int currentDefault = this.getQueryMaxSize();
            if (50 != newMax_p && currentDefault != newMax_p) {
                this.m_iMaxSize = newMax_p;
            }
        }
        if (this.m_iMaxSize > this.m_iMaxSizeMax || this.m_iMaxSize <= 0) {
            this.setQueryMaxSize(this.m_iMaxSizeMax);
            throw new OwInvalidOperationException(this.getContext().localize1("plug.owsearch.OwSearchTemplateView.maxsizeexceeded", "Maximum number of files is limited to %1", String.valueOf(this.m_iMaxSizeMax)));
        }
    }
}

