/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import com.sun.xml.ws.developer.StreamingDataHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.DateTimeResolution;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ExtensionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisACLCapabilityType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisACLType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlPrincipalType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChangeEventType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceBoolean;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceDateTime;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceDecimal;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceHtml;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceInteger;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceString;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisChoiceUri;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisListOfIdsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderContainerType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectParentsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPermissionDefinition;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPermissionMapping;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisProperty;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyBoolean;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyBooleanDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDateTime;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDateTimeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDecimal;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDecimalDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyHtml;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyHtmlDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyIdDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyInteger;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyIntegerDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyString;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyStringDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyUri;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyUriDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryCapabilitiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeContainer;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDocumentDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeFolderDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypePolicyDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeRelationshipDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumACLPropagation;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumAllowableActionsKey;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBaseObjectTypeIds;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityACL;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityChanges;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityJoin;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityQuery;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCapabilityRendition;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumCardinality;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumDateTimeResolution;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumPropertyType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumSupportedPermissions;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumTypeOfChanges;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUpdatability;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Converter {
    private static final String DEFAULT_EXTENSION_NS = "http://chemistry.apache.org/opencmis/extension";
    private static final int BUFFER_SIZE = 65536;

    private Converter() {
    }

    public static RepositoryInfo convert(CmisRepositoryInfoType repositoryInfo) {
        if (repositoryInfo == null) {
            return null;
        }
        RepositoryInfoImpl result = new RepositoryInfoImpl();
        result.setAclCapabilities(Converter.convert(repositoryInfo.getAclCapability()));
        result.setChangesIncomplete(repositoryInfo.isChangesIncomplete());
        ArrayList<BaseTypeId> baseObjectTypeIds = new ArrayList<BaseTypeId>();
        for (EnumBaseObjectTypeIds bot : repositoryInfo.getChangesOnType()) {
            baseObjectTypeIds.add(Converter.convert(BaseTypeId.class, bot));
        }
        result.setChangesOnType(baseObjectTypeIds);
        result.setCmisVersionSupported(repositoryInfo.getCmisVersionSupported());
        result.setLatestChangeLogToken(repositoryInfo.getLatestChangeLogToken());
        result.setPrincipalAnonymous(repositoryInfo.getPrincipalAnonymous());
        result.setPrincipalAnyone(repositoryInfo.getPrincipalAnyone());
        result.setProductName(repositoryInfo.getProductName());
        result.setProductVersion(repositoryInfo.getProductVersion());
        result.setCapabilities(Converter.convert(repositoryInfo.getCapabilities()));
        result.setDescription(repositoryInfo.getRepositoryDescription());
        result.setId(repositoryInfo.getRepositoryId());
        result.setName(repositoryInfo.getRepositoryName());
        result.setRootFolder(repositoryInfo.getRootFolderId());
        result.setThinClientUri(repositoryInfo.getThinClientURI());
        result.setVendorName(repositoryInfo.getVendorName());
        Converter.convertExtension(repositoryInfo, result);
        return result;
    }

    public static RepositoryCapabilities convert(CmisRepositoryCapabilitiesType capabilities) {
        if (capabilities == null) {
            return null;
        }
        RepositoryCapabilitiesImpl result = new RepositoryCapabilitiesImpl();
        result.setAllVersionsSearchable(capabilities.isCapabilityAllVersionsSearchable());
        result.setCapabilityAcl(Converter.convert(CapabilityAcl.class, capabilities.getCapabilityACL()));
        result.setCapabilityChanges(Converter.convert(CapabilityChanges.class, capabilities.getCapabilityChanges()));
        result.setCapabilityContentStreamUpdates(Converter.convert(CapabilityContentStreamUpdates.class, capabilities.getCapabilityContentStreamUpdatability()));
        result.setCapabilityJoin(Converter.convert(CapabilityJoin.class, capabilities.getCapabilityJoin()));
        result.setCapabilityQuery(Converter.convert(CapabilityQuery.class, capabilities.getCapabilityQuery()));
        result.setCapabilityRendition(Converter.convert(CapabilityRenditions.class, capabilities.getCapabilityRenditions()));
        result.setIsPwcSearchable(capabilities.isCapabilityPWCSearchable());
        result.setIsPwcUpdatable(capabilities.isCapabilityPWCUpdatable());
        result.setSupportsGetDescendants(capabilities.isCapabilityGetDescendants());
        result.setSupportsGetFolderTree(capabilities.isCapabilityGetFolderTree());
        result.setSupportsMultifiling(capabilities.isCapabilityMultifiling());
        result.setSupportsUnfiling(capabilities.isCapabilityUnfiling());
        result.setSupportsVersionSpecificFiling(capabilities.isCapabilityVersionSpecificFiling());
        Converter.convertExtension(capabilities, result);
        return result;
    }

    public static AclCapabilities convert(CmisACLCapabilityType aclCapabilities) {
        if (aclCapabilities == null) {
            return null;
        }
        AclCapabilitiesDataImpl result = new AclCapabilitiesDataImpl();
        result.setSupportedPermissions(Converter.convert(SupportedPermissions.class, aclCapabilities.getSupportedPermissions()));
        result.setAclPropagation(Converter.convert(AclPropagation.class, aclCapabilities.getPropagation()));
        ArrayList<PermissionDefinition> permissionDefinitionList = new ArrayList<PermissionDefinition>();
        for (CmisPermissionDefinition permDef : aclCapabilities.getPermissions()) {
            PermissionDefinitionDataImpl permDefData = new PermissionDefinitionDataImpl();
            permDefData.setPermission(permDef.getPermission());
            permDefData.setDescription(permDef.getDescription());
            Converter.convertExtension(permDef, permDefData);
            permissionDefinitionList.add(permDefData);
        }
        result.setPermissionDefinitionData(permissionDefinitionList);
        LinkedHashMap<String, PermissionMapping> permissionMapping = new LinkedHashMap<String, PermissionMapping>();
        for (CmisPermissionMapping permMapping : aclCapabilities.getMapping()) {
            if (permMapping.getKey() == null) continue;
            PermissionMappingDataImpl permMappingData = new PermissionMappingDataImpl();
            String key = permMapping.getKey().value();
            permMappingData.setKey(key);
            permMappingData.setPermissions(permMapping.getPermission());
            Converter.convertExtension(permMapping, permMappingData);
            permissionMapping.put(key, permMappingData);
        }
        result.setPermissionMappingData(permissionMapping);
        Converter.convertExtension(aclCapabilities, result);
        return result;
    }

    public static CmisRepositoryInfoType convert(RepositoryInfo repositoryInfo) {
        if (repositoryInfo == null) {
            return null;
        }
        CmisRepositoryInfoType result = new CmisRepositoryInfoType();
        result.setAclCapability(Converter.convert(repositoryInfo.getAclCapabilities()));
        result.setCapabilities(Converter.convert(repositoryInfo.getCapabilities()));
        result.setChangesIncomplete(repositoryInfo.getChangesIncomplete());
        result.setCmisVersionSupported(repositoryInfo.getCmisVersionSupported());
        result.setLatestChangeLogToken(repositoryInfo.getLatestChangeLogToken());
        result.setPrincipalAnonymous(repositoryInfo.getPrincipalIdAnonymous());
        result.setPrincipalAnyone(repositoryInfo.getPrincipalIdAnyone());
        result.setProductName(repositoryInfo.getProductName());
        result.setProductVersion(repositoryInfo.getProductVersion());
        result.setRepositoryDescription(repositoryInfo.getDescription());
        result.setRepositoryId(repositoryInfo.getId());
        result.setRepositoryName(repositoryInfo.getName());
        result.setRootFolderId(repositoryInfo.getRootFolderId());
        result.setThinClientURI(repositoryInfo.getThinClientUri());
        result.setVendorName(repositoryInfo.getVendorName());
        if (repositoryInfo.getChangesOnType() != null) {
            for (BaseTypeId boti : repositoryInfo.getChangesOnType()) {
                result.getChangesOnType().add(Converter.convert(EnumBaseObjectTypeIds.class, boti));
            }
        }
        Converter.convertExtension((ExtensionsData)repositoryInfo, result);
        return result;
    }

    public static CmisRepositoryCapabilitiesType convert(RepositoryCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        CmisRepositoryCapabilitiesType result = new CmisRepositoryCapabilitiesType();
        result.setCapabilityACL(Converter.convert(EnumCapabilityACL.class, capabilities.getAclCapability()));
        result.setCapabilityAllVersionsSearchable(capabilities.isAllVersionsSearchableSupported());
        result.setCapabilityChanges(Converter.convert(EnumCapabilityChanges.class, capabilities.getChangesCapability()));
        result.setCapabilityContentStreamUpdatability(Converter.convert(EnumCapabilityContentStreamUpdates.class, capabilities.getContentStreamUpdatesCapability()));
        result.setCapabilityGetDescendants(capabilities.isGetDescendantsSupported());
        result.setCapabilityGetFolderTree(capabilities.isGetFolderTreeSupported());
        result.setCapabilityJoin(Converter.convert(EnumCapabilityJoin.class, capabilities.getJoinCapability()));
        result.setCapabilityMultifiling(capabilities.isMultifilingSupported());
        result.setCapabilityPWCSearchable(capabilities.isPwcSearchableSupported());
        result.setCapabilityPWCUpdatable(capabilities.isPwcUpdatableSupported());
        result.setCapabilityQuery(Converter.convert(EnumCapabilityQuery.class, capabilities.getQueryCapability()));
        result.setCapabilityRenditions(Converter.convert(EnumCapabilityRendition.class, capabilities.getRenditionsCapability()));
        result.setCapabilityUnfiling(capabilities.isUnfilingSupported());
        result.setCapabilityVersionSpecificFiling(capabilities.isVersionSpecificFilingSupported());
        Converter.convertExtension((ExtensionsData)capabilities, result);
        return result;
    }

    public static CmisACLCapabilityType convert(AclCapabilities aclCapabilities) {
        if (aclCapabilities == null) {
            return null;
        }
        CmisACLCapabilityType result = new CmisACLCapabilityType();
        result.setSupportedPermissions(Converter.convert(EnumSupportedPermissions.class, aclCapabilities.getSupportedPermissions()));
        result.setPropagation(Converter.convert(EnumACLPropagation.class, aclCapabilities.getAclPropagation()));
        if (aclCapabilities.getPermissions() != null) {
            for (PermissionDefinition pdd : aclCapabilities.getPermissions()) {
                CmisPermissionDefinition permDef = new CmisPermissionDefinition();
                permDef.setDescription(pdd.getDescription());
                permDef.setPermission(pdd.getId());
                Converter.convertExtension((ExtensionsData)pdd, permDef);
                result.getPermissions().add(permDef);
            }
        }
        if (aclCapabilities.getPermissionMapping() != null) {
            for (PermissionMapping pmd : aclCapabilities.getPermissionMapping().values()) {
                CmisPermissionMapping permMap = new CmisPermissionMapping();
                permMap.setKey(EnumAllowableActionsKey.fromValue(pmd.getKey()));
                if (pmd.getPermissions() != null) {
                    for (String permission : pmd.getPermissions()) {
                        permMap.getPermission().add(permission);
                    }
                }
                Converter.convertExtension((ExtensionsData)pmd, permMap);
                result.getMapping().add(permMap);
            }
        }
        Converter.convertExtension((ExtensionsData)aclCapabilities, result);
        return result;
    }

    public static TypeDefinition convert(CmisTypeDefinitionType typeDefinition) {
        if (typeDefinition == null) {
            return null;
        }
        AbstractTypeDefinition result = null;
        if (typeDefinition instanceof CmisTypeFolderDefinitionType) {
            result = new FolderTypeDefinitionImpl();
        } else if (typeDefinition instanceof CmisTypeDocumentDefinitionType) {
            result = new DocumentTypeDefinitionImpl();
            ((DocumentTypeDefinitionImpl)result).setContentStreamAllowed(Converter.convert(ContentStreamAllowed.class, ((CmisTypeDocumentDefinitionType)typeDefinition).getContentStreamAllowed()));
            ((DocumentTypeDefinitionImpl)result).setIsVersionable(((CmisTypeDocumentDefinitionType)typeDefinition).isVersionable());
        } else if (typeDefinition instanceof CmisTypeRelationshipDefinitionType) {
            result = new RelationshipTypeDefinitionImpl();
            ((RelationshipTypeDefinitionImpl)result).setAllowedSourceTypes(((CmisTypeRelationshipDefinitionType)typeDefinition).getAllowedSourceTypes());
            ((RelationshipTypeDefinitionImpl)result).setAllowedTargetTypes(((CmisTypeRelationshipDefinitionType)typeDefinition).getAllowedTargetTypes());
        } else if (typeDefinition instanceof CmisTypePolicyDefinitionType) {
            result = new PolicyTypeDefinitionImpl();
        } else {
            throw new CmisRuntimeException("Type '" + typeDefinition.getId() + "' does not match a base type!");
        }
        result.setBaseTypeId(Converter.convert(BaseTypeId.class, typeDefinition.getBaseId()));
        result.setDescription(typeDefinition.getDescription());
        result.setDisplayName(typeDefinition.getDisplayName());
        result.setId(typeDefinition.getId());
        result.setIsControllableAcl(typeDefinition.isControllableACL());
        result.setIsControllablePolicy(typeDefinition.isControllablePolicy());
        result.setIsCreatable(typeDefinition.isCreatable());
        result.setIsFileable(typeDefinition.isFileable());
        result.setIsFulltextIndexed(typeDefinition.isFulltextIndexed());
        result.setIsIncludedInSupertypeQuery(typeDefinition.isIncludedInSupertypeQuery());
        result.setIsQueryable(typeDefinition.isQueryable());
        result.setLocalName(typeDefinition.getLocalName());
        result.setLocalNamespace(typeDefinition.getLocalNamespace());
        result.setParentTypeId(typeDefinition.getParentId());
        result.setQueryName(typeDefinition.getQueryName());
        for (CmisPropertyDefinitionType propertyDefinition : typeDefinition.getPropertyDefinition()) {
            result.addPropertyDefinition(Converter.convert(propertyDefinition));
        }
        Converter.convertExtension(typeDefinition, result);
        return result;
    }

    public static PropertyDefinition<?> convert(CmisPropertyDefinitionType propertyDefinition) {
        if (propertyDefinition == null) {
            return null;
        }
        AbstractPropertyDefinition result = null;
        if (propertyDefinition instanceof CmisPropertyStringDefinitionType) {
            result = new PropertyStringDefinitionImpl();
            result.setChoices(Converter.convertChoiceStringList(((CmisPropertyStringDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyString prop = ((CmisPropertyStringDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                result.setDefaultValue(prop.getValue());
            }
            ((PropertyStringDefinitionImpl)result).setMaxLength(((CmisPropertyStringDefinitionType)propertyDefinition).getMaxLength());
        } else if (propertyDefinition instanceof CmisPropertyIdDefinitionType) {
            result = new PropertyIdDefinitionImpl();
            ((PropertyIdDefinitionImpl)result).setChoices(Converter.convertChoiceIdList(((CmisPropertyIdDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyId prop = ((CmisPropertyIdDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyIdDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
        } else if (propertyDefinition instanceof CmisPropertyIntegerDefinitionType) {
            result = new PropertyIntegerDefinitionImpl();
            ((PropertyIntegerDefinitionImpl)result).setChoices(Converter.convertChoiceIntegerList(((CmisPropertyIntegerDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyInteger prop = ((CmisPropertyIntegerDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyIntegerDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
            ((PropertyIntegerDefinitionImpl)result).setMinValue(((CmisPropertyIntegerDefinitionType)propertyDefinition).getMinValue());
            ((PropertyIntegerDefinitionImpl)result).setMaxValue(((CmisPropertyIntegerDefinitionType)propertyDefinition).getMaxValue());
        } else if (propertyDefinition instanceof CmisPropertyDecimalDefinitionType) {
            result = new PropertyDecimalDefinitionImpl();
            ((PropertyDecimalDefinitionImpl)result).setChoices(Converter.convertChoiceDecimalList(((CmisPropertyDecimalDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyDecimal prop = ((CmisPropertyDecimalDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyDecimalDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
            ((PropertyDecimalDefinitionImpl)result).setMinValue(((CmisPropertyDecimalDefinitionType)propertyDefinition).getMinValue());
            ((PropertyDecimalDefinitionImpl)result).setMaxValue(((CmisPropertyDecimalDefinitionType)propertyDefinition).getMaxValue());
        } else if (propertyDefinition instanceof CmisPropertyBooleanDefinitionType) {
            result = new PropertyBooleanDefinitionImpl();
            ((PropertyBooleanDefinitionImpl)result).setChoices(Converter.convertChoiceBooleanList(((CmisPropertyBooleanDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyBoolean prop = ((CmisPropertyBooleanDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyBooleanDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
        } else if (propertyDefinition instanceof CmisPropertyDateTimeDefinitionType) {
            result = new PropertyDateTimeDefinitionImpl();
            ((PropertyDateTimeDefinitionImpl)result).setChoices(Converter.convertChoiceDateTimeList(((CmisPropertyDateTimeDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyDateTime prop = ((CmisPropertyDateTimeDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyDateTimeDefinitionImpl)result).setDefaultValue(Converter.convertXMLCalendar(prop.getValue()));
            }
            ((PropertyDateTimeDefinitionImpl)result).setDateTimeResolution(Converter.convert(DateTimeResolution.class, ((CmisPropertyDateTimeDefinitionType)propertyDefinition).getResolution()));
        } else if (propertyDefinition instanceof CmisPropertyHtmlDefinitionType) {
            result = new PropertyHtmlDefinitionImpl();
            ((PropertyHtmlDefinitionImpl)result).setChoices(Converter.convertChoiceHtmlList(((CmisPropertyHtmlDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyHtml prop = ((CmisPropertyHtmlDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyHtmlDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
        } else if (propertyDefinition instanceof CmisPropertyUriDefinitionType) {
            result = new PropertyUriDefinitionImpl();
            ((PropertyUriDefinitionImpl)result).setChoices(Converter.convertChoiceUriList(((CmisPropertyUriDefinitionType)propertyDefinition).getChoice()));
            CmisPropertyUri prop = ((CmisPropertyUriDefinitionType)propertyDefinition).getDefaultValue();
            if (prop != null) {
                ((PropertyUriDefinitionImpl)result).setDefaultValue(prop.getValue());
            }
        } else {
            return null;
        }
        result.setCardinality(Converter.convert(Cardinality.class, propertyDefinition.getCardinality()));
        result.setDescription(propertyDefinition.getDescription());
        result.setDisplayName(propertyDefinition.getDisplayName());
        result.setId(propertyDefinition.getId());
        result.setIsInherited(propertyDefinition.isInherited());
        result.setIsOpenChoice(propertyDefinition.isOpenChoice());
        result.setIsQueryable(propertyDefinition.isQueryable());
        result.setIsOrderable(propertyDefinition.isOrderable());
        result.setIsRequired(propertyDefinition.isRequired());
        result.setLocalName(propertyDefinition.getLocalName());
        result.setLocalNamespace(propertyDefinition.getLocalNamespace());
        result.setPropertyType(Converter.convert(PropertyType.class, propertyDefinition.getPropertyType()));
        result.setQueryName(propertyDefinition.getQueryName());
        result.setUpdatability(Converter.convert(Updatability.class, propertyDefinition.getUpdatability()));
        Converter.convertExtension(propertyDefinition, result);
        return result;
    }

    public static CmisTypeDefinitionType convert(TypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            return null;
        }
        CmisTypeDefinitionType result = null;
        if (typeDefinition instanceof DocumentTypeDefinition) {
            result = new CmisTypeDocumentDefinitionType();
            DocumentTypeDefinition docTypeDefintion = (DocumentTypeDefinition)typeDefinition;
            ((CmisTypeDocumentDefinitionType)result).setVersionable(Converter.convertBoolean(docTypeDefintion.isVersionable(), false));
            ((CmisTypeDocumentDefinitionType)result).setContentStreamAllowed(Converter.convert(EnumContentStreamAllowed.class, docTypeDefintion.getContentStreamAllowed()));
        } else if (typeDefinition instanceof FolderTypeDefinition) {
            result = new CmisTypeFolderDefinitionType();
        } else if (typeDefinition instanceof RelationshipTypeDefinition) {
            result = new CmisTypeRelationshipDefinitionType();
            RelationshipTypeDefinition relationshipTypeDefinition = (RelationshipTypeDefinition)typeDefinition;
            if (relationshipTypeDefinition.getAllowedSourceTypeIds() != null) {
                for (String type : relationshipTypeDefinition.getAllowedSourceTypeIds()) {
                    ((CmisTypeRelationshipDefinitionType)result).getAllowedSourceTypes().add(type);
                }
            }
            if (relationshipTypeDefinition.getAllowedTargetTypeIds() != null) {
                for (String type : relationshipTypeDefinition.getAllowedTargetTypeIds()) {
                    ((CmisTypeRelationshipDefinitionType)result).getAllowedTargetTypes().add(type);
                }
            }
        } else if (typeDefinition instanceof PolicyTypeDefinition) {
            result = new CmisTypePolicyDefinitionType();
        } else {
            return null;
        }
        result.setBaseId(Converter.convert(EnumBaseObjectTypeIds.class, typeDefinition.getBaseTypeId()));
        result.setControllableACL(Converter.convertBoolean(typeDefinition.isControllableAcl(), false));
        result.setControllablePolicy(Converter.convertBoolean(typeDefinition.isControllablePolicy(), false));
        result.setCreatable(Converter.convertBoolean(typeDefinition.isCreatable(), false));
        result.setDescription(typeDefinition.getDescription());
        result.setDisplayName(typeDefinition.getDisplayName());
        result.setFileable(Converter.convertBoolean(typeDefinition.isFileable(), false));
        result.setFulltextIndexed(Converter.convertBoolean(typeDefinition.isFulltextIndexed(), false));
        result.setId(typeDefinition.getId());
        result.setIncludedInSupertypeQuery(Converter.convertBoolean(typeDefinition.isIncludedInSupertypeQuery(), false));
        result.setLocalName(typeDefinition.getLocalName());
        result.setLocalNamespace(typeDefinition.getLocalNamespace());
        result.setParentId(typeDefinition.getParentTypeId());
        result.setQueryable(Converter.convertBoolean(typeDefinition.isQueryable(), false));
        result.setQueryName(typeDefinition.getQueryName());
        if (typeDefinition.getPropertyDefinitions() != null) {
            for (PropertyDefinition propDef : typeDefinition.getPropertyDefinitions().values()) {
                result.getPropertyDefinition().add(Converter.convert(propDef));
            }
        }
        Converter.convertExtension((ExtensionsData)typeDefinition, result);
        return result;
    }

    public static CmisPropertyDefinitionType convert(PropertyDefinition<?> propertyDefinition) {
        if (propertyDefinition == null) {
            return null;
        }
        CmisPropertyDefinitionType result = null;
        if (propertyDefinition instanceof PropertyStringDefinition) {
            result = new CmisPropertyStringDefinitionType();
            PropertyStringDefinition source = (PropertyStringDefinition)propertyDefinition;
            CmisPropertyDefinitionType target = result;
            Converter.convertChoiceStringList(source.getChoices(), ((CmisPropertyStringDefinitionType)target).getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyString defaultValue = new CmisPropertyString();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (String value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                ((CmisPropertyStringDefinitionType)target).setDefaultValue(defaultValue);
            }
            ((CmisPropertyStringDefinitionType)target).setMaxLength(source.getMaxLength());
        } else if (propertyDefinition instanceof PropertyIdDefinition) {
            result = new CmisPropertyIdDefinitionType();
            PropertyIdDefinition source = (PropertyIdDefinition)propertyDefinition;
            CmisPropertyIdDefinitionType target = (CmisPropertyIdDefinitionType)result;
            Converter.convertChoiceIdList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyId defaultValue = new CmisPropertyId();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (String value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
        } else if (propertyDefinition instanceof PropertyIntegerDefinition) {
            result = new CmisPropertyIntegerDefinitionType();
            PropertyIntegerDefinition source = (PropertyIntegerDefinition)propertyDefinition;
            CmisPropertyIntegerDefinitionType target = (CmisPropertyIntegerDefinitionType)result;
            Converter.convertChoiceIntegerList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyInteger defaultValue = new CmisPropertyInteger();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (BigInteger value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
            target.setMinValue(source.getMinValue());
            target.setMaxValue(source.getMaxValue());
        } else if (propertyDefinition instanceof PropertyDecimalDefinition) {
            result = new CmisPropertyDecimalDefinitionType();
            PropertyDecimalDefinition source = (PropertyDecimalDefinition)propertyDefinition;
            CmisPropertyDecimalDefinitionType target = (CmisPropertyDecimalDefinitionType)result;
            Converter.convertChoiceDecimalList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyDecimal defaultValue = new CmisPropertyDecimal();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (BigDecimal value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
            target.setMinValue(source.getMinValue());
            target.setMaxValue(source.getMaxValue());
            if (source.getPrecision() != null) {
                target.setPrecision(source.getPrecision().value());
            }
        } else if (propertyDefinition instanceof PropertyBooleanDefinition) {
            result = new CmisPropertyBooleanDefinitionType();
            PropertyBooleanDefinition source = (PropertyBooleanDefinition)propertyDefinition;
            CmisPropertyBooleanDefinitionType target = (CmisPropertyBooleanDefinitionType)result;
            Converter.convertChoiceBooleanList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyBoolean defaultValue = new CmisPropertyBoolean();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (Boolean value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
        } else if (propertyDefinition instanceof PropertyDateTimeDefinition) {
            result = new CmisPropertyDateTimeDefinitionType();
            PropertyDateTimeDefinition source = (PropertyDateTimeDefinition)propertyDefinition;
            CmisPropertyDateTimeDefinitionType target = (CmisPropertyDateTimeDefinitionType)result;
            Converter.convertChoiceDateTimeList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyDateTime defaultValue = new CmisPropertyDateTime();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (XMLGregorianCalendar value : Converter.convertCalendar(source.getDefaultValue())) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
            target.setResolution(Converter.convert(EnumDateTimeResolution.class, source.getDateTimeResolution()));
        } else if (propertyDefinition instanceof PropertyHtmlDefinition) {
            result = new CmisPropertyHtmlDefinitionType();
            PropertyHtmlDefinition source = (PropertyHtmlDefinition)propertyDefinition;
            CmisPropertyHtmlDefinitionType target = (CmisPropertyHtmlDefinitionType)result;
            Converter.convertChoiceHtmlList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyHtml defaultValue = new CmisPropertyHtml();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (String value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
        } else if (propertyDefinition instanceof PropertyUriDefinition) {
            result = new CmisPropertyUriDefinitionType();
            PropertyUriDefinition source = (PropertyUriDefinition)propertyDefinition;
            CmisPropertyUriDefinitionType target = (CmisPropertyUriDefinitionType)result;
            Converter.convertChoiceUriList(source.getChoices(), target.getChoice());
            if (source.getDefaultValue() != null) {
                CmisPropertyUri defaultValue = new CmisPropertyUri();
                defaultValue.setPropertyDefinitionId(propertyDefinition.getId());
                for (String value : source.getDefaultValue()) {
                    defaultValue.getValue().add(value);
                }
                target.setDefaultValue(defaultValue);
            }
        } else {
            return null;
        }
        result.setCardinality(Converter.convert(EnumCardinality.class, propertyDefinition.getCardinality()));
        result.setDescription(propertyDefinition.getDescription());
        result.setDisplayName(propertyDefinition.getDisplayName());
        result.setId(propertyDefinition.getId());
        result.setInherited(propertyDefinition.isInherited());
        result.setLocalName(propertyDefinition.getLocalName());
        result.setLocalNamespace(propertyDefinition.getLocalNamespace());
        result.setOpenChoice(propertyDefinition.isOpenChoice());
        result.setOrderable(Converter.convertBoolean(propertyDefinition.isOrderable(), false));
        result.setPropertyType(Converter.convert(EnumPropertyType.class, propertyDefinition.getPropertyType()));
        result.setQueryable(Converter.convertBoolean(propertyDefinition.isQueryable(), false));
        result.setQueryName(propertyDefinition.getQueryName());
        result.setRequired(Converter.convertBoolean(propertyDefinition.isRequired(), false));
        result.setUpdatability(Converter.convert(EnumUpdatability.class, propertyDefinition.getUpdatability()));
        Converter.convertExtension(propertyDefinition, result);
        return result;
    }

    private static List<Choice<String>> convertChoiceStringList(List<CmisChoiceString> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<String>> result = new ArrayList<Choice<String>>();
        for (CmisChoiceString choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceStringList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceStringList(List<Choice<String>> choices, List<CmisChoiceString> target) {
        if (choices == null) {
            return;
        }
        for (Choice<String> choice : choices) {
            CmisChoiceString newChoice = new CmisChoiceString();
            Converter.convertChoiceStringList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (String value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<String>> convertChoiceIdList(List<CmisChoiceId> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<String>> result = new ArrayList<Choice<String>>();
        for (CmisChoiceId choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceIdList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceIdList(List<Choice<String>> choices, List<CmisChoiceId> target) {
        if (choices == null) {
            return;
        }
        for (Choice<String> choice : choices) {
            CmisChoiceId newChoice = new CmisChoiceId();
            Converter.convertChoiceIdList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (String value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<BigInteger>> convertChoiceIntegerList(List<CmisChoiceInteger> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<BigInteger>> result = new ArrayList<Choice<BigInteger>>();
        for (CmisChoiceInteger choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceIntegerList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceIntegerList(List<Choice<BigInteger>> choices, List<CmisChoiceInteger> target) {
        if (choices == null) {
            return;
        }
        for (Choice<BigInteger> choice : choices) {
            CmisChoiceInteger newChoice = new CmisChoiceInteger();
            Converter.convertChoiceIntegerList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (BigInteger value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<BigDecimal>> convertChoiceDecimalList(List<CmisChoiceDecimal> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<BigDecimal>> result = new ArrayList<Choice<BigDecimal>>();
        for (CmisChoiceDecimal choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceDecimalList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceDecimalList(List<Choice<BigDecimal>> choices, List<CmisChoiceDecimal> target) {
        if (choices == null) {
            return;
        }
        for (Choice<BigDecimal> choice : choices) {
            CmisChoiceDecimal newChoice = new CmisChoiceDecimal();
            Converter.convertChoiceDecimalList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (BigDecimal value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<Boolean>> convertChoiceBooleanList(List<CmisChoiceBoolean> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<Boolean>> result = new ArrayList<Choice<Boolean>>();
        for (CmisChoiceBoolean choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceBooleanList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceBooleanList(List<Choice<Boolean>> choices, List<CmisChoiceBoolean> target) {
        if (choices == null) {
            return;
        }
        for (Choice<Boolean> choice : choices) {
            CmisChoiceBoolean newChoice = new CmisChoiceBoolean();
            Converter.convertChoiceBooleanList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (Boolean value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<GregorianCalendar>> convertChoiceDateTimeList(List<CmisChoiceDateTime> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<GregorianCalendar>> result = new ArrayList<Choice<GregorianCalendar>>();
        for (CmisChoiceDateTime choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceDateTimeList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(Converter.convertXMLCalendar(choice.getValue()));
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceDateTimeList(List<Choice<GregorianCalendar>> choices, List<CmisChoiceDateTime> target) {
        if (choices == null) {
            return;
        }
        for (Choice<GregorianCalendar> choice : choices) {
            CmisChoiceDateTime newChoice = new CmisChoiceDateTime();
            Converter.convertChoiceDateTimeList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (XMLGregorianCalendar value : Converter.convertCalendar(choice.getValue())) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<String>> convertChoiceHtmlList(List<CmisChoiceHtml> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<String>> result = new ArrayList<Choice<String>>();
        for (CmisChoiceHtml choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceHtmlList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceHtmlList(List<Choice<String>> choices, List<CmisChoiceHtml> target) {
        if (choices == null) {
            return;
        }
        for (Choice<String> choice : choices) {
            CmisChoiceHtml newChoice = new CmisChoiceHtml();
            Converter.convertChoiceHtmlList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (String value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    private static List<Choice<String>> convertChoiceUriList(List<CmisChoiceUri> choices) {
        if (choices == null) {
            return null;
        }
        ArrayList<Choice<String>> result = new ArrayList<Choice<String>>();
        for (CmisChoiceUri choice : choices) {
            ChoiceImpl newChoice = new ChoiceImpl();
            newChoice.setChoice(Converter.convertChoiceUriList(choice.getChoice()));
            newChoice.setDisplayName(choice.getDisplayName());
            newChoice.setValue(choice.getValue());
            result.add(newChoice);
        }
        return result;
    }

    private static void convertChoiceUriList(List<Choice<String>> choices, List<CmisChoiceUri> target) {
        if (choices == null) {
            return;
        }
        for (Choice<String> choice : choices) {
            CmisChoiceUri newChoice = new CmisChoiceUri();
            Converter.convertChoiceUriList(choice.getChoice(), newChoice.getChoice());
            newChoice.setDisplayName(choice.getDisplayName());
            if (choice.getValue() != null) {
                for (String value : choice.getValue()) {
                    newChoice.getValue().add(value);
                }
            }
            target.add(newChoice);
        }
    }

    public static ObjectData convert(CmisObjectType object) {
        if (object == null) {
            return null;
        }
        ObjectDataImpl result = new ObjectDataImpl();
        result.setAcl(Converter.convert(object.getAcl(), object.isExactACL()));
        result.setAllowableActions(Converter.convert(object.getAllowableActions()));
        if (object.getChangeEventInfo() != null) {
            ChangeEventInfoDataImpl changeEventInfo = new ChangeEventInfoDataImpl();
            if (object.getChangeEventInfo().getChangeTime() != null) {
                changeEventInfo.setChangeTime(object.getChangeEventInfo().getChangeTime().toGregorianCalendar());
            }
            changeEventInfo.setChangeType(Converter.convert(ChangeType.class, object.getChangeEventInfo().getChangeType()));
            Converter.convertExtension(object.getChangeEventInfo(), changeEventInfo);
            result.setChangeEventInfo(changeEventInfo);
        }
        result.setIsExactAcl(object.isExactACL());
        result.setPolicyIds(Converter.convert(object.getPolicyIds()));
        result.setProperties(Converter.convert(object.getProperties()));
        ArrayList<ObjectData> relationships = new ArrayList<ObjectData>();
        for (CmisObjectType cmisObject : object.getRelationship()) {
            relationships.add(Converter.convert(cmisObject));
        }
        result.setRelationships(relationships);
        ArrayList<RenditionData> renditions = new ArrayList<RenditionData>();
        for (CmisRenditionType rendition : object.getRendition()) {
            renditions.add(Converter.convert(rendition));
        }
        result.setRenditions(renditions);
        Converter.convertExtension(object, result);
        return result;
    }

    public static Properties convert(CmisPropertiesType properties) {
        if (properties == null) {
            return null;
        }
        PropertiesImpl result = new PropertiesImpl();
        for (CmisProperty property : properties.getProperty()) {
            result.addProperty(Converter.convert(property));
        }
        Converter.convertExtension(properties, result);
        return result;
    }

    public static PropertyData<?> convert(CmisProperty property) {
        if (property == null) {
            return null;
        }
        AbstractPropertyData result = null;
        if (property instanceof CmisPropertyString) {
            result = new PropertyStringImpl(property.getPropertyDefinitionId(), ((CmisPropertyString)property).getValue());
        } else if (property instanceof CmisPropertyId) {
            result = new PropertyIdImpl(property.getPropertyDefinitionId(), ((CmisPropertyId)property).getValue());
        } else if (property instanceof CmisPropertyInteger) {
            result = new PropertyIntegerImpl(property.getPropertyDefinitionId(), ((CmisPropertyInteger)property).getValue());
        } else if (property instanceof CmisPropertyDecimal) {
            result = new PropertyDecimalImpl(property.getPropertyDefinitionId(), ((CmisPropertyDecimal)property).getValue());
        } else if (property instanceof CmisPropertyBoolean) {
            result = new PropertyBooleanImpl(property.getPropertyDefinitionId(), ((CmisPropertyBoolean)property).getValue());
        } else if (property instanceof CmisPropertyDateTime) {
            result = new PropertyDateTimeImpl(property.getPropertyDefinitionId(), Converter.convertXMLCalendar(((CmisPropertyDateTime)property).getValue()));
        } else if (property instanceof CmisPropertyHtml) {
            result = new PropertyHtmlImpl(property.getPropertyDefinitionId(), ((CmisPropertyHtml)property).getValue());
        } else if (property instanceof CmisPropertyUri) {
            result = new PropertyUriImpl(property.getPropertyDefinitionId(), ((CmisPropertyUri)property).getValue());
        } else {
            return null;
        }
        ((AbstractPropertyData)result).setLocalName(property.getLocalName());
        ((AbstractPropertyData)result).setQueryName(property.getQueryName());
        ((AbstractPropertyData)result).setDisplayName(property.getDisplayName());
        Converter.convertExtension(property, result);
        return result;
    }

    public static CmisPropertiesType convert(Properties properties) {
        if (properties == null) {
            return null;
        }
        CmisPropertiesType result = new CmisPropertiesType();
        if (properties.getProperties() != null) {
            for (PropertyData property : properties.getPropertyList()) {
                result.getProperty().add(Converter.convert(property));
            }
        }
        Converter.convertExtension((ExtensionsData)properties, result);
        return result;
    }

    public static CmisProperty convert(PropertyData<?> property) {
        if (property == null) {
            return null;
        }
        CmisProperty result = null;
        if (property instanceof PropertyString) {
            result = new CmisPropertyString();
            ((CmisPropertyString)result).getValue().addAll(((PropertyString)property).getValues());
        } else if (property instanceof PropertyId) {
            result = new CmisPropertyId();
            ((CmisPropertyId)result).getValue().addAll(((PropertyId)property).getValues());
        } else if (property instanceof PropertyInteger) {
            result = new CmisPropertyInteger();
            ((CmisPropertyInteger)result).getValue().addAll(((PropertyInteger)property).getValues());
        } else if (property instanceof PropertyDecimal) {
            result = new CmisPropertyDecimal();
            ((CmisPropertyDecimal)result).getValue().addAll(((PropertyDecimal)property).getValues());
        } else if (property instanceof PropertyBoolean) {
            result = new CmisPropertyBoolean();
            ((CmisPropertyBoolean)result).getValue().addAll(((PropertyBoolean)property).getValues());
        } else if (property instanceof PropertyDateTime) {
            result = new CmisPropertyDateTime();
            ((CmisPropertyDateTime)result).getValue().addAll(Converter.convertCalendar(((PropertyDateTime)property).getValues()));
        } else if (property instanceof PropertyHtml) {
            result = new CmisPropertyHtml();
            ((CmisPropertyHtml)result).getValue().addAll(((PropertyHtml)property).getValues());
        } else if (property instanceof PropertyUri) {
            result = new CmisPropertyUri();
            ((CmisPropertyUri)result).getValue().addAll(((PropertyUri)property).getValues());
        } else {
            return null;
        }
        result.setPropertyDefinitionId(property.getId());
        result.setLocalName(property.getLocalName());
        result.setQueryName(property.getQueryName());
        result.setDisplayName(property.getDisplayName());
        return result;
    }

    public static RenditionData convert(CmisRenditionType rendition) {
        if (rendition == null) {
            return null;
        }
        RenditionDataImpl result = new RenditionDataImpl();
        result.setBigHeight(rendition.getHeight());
        result.setKind(rendition.getKind());
        result.setBigLength(rendition.getLength());
        result.setMimeType(rendition.getMimetype());
        result.setRenditionDocumentId(rendition.getRenditionDocumentId());
        result.setStreamId(rendition.getStreamId());
        result.setTitle(rendition.getTitle());
        result.setBigWidth(rendition.getWidth());
        Converter.convertExtension(rendition, result);
        return result;
    }

    public static CmisRenditionType convert(RenditionData rendition) {
        if (rendition == null) {
            return null;
        }
        CmisRenditionType result = new CmisRenditionType();
        result.setHeight(rendition.getBigHeight());
        result.setKind(rendition.getKind());
        result.setLength(rendition.getBigLength());
        result.setMimetype(rendition.getMimeType());
        result.setRenditionDocumentId(rendition.getRenditionDocumentId());
        result.setStreamId(rendition.getStreamId());
        result.setTitle(rendition.getTitle());
        result.setWidth(rendition.getBigWidth());
        Converter.convertExtension((ExtensionsData)rendition, result);
        return result;
    }

    public static CmisObjectType convert(ObjectData object) {
        if (object == null) {
            return null;
        }
        CmisObjectType result = new CmisObjectType();
        result.setAcl(Converter.convert(object.getAcl()));
        result.setAllowableActions(Converter.convert(object.getAllowableActions()));
        if (object.getChangeEventInfo() != null) {
            CmisChangeEventType changeEventInfo = new CmisChangeEventType();
            changeEventInfo.setChangeType(Converter.convert(EnumTypeOfChanges.class, object.getChangeEventInfo().getChangeType()));
            changeEventInfo.setChangeTime(Converter.convertCalendar(object.getChangeEventInfo().getChangeTime()));
            Converter.convertExtension((ExtensionsData)object.getChangeEventInfo(), changeEventInfo);
            result.setChangeEventInfo(changeEventInfo);
        }
        result.setExactACL(object.getAcl() == null ? null : object.getAcl().isExact());
        result.setPolicyIds(Converter.convert(object.getPolicyIds()));
        result.setProperties(Converter.convert(object.getProperties()));
        if (object.getRelationships() != null) {
            for (ObjectData relationship : object.getRelationships()) {
                result.getRelationship().add(Converter.convert(relationship));
            }
        }
        if (object.getRenditions() != null) {
            for (RenditionData rendition : object.getRenditions()) {
                result.getRendition().add(Converter.convert(rendition));
            }
        }
        Converter.convertExtension((ExtensionsData)object, result);
        return result;
    }

    public static Acl convert(CmisAccessControlListType acl, Boolean isExact) {
        if (acl == null) {
            return null;
        }
        AccessControlListImpl result = new AccessControlListImpl();
        ArrayList<Ace> aces = new ArrayList<Ace>();
        for (CmisAccessControlEntryType entry : acl.getPermission()) {
            if (entry == null) continue;
            AccessControlEntryImpl ace = new AccessControlEntryImpl();
            ace.setDirect(entry.isDirect());
            ace.setPermissions(entry.getPermission());
            AccessControlPrincipalDataImpl principal = new AccessControlPrincipalDataImpl(entry.getPrincipal() == null ? null : entry.getPrincipal().getPrincipalId());
            Converter.convertExtension(entry.getPrincipal(), principal);
            ace.setPrincipal(principal);
            Converter.convertExtension(entry, ace);
            aces.add(ace);
        }
        result.setAces(aces);
        result.setExact(isExact);
        Converter.convertExtension(acl, result);
        return result;
    }

    public static CmisAccessControlListType convert(Acl acl) {
        if (acl == null) {
            return null;
        }
        CmisAccessControlListType result = new CmisAccessControlListType();
        if (acl.getAces() != null) {
            for (Ace ace : acl.getAces()) {
                if (ace == null) continue;
                CmisAccessControlEntryType entry = new CmisAccessControlEntryType();
                if (ace.getPrincipal() != null) {
                    CmisAccessControlPrincipalType pincipal = new CmisAccessControlPrincipalType();
                    pincipal.setPrincipalId(ace.getPrincipal().getId());
                    Converter.convertExtension(pincipal, (ExtensionsData)ace.getPrincipal());
                    entry.setPrincipal(pincipal);
                }
                entry.setDirect(ace.isDirect());
                entry.getPermission().addAll(ace.getPermissions());
                Converter.convertExtension((ExtensionsData)ace, entry);
                result.getPermission().add(entry);
            }
        }
        Converter.convertExtension((ExtensionsData)acl, result);
        return result;
    }

    public static AllowableActions convert(CmisAllowableActionsType allowableActions) {
        if (allowableActions == null) {
            return null;
        }
        AllowableActionsImpl result = new AllowableActionsImpl();
        EnumSet<Action> set = EnumSet.noneOf(Action.class);
        if (Boolean.TRUE.equals(allowableActions.isCanAddObjectToFolder())) {
            set.add(Action.CAN_ADD_OBJECT_TO_FOLDER);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanApplyACL())) {
            set.add(Action.CAN_APPLY_ACL);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanApplyPolicy())) {
            set.add(Action.CAN_APPLY_POLICY);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCancelCheckOut())) {
            set.add(Action.CAN_CANCEL_CHECK_OUT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCheckIn())) {
            set.add(Action.CAN_CHECK_IN);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCheckOut())) {
            set.add(Action.CAN_CHECK_OUT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCreateDocument())) {
            set.add(Action.CAN_CREATE_DOCUMENT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCreateFolder())) {
            set.add(Action.CAN_CREATE_FOLDER);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanCreateRelationship())) {
            set.add(Action.CAN_CREATE_RELATIONSHIP);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanDeleteContentStream())) {
            set.add(Action.CAN_DELETE_CONTENT_STREAM);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanDeleteObject())) {
            set.add(Action.CAN_DELETE_OBJECT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanDeleteTree())) {
            set.add(Action.CAN_DELETE_TREE);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetACL())) {
            set.add(Action.CAN_GET_ACL);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetAllVersions())) {
            set.add(Action.CAN_GET_ALL_VERSIONS);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetAppliedPolicies())) {
            set.add(Action.CAN_GET_APPLIED_POLICIES);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetChildren())) {
            set.add(Action.CAN_GET_CHILDREN);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetContentStream())) {
            set.add(Action.CAN_GET_CONTENT_STREAM);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetDescendants())) {
            set.add(Action.CAN_GET_DESCENDANTS);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetFolderParent())) {
            set.add(Action.CAN_GET_FOLDER_PARENT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetFolderTree())) {
            set.add(Action.CAN_GET_FOLDER_TREE);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetObjectParents())) {
            set.add(Action.CAN_GET_OBJECT_PARENTS);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetObjectRelationships())) {
            set.add(Action.CAN_GET_OBJECT_RELATIONSHIPS);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetProperties())) {
            set.add(Action.CAN_GET_PROPERTIES);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanGetRenditions())) {
            set.add(Action.CAN_GET_RENDITIONS);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanMoveObject())) {
            set.add(Action.CAN_MOVE_OBJECT);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanRemoveObjectFromFolder())) {
            set.add(Action.CAN_REMOVE_OBJECT_FROM_FOLDER);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanRemovePolicy())) {
            set.add(Action.CAN_REMOVE_POLICY);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanSetContentStream())) {
            set.add(Action.CAN_SET_CONTENT_STREAM);
        }
        if (Boolean.TRUE.equals(allowableActions.isCanUpdateProperties())) {
            set.add(Action.CAN_UPDATE_PROPERTIES);
        }
        result.setAllowableActions(set);
        Converter.convertExtension(allowableActions, result);
        return result;
    }

    public static CmisAllowableActionsType convert(AllowableActions allowableActions) {
        if (allowableActions == null) {
            return null;
        }
        CmisAllowableActionsType result = new CmisAllowableActionsType();
        if (allowableActions.getAllowableActions() != null) {
            Set set = allowableActions.getAllowableActions();
            result.setCanAddObjectToFolder(set.contains(Action.CAN_ADD_OBJECT_TO_FOLDER));
            result.setCanApplyACL(set.contains(Action.CAN_APPLY_ACL));
            result.setCanApplyPolicy(set.contains(Action.CAN_APPLY_POLICY));
            result.setCanCancelCheckOut(set.contains(Action.CAN_CANCEL_CHECK_OUT));
            result.setCanCheckIn(set.contains(Action.CAN_CHECK_IN));
            result.setCanCheckOut(set.contains(Action.CAN_CHECK_OUT));
            result.setCanCreateDocument(set.contains(Action.CAN_CREATE_DOCUMENT));
            result.setCanCreateFolder(set.contains(Action.CAN_CREATE_FOLDER));
            result.setCanCreateRelationship(set.contains(Action.CAN_CREATE_RELATIONSHIP));
            result.setCanDeleteContentStream(set.contains(Action.CAN_DELETE_CONTENT_STREAM));
            result.setCanDeleteObject(set.contains(Action.CAN_DELETE_OBJECT));
            result.setCanDeleteTree(set.contains(Action.CAN_DELETE_TREE));
            result.setCanGetACL(set.contains(Action.CAN_GET_ACL));
            result.setCanGetAllVersions(set.contains(Action.CAN_GET_ALL_VERSIONS));
            result.setCanGetAppliedPolicies(set.contains(Action.CAN_GET_APPLIED_POLICIES));
            result.setCanGetChildren(set.contains(Action.CAN_GET_CHILDREN));
            result.setCanGetContentStream(set.contains(Action.CAN_GET_CONTENT_STREAM));
            result.setCanGetDescendants(set.contains(Action.CAN_GET_DESCENDANTS));
            result.setCanGetFolderParent(set.contains(Action.CAN_GET_FOLDER_PARENT));
            result.setCanGetFolderTree(set.contains(Action.CAN_GET_FOLDER_TREE));
            result.setCanGetObjectParents(set.contains(Action.CAN_GET_OBJECT_PARENTS));
            result.setCanGetObjectRelationships(set.contains(Action.CAN_GET_OBJECT_RELATIONSHIPS));
            result.setCanGetProperties(set.contains(Action.CAN_GET_PROPERTIES));
            result.setCanGetRenditions(set.contains(Action.CAN_GET_RENDITIONS));
            result.setCanMoveObject(set.contains(Action.CAN_MOVE_OBJECT));
            result.setCanRemoveObjectFromFolder(set.contains(Action.CAN_REMOVE_OBJECT_FROM_FOLDER));
            result.setCanRemovePolicy(set.contains(Action.CAN_REMOVE_POLICY));
            result.setCanSetContentStream(set.contains(Action.CAN_SET_CONTENT_STREAM));
            result.setCanUpdateProperties(set.contains(Action.CAN_UPDATE_PROPERTIES));
        }
        Converter.convertExtension((ExtensionsData)allowableActions, result);
        return result;
    }

    public static PolicyIdList convert(CmisListOfIdsType policyIds) {
        if (policyIds == null) {
            return null;
        }
        PolicyIdListImpl result = new PolicyIdListImpl();
        result.setPolicyIds(policyIds.getId());
        Converter.convertExtension(policyIds, result);
        return result;
    }

    public static CmisListOfIdsType convert(PolicyIdList policyIds) {
        if (policyIds == null) {
            return null;
        }
        CmisListOfIdsType result = new CmisListOfIdsType();
        if (policyIds.getPolicyIds() != null) {
            for (String id : policyIds.getPolicyIds()) {
                result.getId().add(id);
            }
        }
        Converter.convertExtension((ExtensionsData)policyIds, result);
        return result;
    }

    public static CmisListOfIdsType convertPolicyIds(List<String> policyIds) {
        if (policyIds == null) {
            return null;
        }
        CmisListOfIdsType result = new CmisListOfIdsType();
        result.getId().addAll(policyIds);
        return result;
    }

    public static List<GregorianCalendar> convertXMLCalendar(List<XMLGregorianCalendar> calendar) {
        if (calendar == null) {
            return null;
        }
        ArrayList<GregorianCalendar> result = new ArrayList<GregorianCalendar>();
        for (XMLGregorianCalendar cal : calendar) {
            if (cal == null) continue;
            result.add(cal.toGregorianCalendar());
        }
        return result;
    }

    public static List<XMLGregorianCalendar> convertCalendar(List<GregorianCalendar> calendar) {
        DatatypeFactory df;
        if (calendar == null) {
            return null;
        }
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new CmisRuntimeException("Convert exception: " + e.getMessage(), (Throwable)e);
        }
        ArrayList<XMLGregorianCalendar> result = new ArrayList<XMLGregorianCalendar>();
        for (GregorianCalendar cal : calendar) {
            result.add(df.newXMLGregorianCalendar(cal));
        }
        return result;
    }

    public static XMLGregorianCalendar convertCalendar(GregorianCalendar calendar) {
        DatatypeFactory df;
        if (calendar == null) {
            return null;
        }
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new CmisRuntimeException("Convert exception: " + e.getMessage(), (Throwable)e);
        }
        return df.newXMLGregorianCalendar(calendar);
    }

    public static TypeDefinitionList convert(CmisTypeDefinitionListType typeList) {
        if (typeList == null) {
            return null;
        }
        TypeDefinitionListImpl result = new TypeDefinitionListImpl();
        ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
        for (CmisTypeDefinitionType typeDefinition : typeList.getTypes()) {
            types.add(Converter.convert(typeDefinition));
        }
        result.setList(types);
        result.setHasMoreItems(typeList.isHasMoreItems());
        result.setNumItems(typeList.getNumItems());
        Converter.convertExtension(typeList, result);
        return result;
    }

    public static CmisTypeDefinitionListType convert(TypeDefinitionList typeList) {
        if (typeList == null) {
            return null;
        }
        CmisTypeDefinitionListType result = new CmisTypeDefinitionListType();
        if (typeList.getList() != null) {
            for (TypeDefinition tdd : typeList.getList()) {
                result.getTypes().add(Converter.convert(tdd));
            }
        }
        result.setHasMoreItems(Converter.convertBoolean(typeList.hasMoreItems(), false));
        result.setNumItems(typeList.getNumItems());
        Converter.convertExtension((ExtensionsData)typeList, result);
        return result;
    }

    public static List<TypeDefinitionContainer> convertTypeContainerList(List<CmisTypeContainer> typeContainers) {
        if (typeContainers == null) {
            return null;
        }
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        for (CmisTypeContainer container : typeContainers) {
            TypeDefinitionContainerImpl newConatiner = new TypeDefinitionContainerImpl();
            newConatiner.setTypeDefinition(Converter.convert(container.getType()));
            newConatiner.setChildren(Converter.convertTypeContainerList(container.getChildren()));
            Converter.convertExtension(container, newConatiner);
            result.add(newConatiner);
        }
        return result;
    }

    public static void convertTypeContainerList(List<TypeDefinitionContainer> typeContainers, List<CmisTypeContainer> target) {
        if (typeContainers == null) {
            return;
        }
        for (TypeDefinitionContainer container : typeContainers) {
            CmisTypeContainer newConatiner = new CmisTypeContainer();
            newConatiner.setType(Converter.convert(container.getTypeDefinition()));
            Converter.convertTypeContainerList(container.getChildren(), newConatiner.getChildren());
            Converter.convertExtension((ExtensionsData)container, newConatiner);
            target.add(newConatiner);
        }
    }

    public static ObjectInFolderData convert(CmisObjectInFolderType objectInFolder) {
        if (objectInFolder == null) {
            return null;
        }
        ObjectInFolderDataImpl result = new ObjectInFolderDataImpl();
        result.setObject(Converter.convert(objectInFolder.getObject()));
        result.setPathSegment(objectInFolder.getPathSegment());
        Converter.convertExtension(objectInFolder, result);
        return result;
    }

    public static CmisObjectInFolderType convert(ObjectInFolderData objectInFolder) {
        if (objectInFolder == null) {
            return null;
        }
        CmisObjectInFolderType result = new CmisObjectInFolderType();
        result.setObject(Converter.convert(objectInFolder.getObject()));
        result.setPathSegment(objectInFolder.getPathSegment());
        Converter.convertExtension((ExtensionsData)objectInFolder, result);
        return result;
    }

    public static ObjectParentData convert(CmisObjectParentsType objectParent) {
        if (objectParent == null) {
            return null;
        }
        ObjectParentDataImpl result = new ObjectParentDataImpl();
        result.setObject(Converter.convert(objectParent.getObject()));
        result.setRelativePathSegment(objectParent.getRelativePathSegment());
        Converter.convertExtension(objectParent, result);
        return result;
    }

    public static CmisObjectParentsType convert(ObjectParentData objectParent) {
        if (objectParent == null) {
            return null;
        }
        CmisObjectParentsType result = new CmisObjectParentsType();
        result.setObject(Converter.convert(objectParent.getObject()));
        result.setRelativePathSegment(objectParent.getRelativePathSegment());
        Converter.convertExtension((ExtensionsData)objectParent, result);
        return result;
    }

    public static ObjectInFolderList convert(CmisObjectInFolderListType objectInFolderList) {
        if (objectInFolderList == null) {
            return null;
        }
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderData> objects = new ArrayList<ObjectInFolderData>();
        for (CmisObjectInFolderType object : objectInFolderList.getObjects()) {
            objects.add(Converter.convert(object));
        }
        result.setObjects(objects);
        result.setHasMoreItems(objectInFolderList.isHasMoreItems());
        result.setNumItems(objectInFolderList.getNumItems());
        Converter.convertExtension(objectInFolderList, result);
        return result;
    }

    public static CmisObjectInFolderListType convert(ObjectInFolderList objectInFolderList) {
        if (objectInFolderList == null) {
            return null;
        }
        CmisObjectInFolderListType result = new CmisObjectInFolderListType();
        if (objectInFolderList.getObjects() != null) {
            for (ObjectInFolderData object : objectInFolderList.getObjects()) {
                result.getObjects().add(Converter.convert(object));
            }
        }
        result.setHasMoreItems(objectInFolderList.hasMoreItems());
        result.setNumItems(objectInFolderList.getNumItems());
        Converter.convertExtension((ExtensionsData)objectInFolderList, result);
        return result;
    }

    public static ObjectList convert(CmisObjectListType objectList) {
        if (objectList == null) {
            return null;
        }
        ObjectListImpl result = new ObjectListImpl();
        ArrayList<ObjectData> objects = new ArrayList<ObjectData>();
        for (CmisObjectType object : objectList.getObjects()) {
            objects.add(Converter.convert(object));
        }
        result.setObjects(objects);
        result.setHasMoreItems(objectList.isHasMoreItems());
        result.setNumItems(objectList.getNumItems());
        Converter.convertExtension(objectList, result);
        return result;
    }

    public static CmisObjectListType convert(ObjectList objectList) {
        if (objectList == null) {
            return null;
        }
        CmisObjectListType result = new CmisObjectListType();
        if (objectList.getObjects() != null) {
            for (ObjectData object : objectList.getObjects()) {
                result.getObjects().add(Converter.convert(object));
            }
        }
        result.setHasMoreItems(objectList.hasMoreItems());
        result.setNumItems(objectList.getNumItems());
        Converter.convertExtension((ExtensionsData)objectList, result);
        return result;
    }

    public static ObjectInFolderContainer convert(CmisObjectInFolderContainerType container) {
        if (container == null) {
            return null;
        }
        ObjectInFolderContainerImpl result = new ObjectInFolderContainerImpl();
        result.setObject(Converter.convert(container.getObjectInFolder()));
        ArrayList<ObjectInFolderContainer> containerList = new ArrayList<ObjectInFolderContainer>();
        for (CmisObjectInFolderContainerType containerChild : container.getChildren()) {
            containerList.add(Converter.convert(containerChild));
        }
        result.setChildren(containerList);
        Converter.convertExtension(container, result);
        return result;
    }

    public static CmisObjectInFolderContainerType convert(ObjectInFolderContainer container) {
        if (container == null) {
            return null;
        }
        CmisObjectInFolderContainerType result = new CmisObjectInFolderContainerType();
        result.setObjectInFolder(Converter.convert(container.getObject()));
        if (container.getChildren() != null) {
            for (ObjectInFolderContainer child : container.getChildren()) {
                result.getChildren().add(Converter.convert(child));
            }
        }
        Converter.convertExtension((ExtensionsData)container, result);
        return result;
    }

    public static Acl convert(CmisACLType acl) {
        if (acl == null) {
            return null;
        }
        Acl result = Converter.convert(acl.getACL(), acl.isExact());
        Converter.convertExtension(acl, (ExtensionsData)result);
        return result;
    }

    public static FailedToDeleteData convert(DeleteTreeResponse.FailedToDelete failedToDelete) {
        if (failedToDelete == null) {
            return null;
        }
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        result.setIds(failedToDelete.getObjectIds());
        Converter.convertExtension(failedToDelete, result);
        return result;
    }

    public static DeleteTreeResponse.FailedToDelete convert(FailedToDeleteData failedToDelete) {
        if (failedToDelete == null) {
            return null;
        }
        DeleteTreeResponse.FailedToDelete result = new DeleteTreeResponse.FailedToDelete();
        if (failedToDelete.getIds() != null) {
            for (String id : failedToDelete.getIds()) {
                result.getObjectIds().add(id);
            }
        }
        Converter.convertExtension((ExtensionsData)failedToDelete, result);
        return result;
    }

    public static ContentStream convert(CmisContentStreamType contentStream) {
        ContentStreamImpl result;
        block7: {
            if (contentStream == null) {
                return null;
            }
            result = new ContentStreamImpl();
            result.setFileName(contentStream.getFilename());
            result.setLength(contentStream.getLength());
            result.setMimeType(contentStream.getMimeType());
            if (contentStream.getStream() != null) {
                try {
                    try {
                        if (contentStream.getStream() instanceof StreamingDataHandler) {
                            result.setStream(((StreamingDataHandler)contentStream.getStream()).readOnce());
                            break block7;
                        }
                        result.setStream(contentStream.getStream().getInputStream());
                    }
                    catch (NoClassDefFoundError cnfe) {
                        result.setStream(contentStream.getStream().getInputStream());
                    }
                }
                catch (IOException e) {
                    throw new CmisRuntimeException("Could not get the stream: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        Converter.convertExtension(contentStream, result);
        return result;
    }

    public static CmisContentStreamType convert(final ContentStream contentStream) {
        if (contentStream == null) {
            return null;
        }
        CmisContentStreamType result = new CmisContentStreamType();
        result.setFilename(contentStream.getFileName());
        result.setLength(contentStream.getBigLength());
        result.setMimeType(contentStream.getMimeType());
        InputStream in = contentStream.getStream();
        final InputStream stream = !(in instanceof BufferedInputStream) && !(in instanceof ByteArrayInputStream) ? new BufferedInputStream(in, 65536) : contentStream.getStream();
        result.setStream(new DataHandler(new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return null;
            }

            public String getName() {
                return contentStream.getFileName();
            }

            public InputStream getInputStream() throws IOException {
                return new FilterInputStream(stream){

                    public void close() throws IOException {
                    }
                };
            }

            public String getContentType() {
                return contentStream.getMimeType();
            }
        }));
        return result;
    }

    public static CmisExtensionType convert(ExtensionsData extension) {
        if (extension == null) {
            return null;
        }
        CmisExtensionType result = new CmisExtensionType();
        if (extension.getExtensions() != null) {
            for (CmisExtensionElement ext : extension.getExtensions()) {
                result.getAny().add(Converter.convertCmisExtensionElementToNode(ext));
            }
        }
        return result;
    }

    public static javax.xml.ws.Holder<CmisExtensionType> convertExtensionHolder(ExtensionsData extension) {
        if (extension == null) {
            return null;
        }
        javax.xml.ws.Holder result = new javax.xml.ws.Holder();
        result.value = Converter.convert(extension);
        return result;
    }

    public static void setExtensionValues(javax.xml.ws.Holder<CmisExtensionType> source, ExtensionsData target) {
        if (target == null) {
            return;
        }
        target.setExtensions(null);
        if (source == null || source.value == null) {
            return;
        }
        ArrayList<CmisExtensionElement> list = new ArrayList<CmisExtensionElement>();
        target.setExtensions(list);
        if (!((CmisExtensionType)source.value).getAny().isEmpty()) {
            for (Object obj : ((CmisExtensionType)source.value).getAny()) {
                list.add(Converter.convertDomToCmisExtensionElement(obj));
            }
        }
    }

    public static ExtensionsData convertExtensionHolder(javax.xml.ws.Holder<CmisExtensionType> extension) {
        if (extension == null) {
            return null;
        }
        return Converter.convert((CmisExtensionType)extension.value);
    }

    public static void setExtensionValues(ExtensionsData source, javax.xml.ws.Holder<CmisExtensionType> target) {
        if (target == null || target.value == null) {
            return;
        }
        ((CmisExtensionType)target.value).getAny().clear();
        if (source == null || source.getExtensions() == null) {
            return;
        }
        if (source.getExtensions() != null) {
            for (CmisExtensionElement ext : source.getExtensions()) {
                ((CmisExtensionType)target.value).getAny().add(Converter.convertCmisExtensionElementToNode(ext));
            }
        }
    }

    public static <T> javax.xml.ws.Holder<T> convertHolder(Holder<T> orgHolder) {
        if (orgHolder == null) {
            return null;
        }
        javax.xml.ws.Holder result = new javax.xml.ws.Holder();
        result.value = orgHolder.getValue();
        return result;
    }

    public static <T> Holder<T> convertHolder(javax.xml.ws.Holder<T> orgHolder) {
        if (orgHolder == null) {
            return null;
        }
        Holder result = new Holder();
        result.setValue(orgHolder.value);
        return result;
    }

    public static <T> void setHolderValue(javax.xml.ws.Holder<T> source, Holder<T> target) {
        if (source == null || target == null) {
            return;
        }
        target.setValue(source.value);
    }

    public static <T> void setHolderValue(Holder<T> source, javax.xml.ws.Holder<T> target) {
        if (source == null || target == null) {
            return;
        }
        target.value = source.getValue();
    }

    public static void convertExtension(Object source, ExtensionsData target) {
        if (source == null) {
            return;
        }
        try {
            Method m = source.getClass().getMethod("getAny", new Class[0]);
            List list = (List)m.invoke(source, new Object[0]);
            if (!list.isEmpty()) {
                ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
                for (Object obj : list) {
                    extensions.add(Converter.convertDomToCmisExtensionElement(obj));
                }
                target.setExtensions(extensions);
            } else {
                target.setExtensions(null);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void convertExtension(ExtensionsData source, Object target) {
        if (source == null) {
            return;
        }
        try {
            Method m = target.getClass().getMethod("getAny", new Class[0]);
            List list = (List)m.invoke(target, new Object[0]);
            list.clear();
            if (source.getExtensions() != null) {
                for (CmisExtensionElement ext : source.getExtensions()) {
                    list.add(Converter.convertCmisExtensionElementToNode(ext));
                }
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public static ExtensionsData convert(CmisExtensionType extension) {
        if (extension == null) {
            return null;
        }
        ExtensionDataImpl result = new ExtensionDataImpl();
        ArrayList<CmisExtensionElement> extensions = new ArrayList<CmisExtensionElement>();
        result.setExtensions(extensions);
        for (Object obj : extension.getAny()) {
            extensions.add(Converter.convertDomToCmisExtensionElement(obj));
        }
        return result;
    }

    private static CmisExtensionElement convertDomToCmisExtensionElement(Object source) {
        if (!(source instanceof Node)) {
            return null;
        }
        Node node = (Node)source;
        if (node.getNodeType() != 1) {
            return null;
        }
        String name = node.getLocalName();
        String namespace = node.getNamespaceURI();
        CmisExtensionElementImpl result = null;
        ArrayList<CmisExtensionElement> cmisChildren = new ArrayList<CmisExtensionElement>();
        StringBuilder value = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                CmisExtensionElement cmisChild = Converter.convertDomToCmisExtensionElement(child);
                if (cmisChild == null) continue;
                cmisChildren.add(cmisChild);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            value.append(child.getNodeValue());
        }
        HashMap<String, String> attributes = null;
        if (node.getAttributes() != null) {
            attributes = new HashMap<String, String>();
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                Node attrNode = node.getAttributes().item(i);
                String attrNamespace = attrNode.getNamespaceURI();
                if (attrNamespace != null && !attrNamespace.equals(namespace)) continue;
                attributes.put(attrNode.getLocalName(), attrNode.getNodeValue());
            }
        }
        result = cmisChildren.isEmpty() ? new CmisExtensionElementImpl(namespace, name, attributes, value.toString()) : new CmisExtensionElementImpl(namespace, name, attributes, cmisChildren);
        return result;
    }

    private static Node convertCmisExtensionElementToNode(CmisExtensionElement source) {
        if (source == null) {
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Unable to convert extensions!", (Throwable)e);
        }
        Element root = doc.createElementNS(source.getNamespace() == null ? DEFAULT_EXTENSION_NS : source.getNamespace(), source.getName());
        doc.appendChild(root);
        if (source.getValue() != null) {
            root.appendChild(doc.createTextNode(source.getValue()));
        } else {
            for (CmisExtensionElement cmisExtensionElement : source.getChildren()) {
                root.appendChild(Converter.convertCmisExtensionElementToNode(cmisExtensionElement, root, doc));
            }
        }
        if (source.getAttributes() != null) {
            for (Map.Entry entry : source.getAttributes().entrySet()) {
                root.setAttributeNS(source.getNamespace() == null ? DEFAULT_EXTENSION_NS : source.getNamespace(), (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return root;
    }

    private static Node convertCmisExtensionElementToNode(CmisExtensionElement source, Element parent, Document doc) {
        if (source == null) {
            return null;
        }
        Element element = doc.createElementNS(source.getNamespace() == null ? DEFAULT_EXTENSION_NS : source.getNamespace(), source.getName());
        if (source.getValue() != null) {
            element.appendChild(doc.createTextNode(source.getValue()));
        } else {
            for (CmisExtensionElement cmisExtensionElement : source.getChildren()) {
                element.appendChild(Converter.convertCmisExtensionElementToNode(cmisExtensionElement, element, doc));
            }
        }
        if (source.getAttributes() != null) {
            for (Map.Entry entry : source.getAttributes().entrySet()) {
                element.setAttributeNS(source.getNamespace() == null ? DEFAULT_EXTENSION_NS : source.getNamespace(), (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return element;
    }

    private static boolean convertBoolean(Boolean value, boolean def) {
        return value == null ? def : value;
    }

    public static <T extends Enum<T>> T convert(Class<T> destClass, Enum<?> source) {
        if (source == null) {
            return null;
        }
        return Enum.valueOf(destClass, source.name());
    }
}

