/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeHelper {
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String DISPOSITION_ATTACHMENT = "attachment";
    public static final String DISPOSITION_INLINE = "inline";
    public static final String DISPOSITION_FILENAME = "filename";
    public static final String DISPOSITION_NAME = "name";
    public static final String DISPOSITION_FORM_DATA_CONTENT = "form-data; name=\"content\"";
    private static final String MIME_SPECIALS = "()<>@,;:\\\"/[]?=\t ";
    private static final String RFC2231_SPECIALS = "*'%()<>@,;:\\\"/[]?=\t ";
    private static final String WHITE = " \t\n\r";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final byte[] HEX_DECODE = new byte[128];

    private MimeHelper() {
    }

    protected static boolean encodeRFC2231value(String value, StringBuilder buf) {
        byte[] bytes;
        String charset = "UTF-8";
        buf.append(charset);
        buf.append("''");
        try {
            bytes = value.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
        boolean encoded = false;
        for (int i = 0; i < bytes.length; ++i) {
            int ch = bytes[i] & 0xFF;
            if (ch <= 32 || ch >= 127 || RFC2231_SPECIALS.indexOf(ch) != -1) {
                buf.append('%');
                buf.append(HEX_DIGITS[ch >> 4]);
                buf.append(HEX_DIGITS[ch & 0xF]);
                encoded = true;
                continue;
            }
            buf.append((char)ch);
        }
        return encoded;
    }

    protected static String encodeRFC2231(String key, String value) {
        StringBuilder buf = new StringBuilder();
        boolean encoded = MimeHelper.encodeRFC2231value(value, buf);
        if (encoded) {
            return "; " + key + "*=" + buf.toString();
        }
        return "; " + key + "=" + value;
    }

    public static String encodeContentDisposition(String disposition, String filename) {
        if (disposition == null) {
            disposition = DISPOSITION_ATTACHMENT;
        }
        return disposition + MimeHelper.encodeRFC2231(DISPOSITION_FILENAME, filename);
    }

    public static String decodeContentDispositionFilename(String value) {
        HashMap<String, String> params = new HashMap<String, String>();
        MimeHelper.decodeContentDisposition(value, params);
        return (String)params.get(DISPOSITION_FILENAME);
    }

    public static String decodeContentDisposition(String value, Map<String, String> params) {
        try {
            HeaderTokenizer tokenizer = new HeaderTokenizer(value);
            Token token = tokenizer.next();
            if (token.getType() != -1) {
                return null;
            }
            String disposition = token.getValue();
            String remainder = tokenizer.getRemainder();
            if (remainder != null) {
                MimeHelper.getParameters(remainder, params);
            }
            return disposition;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getCharsetFromContentType(String value) {
        try {
            HeaderTokenizer tokenizer = new HeaderTokenizer(value, ";", true);
            Token token = tokenizer.next();
            if (token.getType() != -1) {
                return null;
            }
            String remainder = tokenizer.getRemainder();
            if (remainder != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                MimeHelper.getParameters(remainder, params);
                return (String)params.get("charset");
            }
        }
        catch (ParseException e) {
            return null;
        }
        return null;
    }

    public static byte[] getBoundaryFromMultiPart(String value) {
        try {
            HeaderTokenizer tokenizer = new HeaderTokenizer(value, ";", true);
            Token token = tokenizer.next();
            if (token.getType() != -1) {
                return null;
            }
            String multipartContentType = token.getValue();
            if (multipartContentType == null || !multipartContentType.equalsIgnoreCase("multipart/form-data")) {
                return null;
            }
            String remainder = tokenizer.getRemainder();
            if (remainder != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                MimeHelper.getParameters(remainder, params);
                String boundaryStr = (String)params.get("boundary");
                if (boundaryStr != null && boundaryStr.length() > 0) {
                    try {
                        return boundaryStr.getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException e) {
                        return boundaryStr.getBytes();
                    }
                }
            }
        }
        catch (ParseException e) {
            return null;
        }
        return null;
    }

    protected static Map<String, String> getParameters(String list, Map<String, String> params) throws ParseException {
        HeaderTokenizer tokenizer = new HeaderTokenizer(list);
        block4: while (true) {
            Token token = tokenizer.next();
            switch (token.getType()) {
                case -4: {
                    return params;
                }
                case 59: {
                    token = tokenizer.next();
                    if (token.getType() == -4) {
                        return params;
                    }
                    if (token.getType() != -1) {
                        throw new ParseException("Invalid parameter name: " + token.getValue());
                    }
                    String name = token.getValue().toLowerCase(Locale.ENGLISH);
                    token = tokenizer.next();
                    if (token.getType() != 61) {
                        throw new ParseException("Missing '='");
                    }
                    token = tokenizer.next();
                    if (token.getType() != -1 && token.getType() != -2) {
                        throw new ParseException("Invalid parameter value: " + token.getValue());
                    }
                    String value = token.getValue();
                    if (name.endsWith("*")) {
                        name = name.substring(0, name.length() - 1);
                        value = MimeHelper.decodeRFC2231value(value);
                    }
                    params.put(name, value);
                    continue block4;
                }
            }
            break;
        }
        throw new ParseException("Missing ';'");
    }

    protected static String decodeRFC2231value(String value) {
        int q1 = value.indexOf(39);
        if (q1 == -1) {
            return value;
        }
        String mimeCharset = value.substring(0, q1);
        int q2 = value.indexOf(39, q1 + 1);
        if (q2 == -1) {
            return value;
        }
        byte[] bytes = MimeHelper.fromHex(value.substring(q2 + 1));
        try {
            return new String(bytes, MimeHelper.getJavaCharset(mimeCharset));
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    protected static byte[] fromHex(String data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < data.length()) {
            char c;
            if ((c = data.charAt(i++)) == '%') {
                if (i > data.length() - 2) break;
                byte b1 = HEX_DECODE[data.charAt(i++) & 0x7F];
                byte b2 = HEX_DECODE[data.charAt(i++) & 0x7F];
                out.write(b1 << 4 | b2);
                continue;
            }
            out.write((byte)c);
        }
        return out.toByteArray();
    }

    protected static String getJavaCharset(String mimeCharset) {
        return mimeCharset;
    }

    static {
        for (int i = 0; i < HEX_DIGITS.length; ++i) {
            MimeHelper.HEX_DECODE[MimeHelper.HEX_DIGITS[i]] = (byte)i;
        }
    }

    protected static class HeaderTokenizer {
        private static final Token EOF = new Token(-4, null);
        private final String header;
        private final String delimiters;
        private final boolean skipComments;
        private int pos;

        public HeaderTokenizer(String header) {
            this(header, MimeHelper.MIME_SPECIALS, true);
        }

        protected HeaderTokenizer(String header, String delimiters, boolean skipComments) {
            this.header = header;
            this.delimiters = delimiters;
            this.skipComments = skipComments;
        }

        public String getRemainder() {
            return this.header.substring(this.pos);
        }

        public Token next() throws ParseException {
            return this.readToken();
        }

        private Token readAtomicToken() {
            int start = this.pos;
            while (++this.pos < this.header.length()) {
                char ch = this.header.charAt(this.pos);
                if (this.delimiters.indexOf(this.header.charAt(this.pos)) == -1 && ch >= ' ' && ch < '\u007f') continue;
                break;
            }
            return new Token(-1, this.header.substring(start, this.pos));
        }

        private Token readToken() throws ParseException {
            if (this.pos >= this.header.length()) {
                return EOF;
            }
            char c = this.header.charAt(this.pos);
            if (c == '(') {
                Token comment = this.readComment();
                if (this.skipComments) {
                    return this.readToken();
                }
                return comment;
            }
            if (c == '\"') {
                return this.readQuotedString();
            }
            if (MimeHelper.WHITE.indexOf(c) != -1) {
                this.eatWhiteSpace();
                return this.readToken();
            }
            if (c < ' ' || c >= '\u007f' || this.delimiters.indexOf(c) != -1) {
                ++this.pos;
                return new Token(c, String.valueOf(c));
            }
            return this.readAtomicToken();
        }

        private String getEscapedValue(int start, int end) throws ParseException {
            StringBuffer value = new StringBuffer();
            for (int i = start; i < end; ++i) {
                char ch = this.header.charAt(i);
                if (ch == '\\') {
                    if (++i == end) {
                        throw new ParseException("Invalid escape character");
                    }
                    value.append(this.header.charAt(i));
                    continue;
                }
                if (ch == '\r') {
                    if (i >= end - 1 || this.header.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                value.append(ch);
            }
            return value.toString();
        }

        private Token readComment() throws ParseException {
            int start = this.pos + 1;
            int nesting = 1;
            boolean requiresEscaping = false;
            while (++this.pos < this.header.length()) {
                char ch = this.header.charAt(this.pos);
                if (ch == ')') {
                    if (--nesting != 0) continue;
                    break;
                }
                if (ch == '(') {
                    ++nesting;
                    continue;
                }
                if (ch == '\\') {
                    ++this.pos;
                    requiresEscaping = true;
                    continue;
                }
                if (ch != '\r') continue;
                requiresEscaping = true;
            }
            if (nesting != 0) {
                throw new ParseException("Unbalanced comments");
            }
            String value = requiresEscaping ? this.getEscapedValue(start, this.pos) : this.header.substring(start, this.pos++);
            return new Token(-3, value);
        }

        private Token readQuotedString() throws ParseException {
            int start = this.pos + 1;
            boolean requiresEscaping = false;
            while (++this.pos < this.header.length()) {
                char ch = this.header.charAt(this.pos);
                if (ch == '\"') {
                    String value = requiresEscaping ? this.getEscapedValue(start, this.pos++) : this.header.substring(start, this.pos++);
                    return new Token(-2, value);
                }
                if (ch == '\\') {
                    ++this.pos;
                    requiresEscaping = true;
                    continue;
                }
                if (ch != '\r') continue;
                requiresEscaping = true;
            }
            throw new ParseException("Missing '\"'");
        }

        private void eatWhiteSpace() {
            while (++this.pos < this.header.length() && MimeHelper.WHITE.indexOf(this.header.charAt(this.pos)) != -1) {
            }
        }
    }

    protected static class Token {
        public static final int ATOM = -1;
        public static final int COMMENT = -3;
        public static final int EOF = -4;
        public static final int QUOTEDSTRING = -2;
        private final int _type;
        private final String _value;

        public Token(int type, String value) {
            this._type = type;
            this._value = value;
        }

        public int getType() {
            return this._type;
        }

        public String getValue() {
            return this._value;
        }
    }

    protected static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException() {
        }

        public ParseException(String message) {
            super(message);
        }
    }
}

