/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.owdummy.ui;

import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.app.OwStandardFieldManager;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.field.OwFieldDefinition;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OwDummyFieldManager
extends OwStandardFieldManager {
    protected static final PersonalNumberPrefixes m_PersonalNumberPrefixes = new PersonalNumberPrefixes();

    public void insertReadOnlyFieldInternal(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (value_p != null) {
            if (fieldDef_p.getClassName().equals("EmployeeNumber")) {
                String strFormatedNumber = (String)value_p;
                if (strFormatedNumber.length() == 6) {
                    String strPrefix = strFormatedNumber.substring(0, 1);
                    String strNumber = strFormatedNumber.substring(1);
                    strFormatedNumber = "<b>" + strPrefix + "</b> - " + strNumber;
                }
                w_p.write(strFormatedNumber);
            } else if (fieldDef_p.getClassName().equals("Image")) {
                String strImageUploadURL = this.getContext().getBaseURL() + "/getContent?" + "dmsid" + "=" + ((OwObject)value_p).getDMSID();
                String toolTip = this.getContext().localize1("owdummy.ui.OwDummyFieldManager.propertyimagetooltip", "Image of property %1", fieldDef_p.getDisplayName(this.getContext().getLocale()));
                w_p.write("<img src=\"" + strImageUploadURL + "\" alt=\"" + toolTip + "\" title=\"" + toolTip + "\"/>");
            } else if (fieldDef_p.getClassName().equals("Gender")) {
                if (((Boolean)value_p).booleanValue()) {
                    w_p.write(this.getContext().localize("owdummy.ui.OwDummyFieldManager.male", "male"));
                } else {
                    w_p.write(this.getContext().localize("owdummy.ui.OwDummyFieldManager.female", "female"));
                }
            } else {
                super.insertReadOnlyFieldInternal(w_p, fieldDef_p, value_p);
            }
        }
    }

    private String getPersonalnummerFormatError() {
        return this.getContext().localize("owdummy.ui.OwFNCMDemoFieldManager.personalnummererror", "The personnel number is formatted as follows: CXXXXX. Where X are 5 decimal digits and C is one of the following categories:") + " " + m_PersonalNumberPrefixes.toString();
    }

    public Object updateFieldInternal(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        Object ret = super.updateFieldInternal(request_p, fieldDef_p, value_p, strID_p);
        if (fieldDef_p.getClassName().equals("EmployeeNumber")) {
            if (((String)ret).length() < 6) {
                throw new OwFieldManagerException(this.getPersonalnummerFormatError());
            }
            String strPrefix = ((String)ret).substring(0, 1);
            String strNumber = ((String)ret).substring(1);
            if (((String)ret).charAt(1) == '-') {
                strNumber = ((String)ret).substring(2);
            }
            try {
                Integer.parseInt(strNumber);
            }
            catch (NumberFormatException e) {
                throw new OwFieldManagerException(this.getPersonalnummerFormatError());
            }
            if (!OwDummyFieldManager.m_PersonalNumberPrefixes.m_prefixes.containsKey(strPrefix)) {
                throw new OwFieldManagerException(this.getPersonalnummerFormatError());
            }
            if (strNumber.length() != 5) {
                throw new OwFieldManagerException(this.getPersonalnummerFormatError());
            }
            return strPrefix + strNumber;
        }
        return ret;
    }

    public static class PersonalNumberPrefixes {
        public Map m_prefixes = new HashMap();

        public PersonalNumberPrefixes() {
            this.m_prefixes.put("I", "Internal");
            this.m_prefixes.put("M", "Management");
            this.m_prefixes.put("F", "Freelancer");
            this.m_prefixes.put("T", "Trainee");
        }

        public String toString() {
            StringBuffer strRet = new StringBuffer();
            Iterator it = this.m_prefixes.keySet().iterator();
            boolean fAddDelimiter = false;
            while (it.hasNext()) {
                if (fAddDelimiter) {
                    strRet.append(", ");
                }
                String strKey = (String)it.next();
                strRet.append(strKey + " (for " + this.m_prefixes.get(strKey) + ")");
                fAddDelimiter = true;
            }
            return strRet.toString();
        }
    }
}

