/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMasterDocument;
import com.wewebu.ow.server.app.OwRecordFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.plug.owrecord.OwRecordDocument;
import com.wewebu.ow.server.plug.owrecord.log.OwLog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwRecordRecordFunctionView
extends OwView
implements OwClientRefreshContext {
    public static final String UPDATE_AJAX_EVENT_NAME = "Update";
    private static final Logger LOG = OwLog.getLogger(OwRecordRecordFunctionView.class);
    protected static final String QUERY_KEY_PLUGIN = "plugin";
    protected List m_recordFunctionPluginList;
    protected List m_DocumentFunctionPluginList;
    private boolean m_fshowDisabledRecordFunctions;
    private boolean m_fDocumentFunctionsWorkOnRoot;

    public void init() throws Exception {
        List recfunctions;
        List docfunctions;
        super.init();
        this.m_fshowDisabledRecordFunctions = ((OwMasterDocument)this.getDocument()).getConfigNode().getSafeBooleanValue("showDisabledRecordFunctions", true);
        OwXMLUtil documentFunctionPluginsNode = ((OwRecordDocument)this.getDocument()).getDocumentFunctionPluginsNode();
        OwXMLUtil recordFunctionPluginsNode = ((OwRecordDocument)this.getDocument()).getRecordFunctionPluginsNode();
        this.m_fDocumentFunctionsWorkOnRoot = documentFunctionPluginsNode.getSafeBooleanAttributeValue("workonroot", true);
        if (documentFunctionPluginsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_DocumentFunctionPluginList = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunctionPlugins();
        }
        if (recordFunctionPluginsNode.getSafeBooleanAttributeValue("enable", false)) {
            this.m_recordFunctionPluginList = ((OwMainAppContext)this.getContext()).getConfiguration().getRecordFunctionPlugins();
        }
        if ((docfunctions = documentFunctionPluginsNode.getSafeStringList()).size() != 0) {
            this.m_DocumentFunctionPluginList = new Vector();
            for (String id : docfunctions) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                OwDocumentFunction func = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                this.m_DocumentFunctionPluginList.add(func);
            }
        }
        if ((recfunctions = recordFunctionPluginsNode.getSafeStringList()).size() != 0) {
            this.m_recordFunctionPluginList = new Vector();
            for (String id : recfunctions) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isRecordFunctionAllowed(id)) continue;
                OwRecordFunction func = ((OwMainAppContext)this.getContext()).getConfiguration().getRecordFunction(id);
                this.m_recordFunctionPluginList.add(func);
            }
        }
        int iDragDropTargetCount = 0;
        if (this.m_recordFunctionPluginList != null) {
            for (int i = 0; i < this.m_recordFunctionPluginList.size(); ++i) {
                OwRecordFunction recordFunctionPlugin = (OwRecordFunction)this.m_recordFunctionPluginList.get(i);
                if (!recordFunctionPlugin.isDragDropTarget()) continue;
                ++iDragDropTargetCount;
            }
        }
        if (iDragDropTargetCount > 1) {
            String msg = "OwRecordRecordFunctionView.init: Only ONE record plugin may be configured as DragDropTarget.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
    }

    public boolean showDisabledRecordFunctions() {
        return this.m_fshowDisabledRecordFunctions;
    }

    public List getRecordFuntionPlugins() {
        return this.m_recordFunctionPluginList;
    }

    public List getDocumentFuntionPlugins() {
        return this.m_DocumentFunctionPluginList;
    }

    public String getDocumentFunctionEventURL(int iPlugIndex_p) {
        return this.getEventURL("DocumentFunctionPluginEvent", "plugin=" + String.valueOf(iPlugIndex_p));
    }

    public String getRecordFunctionEventURL(int iPlugIndex_p) {
        StringBuffer query = new StringBuffer();
        query.append(QUERY_KEY_PLUGIN);
        query.append("=");
        query.append(String.valueOf(iPlugIndex_p));
        return this.getEventURL("RecordFunctionPluginEvent", query.toString());
    }

    public boolean getIsPluginEnabled(OwDocumentFunction docFunctionPlugin_p) throws Exception {
        try {
            if (this.getDocumentFunctionWorkobjectParent() == null && docFunctionPlugin_p.getNeedParent()) {
                return false;
            }
            if (!docFunctionPlugin_p.isEnabled(this.getDocumentFunctionWorkobject(), this.getDocumentFunctionWorkobjectParent(), 1)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean getIsPluginEnabled(OwRecordFunction recordFunctionPlugin_p) throws Exception {
        OwObject currentSubFolderObject = ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObject();
        OwObject rootObject = ((OwRecordDocument)this.getDocument()).getCurrentRootFolder();
        if (currentSubFolderObject == null && rootObject != null) {
            currentSubFolderObject = rootObject;
            OwRecordDocument recordDocument = (OwRecordDocument)this.getDocument();
            recordDocument.openFolder(currentSubFolderObject, null);
        }
        boolean enabled = recordFunctionPlugin_p.isEnabled(rootObject, currentSubFolderObject, 1);
        return enabled;
    }

    public OwObject getCurrentSubFolderObject() {
        return ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObject();
    }

    public OwObject getCurrentSubFolderObjectParent() {
        return ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObjectParent();
    }

    public OwObject getCurrentRootFolder() {
        return ((OwRecordDocument)this.getDocument()).getCurrentRootFolder();
    }

    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("owrecord/OwRecordRecordFunctionView.jsp", w_p);
    }

    public OwObject getDocumentFunctionWorkobject() {
        if (this.m_fDocumentFunctionsWorkOnRoot) {
            return ((OwRecordDocument)this.getDocument()).getCurrentRootFolder();
        }
        return ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObject();
    }

    public OwObject getDocumentFunctionWorkobjectParent() {
        if (this.m_fDocumentFunctionsWorkOnRoot) {
            return null;
        }
        return ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObjectParent();
    }

    public void onDocumentFunctionPluginEvent(HttpServletRequest request_p) throws Exception {
        OwDocumentFunction docFunctionPlugin = (OwDocumentFunction)this.m_DocumentFunctionPluginList.get(Integer.parseInt(request_p.getParameter(QUERY_KEY_PLUGIN)));
        docFunctionPlugin.onClickEvent(this.getDocumentFunctionWorkobject(), this.getDocumentFunctionWorkobjectParent(), (OwClientRefreshContext)this);
    }

    public void onRecordFunctionPluginEvent(HttpServletRequest request_p) throws Exception {
        String subpath = ((OwRecordDocument)this.getDocument()).getCurrentSubFolderPath();
        if (subpath != null && subpath.equals("/")) {
            subpath = null;
        }
        String displaypath = ((OwRecordDocument)this.getDocument()).getCurrentSubFolderDisplayPath();
        OwRecordFunction recordFunctionPlugin = (OwRecordFunction)this.m_recordFunctionPluginList.get(Integer.parseInt(request_p.getParameter(QUERY_KEY_PLUGIN)));
        recordFunctionPlugin.onClickEvent(((OwRecordDocument)this.getDocument()).getCurrentRootFolder(), ((OwRecordDocument)this.getDocument()).getCurrentSubFolderObject(), subpath, displaypath, (OwClientRefreshContext)this);
    }

    public void onClientRefreshContextUpdate(int iReason_p, Object param_p) throws Exception {
        switch (iReason_p) {
            case 11: {
                if (this.getDocumentFunctionWorkobject() == ((OwRecordDocument)this.getDocument()).getCurrentRootFolder()) {
                    this.getDocument().update((OwEventTarget)this, 11, param_p);
                    break;
                }
                this.getDocument().update((OwEventTarget)this, 14, param_p);
                break;
            }
            default: {
                this.getDocument().update((OwEventTarget)this, iReason_p, param_p);
            }
        }
    }

    public void onAjaxUpdate(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        PrintWriter writer = response_p.getWriter();
        this.render(writer);
        writer.close();
    }
}

