/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owrecord.filter;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.filter.OwComparator;
import com.wewebu.ow.server.fieldimpl.filter.OwBoolComparator;
import com.wewebu.ow.server.fieldimpl.filter.OwDateComparator;
import com.wewebu.ow.server.fieldimpl.filter.OwNumberComparator;
import com.wewebu.ow.server.fieldimpl.filter.OwStringComparator;
import com.wewebu.ow.server.plug.owrecord.filter.OwFilterRuntimeException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OwFilterHelper {
    HashMap<String, OwComparator<?>> map = new HashMap();

    public List filterCollection(OwSearchCriteria filter, List collection) throws ClassNotFoundException {
        LinkedList<OwObject> retCol = new LinkedList<OwObject>();
        for (OwObject obj : collection) {
            if (!this.fitFilter(filter, obj)) continue;
            retCol.add(obj);
        }
        return retCol;
    }

    protected boolean fitFilter(OwSearchCriteria filter, OwObject obj) throws ClassNotFoundException {
        OwProperty prop;
        try {
            prop = obj.getProperty(filter.getClassName());
        }
        catch (OwObjectNotFoundException onfex) {
            return false;
        }
        catch (Exception e) {
            throw new OwFilterRuntimeException("Cannot retrieve property object!", e);
        }
        return this.fitFilter(filter, prop);
    }

    protected boolean fitFilter(OwSearchCriteria filter, OwProperty prop) throws ClassNotFoundException {
        String className;
        Object value = null;
        try {
            value = prop.getValue();
        }
        catch (Exception e) {
            throw new OwFilterRuntimeException("Cannot retrieve value from property!", e);
        }
        try {
            className = prop.getPropertyClass().getJavaClassName();
        }
        catch (Exception e) {
            throw new OwFilterRuntimeException("Cannot retrieve java representation type of property value.", e);
        }
        OwComparator compare = this.getComparator(className);
        return compare.match(filter, value);
    }

    protected OwComparator getComparator(String javaClassName) throws ClassNotFoundException {
        OwComparator<?> compare;
        if (this.map.containsKey(javaClassName)) {
            compare = this.map.get(javaClassName);
        } else {
            Class<?> clazz = Class.forName(javaClassName);
            compare = this.createComparator(clazz);
            this.map.put(javaClassName, compare);
        }
        return compare;
    }

    public OwComparator<?> createComparator(Class<?> clazz) {
        if (Date.class.isAssignableFrom(clazz)) {
            return new OwDateComparator();
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return new OwBoolComparator();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return new OwNumberComparator();
        }
        return new OwStringComparator();
    }
}

