/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.api.TransientDocument;
import org.apache.chemistry.opencmis.client.runtime.AbstractFilableCmisObject;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.TransientDocumentImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentImpl
extends AbstractFilableCmisObject
implements Document {
    private static final long serialVersionUID = 1L;

    public DocumentImpl(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        this.initialize(session, objectType, objectData, context);
    }

    @Override
    protected TransientCmisObject createTransientCmisObject() {
        TransientDocumentImpl td = new TransientDocumentImpl();
        td.initialize(this.getSession(), this);
        return td;
    }

    public TransientDocument getTransientDocument() {
        return (TransientDocument)this.getTransientObject();
    }

    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    public long getContentStreamLength() {
        BigInteger bigInt = (BigInteger)this.getPropertyValue("cmis:contentStreamLength");
        return bigInt == null ? -1L : bigInt.longValue();
    }

    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    public Document copy(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = null;
        try {
            newId = this.getSession().createDocumentFromSource((ObjectId)this, properties, targetFolderId, versioningState, policies, addAces, removeAces);
        }
        catch (CmisNotSupportedException nse) {
            newId = this.copyViaClient(targetFolderId, properties, versioningState, policies, addAces, removeAces);
        }
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Document)) {
            throw new CmisRuntimeException("Newly created object is not a document! New id: " + newId);
        }
        return (Document)object;
    }

    public Document copy(ObjectId targetFolderId) {
        return this.copy(targetFolderId, null, null, null, null, null, this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectId copyViaClient(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        OperationContext allPropsContext = this.getSession().createOperationContext();
        allPropsContext.setFilterString("*");
        allPropsContext.setIncludeAcls(false);
        allPropsContext.setIncludeAllowableActions(false);
        allPropsContext.setIncludePathSegments(false);
        allPropsContext.setIncludePolicies(false);
        allPropsContext.setIncludeRelationships(IncludeRelationships.NONE);
        allPropsContext.setRenditionFilterString("cmis:none");
        Document allPropsDoc = (Document)this.getSession().getObject((ObjectId)this, allPropsContext);
        for (Property prop : allPropsDoc.getProperties()) {
            if (prop.getDefinition().getUpdatability() != Updatability.READWRITE && prop.getDefinition().getUpdatability() != Updatability.ONCREATE) continue;
            newProperties.put(prop.getId(), prop.getValue());
        }
        if (properties != null) {
            newProperties.putAll(properties);
        }
        ContentStream contentStream = allPropsDoc.getContentStream();
        try {
            ObjectId objectId = this.getSession().createDocument(newProperties, targetFolderId, contentStream, versioningState, policies, addAces, removeAces);
            return objectId;
        }
        finally {
            if (contentStream != null && contentStream.getStream() != null) {
                try {
                    contentStream.getStream().close();
                }
                catch (IOException ioe) {
                    throw new CmisRuntimeException("Cannot close source stream!", (Throwable)ioe);
                }
            }
        }
    }

    public void deleteAllVersions() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId checkOut() {
        String newObjectId = null;
        this.readLock();
        try {
            String objectId = this.getObjectId();
            Holder objectIdHolder = new Holder((Object)objectId);
            this.getBinding().getVersioningService().checkOut(this.getRepositoryId(), objectIdHolder, null, null);
            newObjectId = (String)objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        this.getSession().removeObjectFromCache((ObjectId)this);
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public void cancelCheckOut() {
        String objectId = this.getObjectId();
        this.getBinding().getVersioningService().cancelCheckOut(this.getRepositoryId(), objectId, null);
        this.getSession().removeObjectFromCache((ObjectId)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder objectIdHolder = new Holder((Object)this.getObjectId());
            ObjectFactory of = this.getObjectFactory();
            HashSet<Updatability> updatebility = new HashSet<Updatability>();
            updatebility.add(Updatability.READWRITE);
            updatebility.add(Updatability.WHENCHECKEDOUT);
            this.getBinding().getVersioningService().checkIn(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(major), of.convertProperties(properties, this.getType(), updatebility), of.convertContentStream(contentStream), checkinComment, of.convertPolicies(policies), of.convertAces(addAces), of.convertAces(removeAces), null);
            newObjectId = (String)objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        this.getSession().removeObjectFromCache((ObjectId)this);
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public List<Document> getAllVersions() {
        return this.getAllVersions(this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> getAllVersions(OperationContext context) {
        String versionSeriesId;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            versionSeriesId = this.getVersionSeriesId();
        }
        finally {
            this.readUnlock();
        }
        List versions = this.getBinding().getVersioningService().getAllVersions(this.getRepositoryId(), objectId, versionSeriesId, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), null);
        ObjectFactory objectFactory = this.getSession().getObjectFactory();
        ArrayList<Document> result = new ArrayList<Document>();
        if (versions != null) {
            for (ObjectData objectData : versions) {
                CmisObject doc = objectFactory.convertObject(objectData, context);
                if (!(doc instanceof Document)) continue;
                result.add((Document)doc);
            }
        }
        return result;
    }

    public Document getObjectOfLatestVersion(boolean major) {
        return this.getObjectOfLatestVersion(major, this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        String versionSeriesId;
        String objectId;
        this.readLock();
        try {
            objectId = this.getObjectId();
            versionSeriesId = this.getVersionSeriesId();
        }
        finally {
            this.readUnlock();
        }
        if (versionSeriesId == null) {
            throw new CmisRuntimeException("Version series id is unknown!");
        }
        ObjectData objectData = this.getBinding().getVersioningService().getObjectOfLatestVersion(this.getRepositoryId(), objectId, versionSeriesId, Boolean.valueOf(major), context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
        ObjectFactory objectFactory = this.getSession().getObjectFactory();
        CmisObject result = objectFactory.convertObject(objectData, context);
        if (!(result instanceof Document)) {
            throw new CmisRuntimeException("Latest version is not a document!");
        }
        return (Document)result;
    }

    public ContentStream getContentStream() {
        return this.getContentStream(null, null, null);
    }

    public ContentStream getContentStream(BigInteger offset, BigInteger length) {
        return this.getContentStream(null, offset, length);
    }

    public ContentStream getContentStream(String streamId) {
        return this.getContentStream(streamId, null, null);
    }

    public ContentStream getContentStream(String streamId, BigInteger offset, BigInteger length) {
        ContentStream contentStream = this.getSession().getContentStream((ObjectId)this, streamId, offset, length);
        if (contentStream == null) {
            return null;
        }
        String filename = contentStream.getFileName();
        if (filename == null) {
            filename = this.getContentStreamFileName();
        }
        long lengthLong = contentStream.getBigLength() == null ? -1L : contentStream.getBigLength().longValue();
        return this.getSession().getObjectFactory().createContentStream(filename, lengthLong, contentStream.getMimeType(), contentStream.getStream());
    }

    public Document setContentStream(ContentStream contentStream, boolean overwrite) {
        ObjectId objectId = this.setContentStream(contentStream, overwrite, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return (Document)this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite, boolean refresh) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder objectIdHolder = new Holder((Object)this.getObjectId());
            Holder changeTokenHolder = new Holder((Object)((String)this.getPropertyValue("cmis:changeToken")));
            this.getBinding().getObjectService().setContentStream(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(overwrite), changeTokenHolder, this.getObjectFactory().convertContentStream(contentStream), null);
            newObjectId = (String)objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public Document deleteContentStream() {
        ObjectId objectId = this.deleteContentStream(true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return (Document)this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId deleteContentStream(boolean refresh) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder objectIdHolder = new Holder((Object)this.getObjectId());
            Holder changeTokenHolder = new Holder((Object)((String)this.getPropertyValue("cmis:changeToken")));
            this.getBinding().getObjectService().deleteContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, null);
            newObjectId = (String)objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        return this.checkIn(major, properties, contentStream, checkinComment, null, null, null);
    }
}

