/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.GrizzlyThreadFactory;
import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.Task;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorPipeline
implements Pipeline,
RejectedExecutionHandler {
    private int waitingThreads = 0;
    private int maxThreads = 20;
    private int minThreads = 10;
    private int port = 8080;
    private int threadCount = 0;
    private String name;
    private int priority = 5;
    private boolean isStarted = false;
    private ThreadPoolExecutor workerThreads;
    private ArrayBlockingQueue<Runnable> arrayBlockingQueue;
    private int maxQueueSizeInBytes = -1;
    private int queueSizeInBytes = 4096;
    protected PipelineStatistic pipelineStat;

    public void initPipeline() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.arrayBlockingQueue = new ArrayBlockingQueue(this.maxQueueSizeInBytes, true);
        this.workerThreads = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 0L, TimeUnit.MILLISECONDS, this.arrayBlockingQueue, new GrizzlyThreadFactory(this.name, this.port, this.priority), this);
    }

    public void startPipeline() {
        if (this.isStarted) {
            return;
        }
    }

    public void stopPipeline() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.workerThreads.shutdown();
    }

    public void addTask(Task task) {
        if (this.workerThreads.getQueue().size() > this.maxQueueSizeInBytes) {
            task.cancelTask("Maximum Connections Reached: " + this.pipelineStat.getQueueSizeInBytes() + " -- Retry later", HtmlHelper.OK);
            task.getSelectorThread().returnTask(task);
            return;
        }
        this.workerThreads.execute(task);
        if (this.pipelineStat != null) {
            this.pipelineStat.gather(this.size());
        }
    }

    public Task getTask() {
        return null;
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public int size() {
        return this.workerThreads.getQueue().size();
    }

    public boolean interruptThread(long threadID) {
        return ((GrizzlyThreadFactory)this.workerThreads.getThreadFactory()).interruptThread(threadID);
    }

    public int getWaitingThread() {
        return this.workerThreads.getPoolSize() - this.workerThreads.getActiveCount();
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return this.workerThreads.getPoolSize();
    }

    public int getCurrentThreadsBusy() {
        return this.workerThreads.getActiveCount();
    }

    public int getMaxSpareThreads() {
        return this.getWaitingThread();
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
        if (this.pipelineStat != null) {
            this.pipelineStat.setQueueSizeInBytes(maxQueueSizeInBytes);
        }
    }

    public int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public String toString() {
        return "name: " + this.name + " maxThreads: " + this.maxThreads + " minThreads:" + this.minThreads;
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        Task task = (Task)r;
        task.cancelTask("Maximum Connections Reached -- Retry later", HtmlHelper.OK);
        task.getSelectorThread().returnTask(task);
    }

    public void setThreadsIncrement(int threadsIncrement) {
    }

    public void setThreadsTimeout(int threadsTimeout) {
    }

    public int getMinSpareThreads() {
        return 0;
    }

    public void setMinSpareThreads(int minSpareThreads) {
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }
}

