/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class CometReader {
    private SocketChannel socketChannel;
    private ByteBuffer byteBuffer;
    private int nRead = 0;
    private boolean ready = true;

    protected void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (!this.ready) {
            throw new IllegalStateException("This CometReader is no longer usable");
        }
        if (this.byteBuffer != null) {
            this.byteBuffer.get(buf, off, len);
            return this.nRead > len ? len : this.nRead;
        }
        return this.socketChannel.read(ByteBuffer.wrap(buf, off, len));
    }

    public void recycle() {
        this.nRead = 0;
        this.byteBuffer = null;
        this.socketChannel = null;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setNRead(int nRead) {
        this.nRead = nRead;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

