/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.PortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.VersioningServiceImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisWebServicesSpi
implements CmisSpi {
    private static final Logger log = LoggerFactory.getLogger(CmisWebServicesSpi.class);
    private final RepositoryService repositoryService;
    private final NavigationService navigationService;
    private final ObjectService objectService;
    private final VersioningService versioningService;
    private final DiscoveryService discoveryService;
    private final MultiFilingService multiFilingService;
    private final RelationshipService relationshipService;
    private final PolicyService policyService;
    private final AclService aclService;

    public CmisWebServicesSpi(BindingSession session) {
        if (log.isDebugEnabled()) {
            log.debug("Initializing Web Services SPI...");
        }
        AbstractPortProvider portProvider = null;
        String portProviderClass = (String)session.get("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname");
        if (portProviderClass == null) {
            portProvider = new PortProvider();
        } else {
            Object portProviderObj = null;
            try {
                portProviderObj = Class.forName(portProviderClass).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not load port provider: " + e, e);
            }
            if (!(portProviderObj instanceof AbstractPortProvider)) {
                throw new IllegalArgumentException("Port provider does not implement AbstractPortProvider!");
            }
            portProvider = portProviderObj;
        }
        portProvider.setSession(session);
        this.repositoryService = new RepositoryServiceImpl(session, portProvider);
        this.navigationService = new NavigationServiceImpl(session, portProvider);
        this.objectService = new ObjectServiceImpl(session, portProvider);
        this.versioningService = new VersioningServiceImpl(session, portProvider);
        this.discoveryService = new DiscoveryServiceImpl(session, portProvider);
        this.multiFilingService = new MultiFilingServiceImpl(session, portProvider);
        this.relationshipService = new RelationshipServiceImpl(session, portProvider);
        this.policyService = new PolicyServiceImpl(session, portProvider);
        this.aclService = new AclServiceImpl(session, portProvider);
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public ObjectService getObjectService() {
        return this.objectService;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public PolicyService getPolicyService() {
        return this.policyService;
    }

    public AclService getAclService() {
        return this.aclService;
    }

    public void clearAllCaches() {
    }

    public void clearRepositoryCache(String repositoryId) {
    }

    public void close() {
    }
}

