/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.io.IOException;
import javax.net.ssl.SSLEngineResult;
import org.restlet.Server;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpServerOutboundWay;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.io.IoState;
import org.restlet.ext.ssl.internal.SslConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsServerOutboundWay
extends HttpServerOutboundWay {
    public HttpsServerOutboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    public SslConnection<Server> getConnection() {
        return (SslConnection)super.getConnection();
    }

    @Override
    protected boolean hasIoInterest() {
        return super.hasIoInterest() && (!((SslConnection)this.getConnection()).isSslHandshaking() || ((SslConnection)this.getConnection()).getSslHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
    }

    @Override
    public int preProcess(int maxDrained, Object ... args) throws IOException {
        int result = 0;
        if (this.getIoState() == IoState.READY && this.getMessageState() == MessageState.IDLE) {
            this.getBuffer().beforeDrain();
            result = this.onDrain(this.getBuffer(), maxDrained, args);
        }
        return result;
    }

    @Override
    public void postProcess(int drained) throws IOException {
        ((SslConnection)this.getConnection()).handleSslResult();
    }
}

