/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.restlet.ext.ssl.DefaultSslContextFactory;
import org.restlet.ext.ssl.internal.WrapperSslServerSocketFactory;
import org.restlet.ext.ssl.internal.WrapperSslSocketFactory;

public class WrapperSslContextSpi
extends SSLContextSpi {
    private final DefaultSslContextFactory contextFactory;
    private final SSLContext wrappedContext;

    public WrapperSslContextSpi(DefaultSslContextFactory contextFactory, SSLContext wrappedContext) {
        this.contextFactory = contextFactory;
        this.wrappedContext = wrappedContext;
    }

    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine result = this.getWrappedContext().createSSLEngine();
        this.initEngine(result);
        return result;
    }

    protected SSLEngine engineCreateSSLEngine(String peerHost, int peerPort) {
        SSLEngine result = this.getWrappedContext().createSSLEngine(peerHost, peerPort);
        this.initEngine(result);
        return result;
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.getWrappedContext().getClientSessionContext();
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.getWrappedContext().getServerSessionContext();
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new WrapperSslServerSocketFactory(this.getContextFactory(), this.getWrappedContext().getServerSocketFactory());
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        return new WrapperSslSocketFactory(this.getContextFactory(), this.getWrappedContext().getSocketFactory());
    }

    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws KeyManagementException {
        this.getWrappedContext().init(km, tm, random);
    }

    protected DefaultSslContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected SSLContext getWrappedContext() {
        return this.wrappedContext;
    }

    protected void initEngine(SSLEngine sslEngine) {
        if (this.getContextFactory().isNeedClientAuthentication()) {
            sslEngine.setNeedClientAuth(true);
        } else if (this.getContextFactory().isWantClientAuthentication()) {
            sslEngine.setWantClientAuth(true);
        }
        if (this.getContextFactory().getEnabledCipherSuites() != null || this.getContextFactory().getDisabledCipherSuites() != null) {
            sslEngine.setEnabledCipherSuites(this.getContextFactory().getSelectedCipherSuites(sslEngine.getSupportedCipherSuites()));
        }
        if (this.getContextFactory().getEnabledProtocols() != null || this.getContextFactory().getDisabledProtocols() != null) {
            sslEngine.setEnabledProtocols(this.getContextFactory().getSelectedSslProtocols(sslEngine.getSupportedProtocols()));
        }
    }
}

