/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.command.OwProcessableObjectStrategy;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.OwCommandCheckout;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;

public class OwDocumentFunctionCheckout
extends OwDocumentFunction {
    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdms/checkout.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdms/checkout_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        if (oObject_p.hasVersionSeries()) {
            return oObject_p.getVersion().canCheckout(iContext_p);
        }
        return false;
    }

    public void onClickEvent(final OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwProcessableObjectStrategy processableObjectStrategy = new OwProcessableObjectStrategy(){

            public boolean canBeProcessed(OwObject object_p) throws Exception {
                if (!OwDocumentFunctionCheckout.this.isObjectTypeSupported(oObject_p.getType()) || !OwDocumentFunctionCheckout.this.isObjectClassSupported(oObject_p.getObjectClass().getClassName())) {
                    throw new OwInvalidOperationException(OwDocumentFunctionCheckout.this.getContext().localize("plug.owdms.OwDocumentFunctionCheckout.msgDisabled", "Checkout cannot be executed for the selected object."));
                }
                if (!object_p.hasVersionSeries()) {
                    throw new OwInvalidOperationException(OwDocumentFunctionCheckout.this.getContext().localize("plug.owdms.OwDocumentFunctionCheckout.invalidobject", "Cannot check out the document. The document has no version series."));
                }
                boolean isMyCheckedOut = false;
                try {
                    isMyCheckedOut = object_p.getVersion().isMyCheckedOut(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (isMyCheckedOut) {
                    throw new OwInvalidOperationException(OwDocumentFunctionCheckout.this.getContext().localize("plug.owdms.OwDocumentFunctionCheckout.documentCheckedOutbyYou", "Cannot check out the document. The document is already checked out by you."));
                }
                if (!object_p.getVersion().canCheckout(2)) {
                    String checkedoutBy = null;
                    try {
                        checkedoutBy = object_p.getVersion().getCheckedOutUserID(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (checkedoutBy != null && !checkedoutBy.equals("")) {
                        checkedoutBy = OwDocumentFunctionCheckout.this.getDisplayNameFromUserId(checkedoutBy);
                        throw new OwInvalidOperationException(OwDocumentFunctionCheckout.this.getContext().localize1("plug.owdms.OwDocumentFunctionCheckout.documentCheckedOutbyOtherUser", "Cannot check out the document. The document is already checked out by user (%1).", checkedoutBy));
                    }
                    throw new OwInvalidOperationException(OwDocumentFunctionCheckout.this.getContext().localize("plug.owdms.OwDocumentFunctionCheckout.documentCheckedOutNotPossible", "Cannot check out the document. Probably the document is already checked out or you do not have the necessary authorization to perform this action."));
                }
                return true;
            }
        };
        OwCommandCheckout commandCheckout = new OwCommandCheckout(oObject_p, this.getContext(), processableObjectStrategy);
        this.executeCheckoutCommand(oParent_p, refreshCtx_p, commandCheckout);
        OwObject latest = oObject_p;
        if (latest.hasVersionSeries()) {
            latest = latest.getVersionSeries().getObject(oObject_p.getVersionSeries().getLatest());
        }
        if (latest.hasContent(2)) {
            OwXMLUtil node = OwMimeManager.getMimeNode((OwConfiguration)this.m_MainContext.getConfiguration(), (OwObjectReference)latest);
            StringBuffer buff = new StringBuffer();
            if (node.getSubNode("editservlet") != null) {
                OwMimeManager.OwOpenCommand cmd = OwMimeManager.editObject((OwMainAppContext)this.m_MainContext, (OwObjectReference)latest);
                if (cmd.canGetScript()) {
                    buff.append(cmd.getScript(cmd.getViewerMode(), null, false));
                } else {
                    buff.append(cmd.getURL());
                }
            } else {
                buff.append("navigateServiceFrameTO(\"");
                buff.append(OwMimeManager.getSaveDownloadURL((OwMainAppContext)this.m_MainContext, (OwObjectReference)latest));
                buff.append("\");");
            }
            this.m_MainContext.addFinalScript(buff.toString());
        }
    }

    public void onMultiselectClickEvent(Collection objects_p, final OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwProcessableObjectStrategy processableObjectStrategy = new OwProcessableObjectStrategy(){

            public boolean canBeProcessed(OwObject object_p) throws Exception {
                return OwDocumentFunctionCheckout.this.isEnabled(object_p, oParent_p, 2);
            }
        };
        OwCommandCheckout commandCheckout = new OwCommandCheckout(objects_p, this.getContext(), processableObjectStrategy);
        this.executeCheckoutCommand(oParent_p, refreshCtx_p, commandCheckout);
    }

    private void executeCheckoutCommand(OwObject oParent_p, OwClientRefreshContext refreshCtx_p, OwCommandCheckout commandCheckout_p) throws Exception {
        commandCheckout_p.execute();
        if (commandCheckout_p.hasProcessedObjects()) {
            this.addHistoryEvent(commandCheckout_p.getProcessedObjects(), oParent_p, 1, 1);
        }
        if (commandCheckout_p.hasDisabledObjects()) {
            this.addHistoryEvent(commandCheckout_p.getDisabledObjects(), oParent_p, 1, 5);
        }
        if (commandCheckout_p.hasErrors()) {
            this.addHistoryEvent(commandCheckout_p.getAllErrorObjects(), oParent_p, 1, 2);
            throw new Exception(commandCheckout_p.getAllErrorMessages());
        }
        if (null != refreshCtx_p) {
            refreshCtx_p.onClientRefreshContextUpdate(1, null);
        }
    }
}

