/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.sslcontext;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jsslutils.sslcontext.ReloadableX509CRL;
import org.jsslutils.sslcontext.SSLContextFactory;
import org.jsslutils.sslcontext.X509SSLContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXSSLContextFactory
extends X509SSLContextFactory {
    public static final String CRL_RELOAD_INTERVAL_PROP = "org.jsslutils.prop.crlReloadInterval";
    protected boolean enableRevocation;
    protected Set<CRL> crlCollection = new HashSet<CRL>();
    private CertificateFactory certificateFactory = null;
    private ScheduledThreadPoolExecutor crlReloaderScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(2);

    public PKIXSSLContextFactory() {
        this(null, (char[])null, null, true);
    }

    public PKIXSSLContextFactory(KeyStore keyStore, char[] keyPassword, KeyStore trustStore, boolean enableRevocation) {
        super(keyStore, keyPassword, trustStore);
        this.enableRevocation = enableRevocation;
    }

    public PKIXSSLContextFactory(KeyStore keyStore, String keyPassword, KeyStore trustStore, boolean enableRevocation) {
        super(keyStore, keyPassword, trustStore);
        this.enableRevocation = enableRevocation;
    }

    public PKIXSSLContextFactory(KeyStore keyStore, char[] keyPassword, KeyStore trustStore) {
        this(keyStore, keyPassword, trustStore, true);
    }

    public PKIXSSLContextFactory(KeyStore keyStore, String keyPassword, KeyStore trustStore) {
        this(keyStore, keyPassword, trustStore, true);
    }

    @Override
    protected TrustManager[] getRawTrustManagers() throws SSLContextFactory.SSLContextFactoryException {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            ManagerFactoryParameters trustParams = this.getTrustParams();
            if (trustParams != null) {
                tmf.init(trustParams);
            } else {
                tmf.init((KeyStore)null);
            }
            return tmf.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (KeyStoreException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    protected ManagerFactoryParameters getTrustParams() throws SSLContextFactory.SSLContextFactoryException {
        PKIXParameters pkixParams = this.getPKIXParameters();
        if (pkixParams != null) {
            CertPathTrustManagerParameters trustParams = new CertPathTrustManagerParameters(pkixParams);
            return trustParams;
        }
        return null;
    }

    protected PKIXParameters getPKIXParameters() throws SSLContextFactory.SSLContextFactoryException {
        KeyStore trustStore = this.getTrustStore();
        try {
            if (trustStore != null) {
                PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(this.getTrustStore(), null);
                CertStore certStore = this.getCertStore();
                if (certStore != null) {
                    pkixParams.setRevocationEnabled(this.enableRevocation);
                    pkixParams.addCertStore(this.getCertStore());
                } else {
                    pkixParams.setRevocationEnabled(Boolean.parseBoolean(System.getProperty("com.sun.security.enableCRLDP", "false")));
                }
                return pkixParams;
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    protected CertStore getCertStore() throws SSLContextFactory.SSLContextFactoryException {
        try {
            Collection<? extends CRL> crlCollection = this.getCrlCollection();
            if (crlCollection != null && crlCollection.size() > 0) {
                CollectionCertStoreParameters collecCertStoreParams = new CollectionCertStoreParameters(crlCollection);
                return CertStore.getInstance("Collection", collecCertStoreParams);
            }
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    public Collection<? extends CRL> getCrlCollection() throws SSLContextFactory.SSLContextFactoryException {
        return Collections.unmodifiableCollection(this.crlCollection);
    }

    public void addCrlCollection(Collection<? extends CRL> crlCollection) throws SSLContextFactory.SSLContextFactoryException {
        this.crlCollection.addAll(crlCollection);
    }

    public void addCrl(CRL crl) throws SSLContextFactory.SSLContextFactoryException {
        this.crlCollection.add(crl);
    }

    public void addCrl(InputStream crlInputStream) throws SSLContextFactory.SSLContextFactoryException {
        this.crlCollection.add(this.loadCrl(crlInputStream));
    }

    public void addCrl(String crlUrl) throws SSLContextFactory.SSLContextFactoryException, MalformedURLException, IOException {
        long reloadInterval = 0L;
        try {
            reloadInterval = Long.valueOf(System.getProperty(CRL_RELOAD_INTERVAL_PROP, "0"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.addCrl(crlUrl, reloadInterval);
    }

    public void addCrl(String crlUrl, long reloadInterval) throws SSLContextFactory.SSLContextFactoryException, MalformedURLException, IOException {
        if (reloadInterval > 0L) {
            Callable<X509CRL> reloader = this.addReloadableCrl(crlUrl);
            this.crlReloaderScheduledThreadPoolExecutor.schedule(reloader, reloadInterval, TimeUnit.SECONDS);
        } else {
            this.crlCollection.add(this.loadCrl(crlUrl));
        }
    }

    public Callable<X509CRL> addReloadableCrl(String crlUrl) throws SSLContextFactory.SSLContextFactoryException, MalformedURLException, IOException {
        ReloadableX509CRL crl = new ReloadableX509CRL(crlUrl);
        Callable<X509CRL> reloader = crl.getReloaderCallable();
        try {
            reloader.call();
        }
        catch (Exception e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        this.crlCollection.add(crl);
        return reloader;
    }

    public synchronized CRL loadCrl(InputStream crlInputStream) throws SSLContextFactory.SSLContextFactoryException {
        try {
            if (this.certificateFactory == null) {
                this.certificateFactory = CertificateFactory.getInstance("X.509");
            }
            X509CRL crl = (X509CRL)this.certificateFactory.generateCRL(crlInputStream);
            return crl;
        }
        catch (CertificateException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
        catch (CRLException e) {
            throw new SSLContextFactory.SSLContextFactoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRL loadCrl(String crlUrl) throws SSLContextFactory.SSLContextFactoryException, IOException, MalformedURLException {
        InputStream is = null;
        try {
            URL url = new URL(crlUrl);
            is = url.openStream();
            CRL cRL = this.loadCrl(new BufferedInputStream(is));
            return cRL;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

