/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis;

import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.app.id.viid.OwVIId;
import com.wewebu.ow.server.app.id.viid.OwVIIdType;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableObjectCollectionConverter;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwManagedSemiVirtualRecordConfiguration;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISConversionParameters;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativePropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositoryResource;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositoryResourceInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISResourceInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSemiVirtualFolderObject;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSession;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimpleDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimpleObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSimplePropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISQueryIterable;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISQueryResultConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISQualifiedName;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.role.OwRoleOptionAttributeBag;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.api.TransientFolder;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.perf4j.log4j.Log4JStopWatch;

public class OwCMISRepositorySession
implements OwCMISNativeSession {
    private static Logger LOG;
    private Session session;
    private OwCMISDMSIDDecoder dmsidDecoder;
    private OwCMISRepositoryResource resource;
    private Map<String, ?> parameters;
    private OwCMISObjectClassFactory objectClassFactory;
    private OwCMISNativePropertyClassFactory propertyClassFactory;
    private TimeZone timeZone;
    private OwRoleOptionAttributeBag m_roleoptionIDs = new OwRoleOptionAttributeBag();
    private OwCMISNetwork network;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;

    static {
        OwCMISRepositorySession.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISRepositorySession.class);
    }

    public OwCMISRepositorySession(OwCMISRepositoryResource resource_p, Map<String, ?> parameters_p, OwCMISNetwork network) throws OwException {
        this(resource_p.getRepository().createSession(), resource_p, parameters_p, network);
    }

    public OwCMISRepositorySession(Session session_p, OwCMISRepositoryResource resource_p, Map<String, ?> parameters_p, OwCMISNetwork network) throws OwException {
        this.parameters = parameters_p;
        this.network = network;
        this.session = session_p;
        this.resource = resource_p;
        this.dmsidDecoder = this.createSessionProduct(OwCMISDMSIDDecoder.class, "com.wewebu.owd.dmsiddecoder.classname", OwCMISSimpleDMSIDDecoder.class);
        this.propertyClassFactory = this.createSessionProduct(OwCMISNativePropertyClassFactory.class, "com.wewebu.owd.propertyclassfactory.classname", OwCMISSimplePropertyClassFactory.class);
        this.objectClassFactory = this.createSessionProduct(OwCMISObjectClassFactory.class, "com.wewebu.owd.objectclassfactory.classname", OwCMISSimpleObjectClassFactory.class);
        String timeZoneId = (String)this.parameters.get("com.wewebu.owd.timezone.id");
        this.timeZone = timeZoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneId);
    }

    private <P> P createSessionProduct(Class<P> class_p, String classParameter_p, Class<? extends P> defaultClass_p) throws OwException {
        Class<P> clazz = class_p;
        String string = classParameter_p;
        Class<? extends P> clazz2 = defaultClass_p;
        try {
            Object object;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Class<Object> factoryClass;
                String classname = (String)this.parameters.get(classParameter_p);
                if (classname == null) {
                    factoryClass = defaultClass_p;
                } else {
                    factoryClass = Class.forName(classname);
                    if (!class_p.isAssignableFrom(factoryClass)) {
                        throw new OwInvalidOperationException("Invalid property class factory java class : " + factoryClass + ". A " + class_p.getName() + " based class expected.");
                    }
                }
                try {
                    Object product;
                    Constructor<Object> constructor = factoryClass.getConstructor(OwCMISNativeSession.class);
                    object = product = constructor.newInstance(this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Object product;
                        Constructor<Object> constructor = factoryClass.getConstructor(OwCMISSession.class);
                        object = product = constructor.newInstance(this);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            Object product;
                            Constructor<Object> constructor = factoryClass.getConstructor(new Class[0]);
                            object = product = constructor.newInstance(new Object[0]);
                        }
                        catch (OwException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new OwInvalidOperationException("Unable to create object factory: " + e, (Throwable)e);
                        }
                    }
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return (P)object;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{clazz, string, clazz2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISResourceInfo getResourceInfo() {
        return new OwCMISRepositoryResourceInfo(this.session.getRepositoryInfo());
    }

    @Override
    public OwCMISObject getObject(String dmsId_p, boolean refresh_p) throws OwException {
        String string = dmsId_p;
        boolean bl = refresh_p;
        try {
            OwCMISNativeObject<TransientCmisObject> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Session natSes = this.getOpenCMISSession();
                OwCMISDMSID dmsid = this.getDMSIDDecoder().createDMSID(dmsId_p);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Retrival of object by Id = " + dmsid.getCMISID()));
                }
                OperationContext opCtx = natSes.createOperationContext(null, false, true, false, IncludeRelationships.NONE, null, false, null, !refresh_p, 1);
                CmisObject object = natSes.getObject(dmsid.getCMISID(), opCtx);
                owCMISNativeObject = this.from(object.getTransientObject(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISObject getObjectByPath(String path, boolean refresh) throws OwException {
        String string = path;
        boolean bl = refresh;
        try {
            OwCMISNativeObject<TransientCmisObject> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OperationContext opCtx = this.getOpenCMISSession().createOperationContext(this.getDefaultFilter(), false, true, false, IncludeRelationships.NONE, null, false, null, !refresh, 1);
                CmisObject cmisNativeObject = this.session.getObjectByPath(path, opCtx);
                owCMISNativeObject = this.from(cmisNativeObject.getTransientObject(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    public OwCMISNativeObjectClass<ObjectType, TransientCmisObject> getNativeObjectClass(String objectClassName_p) throws OwException {
        String string = objectClassName_p;
        try {
            OwCMISNativeObjectClass<ObjectType, TransientCmisObject> owCMISNativeObjectClass;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                ObjectType typeDefinition = this.objectClassFactory.retrieveObjectType(objectClassName_p, this.getOpenCMISSession());
                owCMISNativeObjectClass = this.from(typeDefinition);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObjectClass;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISNativeObject<TransientCmisObject> getNativeObject(String objectNativeId, Collection<String> propertyNames, Map<String, ?> conversionParameters) throws OwException {
        String string = objectNativeId;
        Collection<String> collection = propertyNames;
        Map<String, ?> map = conversionParameters;
        try {
            OwCMISNativeObject<TransientCmisObject> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OperationContext opCtx = this.session.createOperationContext();
                if (propertyNames != null) {
                    HashSet<String> propertyfilter = new HashSet<String>(propertyNames);
                    propertyfilter.addAll(this.getDefaultFilter());
                    opCtx.setFilter(propertyfilter);
                }
                CmisObject cmisNativeObject = this.session.getObject(objectNativeId, opCtx);
                TransientCmisObject transientCmisObject = cmisNativeObject.getTransientObject();
                owCMISNativeObject = this.from(transientCmisObject, conversionParameters);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, collection, map};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISNativeObjectClass<ObjectType, TransientCmisObject> getObjectClass(String objectClassName_p) throws OwException {
        String string = objectClassName_p;
        try {
            OwCMISNativeObjectClass<ObjectType, TransientCmisObject> owCMISNativeObjectClass;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISNativeObjectClass = this.getNativeObjectClass(objectClassName_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObjectClass;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public String createObject(boolean promote_p, Object mode_p, String objectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwCMISObject parent_p, String mimeType_p, String mimeParameter_p, boolean keepCheckedOut_p) throws OwException {
        boolean bl = promote_p;
        Object object = mode_p;
        String string = objectClassName_p;
        OwPropertyCollection owPropertyCollection = properties_p;
        OwPermissionCollection owPermissionCollection = permissions_p;
        OwContentCollection owContentCollection = content_p;
        OwCMISObject owCMISObject = parent_p;
        String string2 = mimeType_p;
        String string3 = mimeParameter_p;
        boolean bl2 = keepCheckedOut_p;
        try {
            String string4;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String dmsId;
                OwCMISObjectClass clazz = this.getObjectClass(objectClassName_p);
                String nativeId = clazz.createNewObject(promote_p, mode_p, properties_p, permissions_p, content_p, parent_p, mimeType_p, mimeParameter_p, keepCheckedOut_p);
                string4 = dmsId = OwCMISSimpleDMSID.createDMSID(this.getDMSIDDecoder().getDMSIDPrefix(), this.resource.getID(), nativeId);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string4;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl), object, string, owPropertyCollection, owPermissionCollection, owContentCollection, owCMISObject, string2, string3, Conversions.booleanObject((boolean)bl2)};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISNativePropertyClassFactory getNativePropertyClassFactory() {
        return this.propertyClassFactory;
    }

    public Object getParameterValue(String name_p) {
        return this.parameters.get(name_p);
    }

    @Override
    public Locale getLocale() {
        return this.session.getLocale();
    }

    @Override
    public OwCMISDMSIDDecoder getDMSIDDecoder() {
        return this.dmsidDecoder;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public OwCMISQueryIterable query(OwQueryStatement statement, OwLoadContext loadContext) throws OwException {
        OwQueryStatement owQueryStatement = statement;
        OwLoadContext owLoadContext = loadContext;
        try {
            OwCMISQueryIterable owCMISQueryIterable;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                LOG.debug((Object)("session-query-iterable: " + statement));
                owCMISQueryIterable = new OwCMISQueryIterable(this, statement, loadContext);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISQueryIterable;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)owQueryStatement, (Object)owLoadContext));
            }
            throw cmisBaseException;
        }
    }

    private OwCMISQueryIterable query(OwQueryStatement statement, OwLoadContext loadContext, final boolean includeAllowableActions, final IncludeRelationships includeRelationships, final String renditionFilter) throws OwException {
        OwQueryStatement owQueryStatement = statement;
        OwLoadContext owLoadContext = loadContext;
        boolean bl = includeAllowableActions;
        IncludeRelationships includeRelationships2 = includeRelationships;
        String string = renditionFilter;
        try {
            OwCMISQueryIterable owCMISQueryIterable;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                LOG.debug((Object)("legacy-session-query-iterable: " + statement));
                owCMISQueryIterable = new OwCMISQueryIterable(this, statement, loadContext){

                    @Override
                    protected OperationContext toOperationContext(OwLoadContext context) {
                        OperationContext operationContext = super.toOperationContext(context);
                        operationContext.setIncludeRelationships(includeRelationships);
                        operationContext.setIncludeAllowableActions(includeAllowableActions);
                        operationContext.setRenditionFilterString(renditionFilter);
                        return operationContext;
                    }
                };
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISQueryIterable;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{owQueryStatement, owLoadContext, Conversions.booleanObject((boolean)bl), includeRelationships2, string};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwObjectCollection query(OwQueryStatement statement, boolean searchAllVersions, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) throws OwException {
        OwQueryStatement owQueryStatement = statement;
        boolean bl = searchAllVersions;
        boolean bl2 = includeAllowableActions;
        IncludeRelationships includeRelationships2 = includeRelationships;
        String string = renditionFilter;
        BigInteger bigInteger = maxItems;
        BigInteger bigInteger2 = skipCount;
        try {
            OwIterableObjectCollectionConverter owIterableObjectCollectionConverter;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Log4JStopWatch stopWatch = new Log4JStopWatch();
                OwLoadContext loadContext = new OwLoadContext();
                loadContext.setPageSize(maxItems.intValue());
                loadContext.setVersionSelection(searchAllVersions ? 3 : 1);
                OwCMISQueryIterable iterable = this.query(statement, loadContext, includeAllowableActions, includeRelationships, renditionFilter);
                stopWatch.lap("OwCMISRepositorySession.legacy-query", "query");
                OwIterableObjectCollectionConverter objectCollection = new OwIterableObjectCollectionConverter((OwIterable)iterable, skipCount.longValue(), maxItems.intValue());
                stopWatch.stop("OwCMISRepositorySession.legacy-query", "createOwObjects");
                owIterableObjectCollectionConverter = objectCollection;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owIterableObjectCollectionConverter;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{owQueryStatement, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2), includeRelationships2, string, bigInteger, bigInteger2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    public OwCMISObject createCMISObject(OwQueryStatement statement, QueryResult queryResult, OperationContext operationContext) throws OwException {
        OwQueryStatement owQueryStatement = statement;
        QueryResult queryResult2 = queryResult;
        OperationContext operationContext2 = operationContext;
        try {
            OwCMISNativeObject<TransientCmisObject> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                HashMap<String, OperationContext> localConversionParameters = new HashMap<String, OperationContext>();
                localConversionParameters.put("cmis.object.creation.context", operationContext);
                Map<String, ?> conversionParameters = this.defaultConversionParameters(localConversionParameters);
                PropertyData mainTypeId = queryResult.getPropertyById("cmis:objectTypeId");
                OwCMISNativeObjectClass<ObjectType, TransientCmisObject> mainObjectClass = this.getNativeObjectClass((String)mainTypeId.getFirstValue());
                OwCMISQueryResultConverter<TransientCmisObject> converter = mainObjectClass.getQueryResultConverter(queryResult, statement, operationContext);
                TransientCmisObject cmisObject = converter.toCmisObject(queryResult, statement, operationContext);
                OwCMISNativeObjectClass<?, TransientCmisObject> queryResultClass = this.objectClassFactory.createObjectClassOf(cmisObject);
                OwCMISNativeObject<TransientCmisObject> object = queryResultClass.from(cmisObject, conversionParameters);
                owCMISNativeObject = this.checkObject(object, null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{owQueryStatement, queryResult2, operationContext2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    protected Map<String, ?> defaultConversionParameters(Map<String, ?> conversionParameters) {
        HashMap conversionParametersCopy = new HashMap(conversionParameters = conversionParameters == null ? OwCMISConversionParameters.NO_PARAMETERS : conversionParameters);
        if (!conversionParametersCopy.containsKey("cmis.document.preserve.version")) {
            conversionParametersCopy.put("cmis.document.preserve.version", this.getNetwork().getNetworkConfiguration().isPreservedVersion());
        }
        if (!conversionParametersCopy.containsKey("cmis.object.creation.context")) {
            conversionParametersCopy.put("cmis.object.creation.context", this.getDefaultOperationContext());
        }
        return conversionParametersCopy;
    }

    @Override
    public <O extends TransientCmisObject> OwCMISNativeObject<O> from(O cmisObject, Map<String, ?> conversionParameters) throws OwException {
        O o = cmisObject;
        Map<String, ?> map = conversionParameters;
        try {
            OwCMISNativeObject<O> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISNativeObjectClass<?, O> objClass = this.classOf(cmisObject);
                Map<String, ?> conversionParametersCopy = this.defaultConversionParameters(conversionParameters);
                owCMISNativeObject = this.checkObject(objClass.from(cmisObject, conversionParametersCopy), conversionParametersCopy);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, o, map));
            }
            throw cmisBaseException;
        }
    }

    protected <O extends TransientCmisObject> OwCMISNativeObject<O> checkObject(OwCMISNativeObject<O> wrapedObj, Map<String, ?> conversionParameters) throws OwException {
        OwCMISNativeObject<O> owCMISNativeObject = wrapedObj;
        Map<String, ?> map = conversionParameters;
        try {
            OwCMISNativeObject<O> owCMISNativeObject2;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwManagedSemiVirtualRecordConfiguration semiVfHandler = this.getNetwork().getNetworkConfiguration().getSemiVirtualConfiguration();
                OwCMISNetwork myNetwork = this.getNetwork();
                OwSemiVirtualRecordClass semiDef = semiVfHandler.semiVirtualFolderForObjectClass(wrapedObj.getObjectClass().getClassName(), myNetwork.getRoleManager(), myNetwork.getNetworkConfiguration().getConfigNode());
                owCMISNativeObject2 = semiDef != null ? new OwCMISSemiVirtualFolderObject<O>(wrapedObj, semiDef, this.getNetwork()) : wrapedObj;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, owCMISNativeObject, map));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISObject getRootFolder() throws OwException {
        try {
            OwCMISNativeObject<TransientFolder> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Folder root = this.session.getRootFolder();
                owCMISNativeObject = this.from(root.getTransientFolder(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public <T extends ObjectType> OwCMISNativeObjectClass<T, ?> from(T type_p) throws OwException {
        T t = type_p;
        try {
            OwCMISNativeObjectClass<T, ?> owCMISNativeObjectClass;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISNativeObjectClass = this.objectClassFactory.createObjectClass(type_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObjectClass;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, t));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public <O extends TransientCmisObject> OwCMISNativeObjectClass<?, O> classOf(O object_p) throws OwException {
        O o = object_p;
        try {
            OwCMISNativeObjectClass<?, O> owCMISNativeObjectClass;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISNativeObjectClass = this.objectClassFactory.createObjectClassOf(object_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObjectClass;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, o));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public Session getOpenCMISSession() {
        return this.session;
    }

    @Override
    public OwCMISResource getResource() {
        return this.resource;
    }

    protected OwCMISNativeObjectClass<?, ?>[] createDefaultClassContext() throws OwException {
        try {
            OwCMISNativeObjectClass[] owCMISNativeObjectClassArray;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISNativeObjectClass<ObjectType, TransientCmisObject> document = this.getNativeObjectClass(BaseTypeId.CMIS_DOCUMENT.value());
                OwCMISNativeObjectClass<ObjectType, TransientCmisObject> folder = this.getNativeObjectClass(BaseTypeId.CMIS_FOLDER.value());
                OwCMISNativeObjectClass<ObjectType, TransientCmisObject> policy = this.getNativeObjectClass(BaseTypeId.CMIS_POLICY.value());
                OwCMISNativeObjectClass<ObjectType, TransientCmisObject> relationship = this.getNativeObjectClass(BaseTypeId.CMIS_RELATIONSHIP.value());
                owCMISNativeObjectClassArray = new OwCMISNativeObjectClass[]{document, folder, policy, relationship};
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObjectClassArray;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    protected OperationContext getDefaultOperationContext() {
        Set<String> filter = this.getDefaultFilter();
        OperationContext operationContext = this.session.getDefaultContext();
        if (operationContext == null) {
            operationContext = this.session.createOperationContext();
        }
        if (operationContext.getFilter() != null) {
            filter.addAll(operationContext.getFilter());
        }
        operationContext.setFilter(filter);
        return operationContext;
    }

    protected Set<String> getDefaultFilter() {
        HashSet<String> filter = new HashSet<String>();
        filter.add("cmis:objectId");
        filter.add("cmis:objectTypeId");
        filter.add("cmis:baseTypeId");
        filter.add("cmis:name");
        filter.add("cmis:changeToken");
        filter.add("cmis:creationDate");
        filter.add("cmis:lastModificationDate");
        filter.add("cmis:lastModifiedBy");
        filter.add("cmis:versionSeriesId");
        filter.add("cmis:isLatestMajorVersion");
        filter.add("cmis:isLatestVersion");
        filter.add("cmis:isMajorVersion");
        filter.add("cmis:isVersionSeriesCheckedOut");
        filter.add("cmis:versionSeriesCheckedOutBy");
        filter.add("cmis:versionLabel");
        filter.add("cmis:contentStreamLength");
        filter.add("cmis:contentStreamFileName");
        filter.add("cmis:contentStreamId");
        filter.add("cmis:contentStreamMimeType");
        filter.add("cmis:isImmutable");
        return filter;
    }

    @Override
    public OperationContext createOperationContext(Collection<String> filterPropertyNames_p, int maxItemsPerPage_p, OwCMISNativeObjectClass<?, ?> ... classContext_p) {
        return this.createOperationContext(filterPropertyNames_p, null, maxItemsPerPage_p, classContext_p);
    }

    @Override
    public OperationContext createOperationContext(Collection<String> filterPropertyNames_p, OwSort sorting_p, int maxItemsPerPage_p, OwCMISNativeObjectClass<?, ?> ... classContext_p) {
        Set<String> filter = this.getDefaultFilter();
        if (classContext_p == null) {
            try {
                classContext_p = this.createDefaultClassContext();
            }
            catch (OwException e) {
                e.printStackTrace();
            }
        }
        if (filterPropertyNames_p != null && classContext_p != null) {
            for (String propertyName : filterPropertyNames_p) {
                OwCMISPropertyClass<?> propertyClass = this.findPropertyDefinition(propertyName, classContext_p);
                if (propertyClass == null || propertyClass.getQueryName() == null) {
                    LOG.debug((Object)("Missing property class required for operation context : " + propertyName));
                    continue;
                }
                String queryName = propertyClass.getQueryName();
                filter.add(queryName);
            }
        }
        boolean includeAcls = true;
        boolean includeAllowableActions = true;
        boolean includePolicies = true;
        IncludeRelationships includeRelationships = IncludeRelationships.NONE;
        Set renditionFilter = null;
        boolean includePathSegments = true;
        String orderBy = this.getSortString(sorting_p, classContext_p);
        boolean cacheEnabled = true;
        int maxItemsPerPage = maxItemsPerPage_p;
        return this.session.createOperationContext(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    @Override
    public Set<OwCMISObjectClass> getObjectClasses(int[] iTypes_p, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p) throws OwException {
        int[] nArray = iTypes_p;
        boolean bl = fExcludeHiddenAndNonInstantiable_p;
        boolean bl2 = fRootOnly_p;
        try {
            HashSet<OwCMISObjectClass> hashSet;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                HashSet<OwCMISObjectClass> classes = new HashSet<OwCMISObjectClass>();
                int[] types = iTypes_p;
                if (types == null) {
                    types = new int[]{4097, 8193, 12291};
                }
                int[] nArray2 = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    int type = nArray2[n2];
                    switch (type) {
                        case 4097: {
                            OwCMISObjectClass objClass = this.getObjectClass(ObjectType.DOCUMENT_BASETYPE_ID);
                            classes.addAll(this.classesfromRootClass(objClass, fExcludeHiddenAndNonInstantiable_p, fRootOnly_p));
                            break;
                        }
                        case 8193: {
                            OwCMISObjectClass objClass = this.getObjectClass(ObjectType.FOLDER_BASETYPE_ID);
                            classes.addAll(this.classesfromRootClass(objClass, fExcludeHiddenAndNonInstantiable_p, fRootOnly_p));
                            break;
                        }
                        case 12291: {
                            OwCMISObjectClass objClass;
                            try {
                                objClass = this.getObjectClass(ObjectType.RELATIONSHIP_BASETYPE_ID);
                                classes.addAll(this.classesfromRootClass(objClass, fExcludeHiddenAndNonInstantiable_p, fRootOnly_p));
                                break;
                            }
                            catch (OwException ex) {
                                if (!LOG.isDebugEnabled()) break;
                                LOG.debug((Object)"Could not retrieve relationship, maybe not supported", (Throwable)ex);
                            }
                        }
                    }
                    ++n2;
                }
                hashSet = classes;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return hashSet;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{nArray, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    private Collection<? extends OwCMISObjectClass> classesfromRootClass(OwCMISObjectClass objClass, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p) throws OwException {
        OwCMISObjectClass owCMISObjectClass = objClass;
        boolean bl = fExcludeHiddenAndNonInstantiable_p;
        boolean bl2 = fRootOnly_p;
        try {
            HashSet<? extends OwCMISObjectClass> hashSet;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                HashSet<? extends OwCMISObjectClass> result = new HashSet<OwCMISObjectClass>();
                result.add(objClass);
                if (!fRootOnly_p) {
                    List<OwCMISObjectClass> children = objClass.getChilds(null, fExcludeHiddenAndNonInstantiable_p);
                    for (OwCMISObjectClass owCMISObjectClass2 : children) {
                        result.addAll(this.classesfromRootClass(owCMISObjectClass2, fExcludeHiddenAndNonInstantiable_p, fRootOnly_p));
                    }
                }
                hashSet = result;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return hashSet;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{owCMISObjectClass, Conversions.booleanObject((boolean)bl), Conversions.booleanObject((boolean)bl2)};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectclass_p, OwNetwork network) throws OwException {
        OwObjectClass owObjectClass = objectclass_p;
        OwNetwork owNetwork = network;
        try {
            OwObjectSkeleton owObjectSkeleton;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    OwCMISObjectClass clazz = objectclass_p instanceof OwCMISObjectClass ? (OwCMISObjectClass)objectclass_p : this.getObjectClass(objectclass_p.getClassName());
                    OwXMLUtil initValues = this.getNetwork().getNetworkConfiguration().getCreationInitialValuesConfig(clazz.getClassName());
                    OwObjectSkeleton skeleton = clazz.createSkeletonObject(network, this.resource, this, initValues);
                    String className = clazz.getPropertyClass("cmis:objectTypeId").getFullQualifiedName().toString();
                    skeleton.setField(className, (Object)objectclass_p.getClassName());
                    owObjectSkeleton = skeleton;
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception ex) {
                    LOG.error((Object)"OwCMISRepositorySession.createObjectSkeleton(): Problem instantiation of Skeleton object!", (Throwable)ex);
                    throw new OwServerException(new OwString("opencmis.OwCMISRepositorySession.err.skeleton.object", "An error occurred while creating object!"), (Throwable)ex);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owObjectSkeleton;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)owObjectClass, (Object)owNetwork));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISNetwork getNetwork() {
        return this.network;
    }

    @Override
    public OwCMISObject getObject(OwVIId viid) throws OwException {
        OwVIId owVIId = viid;
        try {
            OwCMISNativeObject<TransientCmisObject> owCMISNativeObject;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                CmisObject nativeObject;
                Session natSes = this.getOpenCMISSession();
                OperationContext opCtx = natSes.createOperationContext(null, false, true, false, IncludeRelationships.NONE, null, false, null, false, 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Retrieval object by VIID = " + viid.getViidAsString()));
                }
                String objId = OwObjectIDCodeUtil.decode((String)viid.getObjectId());
                if (OwVIIdType.DOCUMENT.equals((Object)viid.getType())) {
                    ObjectData data = natSes.getBinding().getVersioningService().getObjectOfLatestVersion(viid.getResourceId(), objId, objId, null, null, Boolean.TRUE, IncludeRelationships.NONE, "", Boolean.FALSE, Boolean.FALSE, null);
                    nativeObject = natSes.getObjectFactory().convertObject(data, opCtx);
                } else {
                    nativeObject = natSes.getObject(objId, opCtx);
                }
                owCMISNativeObject = this.from(nativeObject.getTransientObject(), null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativeObject;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)owVIId));
            }
            throw cmisBaseException;
        }
    }

    protected String getSortString(OwSort sortingOrder_p, OwCMISNativeObjectClass<?, ?> ... classContext_p) {
        boolean supportOrderBy = true;
        if (supportOrderBy && sortingOrder_p != null && !sortingOrder_p.getCriteriaCollection().isEmpty()) {
            StringBuilder sortStatements = new StringBuilder();
            Iterator itSortCrit = sortingOrder_p.getPrioritizedIterator();
            while (itSortCrit.hasNext()) {
                OwSort.OwSortCriteria crit = (OwSort.OwSortCriteria)itSortCrit.next();
                OwCMISPropertyClass<?> prop = this.findPropertyDefinition(crit.getPropertyName(), classContext_p);
                if (prop != null) {
                    if (prop.isOrderable()) {
                        StringBuilder sortOrder = new StringBuilder(prop.getQueryName());
                        sortOrder.append(" ");
                        sortOrder.append(crit.getAscFlag() ? "ASC" : "DESC");
                        if (sortStatements.length() > 0) {
                            sortStatements.append(",");
                        }
                        sortStatements.append((CharSequence)sortOrder);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("OwCMISRepositorySession.getSortString(OwSort): The property " + crit.getPropertyName() + " cannot be used for sorting."));
                    continue;
                }
                LOG.warn((Object)("OwCMISRepositorySession.getSortString(OwSort): The property definition = " + crit.getPropertyName() + " cannot be found."));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("OwCMISRepositorySession.getSortString: Sorting will be: " + sortStatements.toString()));
            }
            return sortStatements.length() > 0 ? sortStatements.toString() : null;
        }
        return null;
    }

    protected OwCMISPropertyClass<?> findPropertyDefinition(String propertyName_p, OwCMISNativeObjectClass<?, ?> ... classContext_p) {
        OwCMISQualifiedName qName = new OwCMISQualifiedName(propertyName_p);
        String objectClassName = qName.getNamespace();
        OwCMISPropertyClass<?> propertyClass = null;
        if (objectClassName != null) {
            try {
                OwCMISObjectClass anObjectClass = this.getObjectClass(objectClassName);
                propertyClass = anObjectClass.getPropertyClass(propertyName_p);
            }
            catch (OwException owException) {
                LOG.debug((Object)("Missing property class required for operation context : " + propertyName_p));
            }
        } else if (OwResource.m_ObjectNamePropertyClass.getClassName().equals(propertyName_p)) {
            OwCMISNativeObjectClass<?, ?>[] owCMISNativeObjectClassArray = classContext_p;
            int n = classContext_p.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    OwCMISNativeObjectClass<?, ?> aClass = owCMISNativeObjectClassArray[n2];
                    String name = null;
                    try {
                        name = aClass.getNamePropertyName();
                        propertyClass = aClass.findPropertyClass(name);
                        if (propertyClass == null) break block11;
                        break;
                    }
                    catch (OwException owException) {}
                }
                ++n2;
            }
        } else {
            OwCMISNativeObjectClass<?, ?>[] owCMISNativeObjectClassArray = classContext_p;
            int n = classContext_p.length;
            int n3 = 0;
            while (n3 < n) {
                OwCMISNativeObjectClass<?, ?> aClass = owCMISNativeObjectClassArray[n3];
                propertyClass = aClass.findPropertyClass(propertyName_p);
                if (propertyClass == null) {
                    ++n3;
                    continue;
                }
                break;
            }
        }
        return propertyClass;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISRepositorySession.java", OwCMISRepositorySession.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createSessionProduct", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.Class:java.lang.String:java.lang.Class", "class_p:classParameter_p:defaultClass_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.Object"), 131);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.String:boolean", "dmsId_p:refresh_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject"), 194);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createCMISObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.csqlc.ast.OwQueryStatement:org.apache.chemistry.opencmis.client.api.QueryResult:org.apache.chemistry.opencmis.client.api.OperationContext", "statement:queryResult:operationContext", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject"), 375);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "from", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "org.apache.chemistry.opencmis.client.api.TransientCmisObject:java.util.Map", "cmisObject:conversionParameters", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject"), 415);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject:java.util.Map", "wrapedObj:conversionParameters", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject"), 431);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRootFolder", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject"), 447);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "from", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "org.apache.chemistry.opencmis.client.api.ObjectType", "type_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass"), 454);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "classOf", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "org.apache.chemistry.opencmis.client.api.TransientCmisObject", "object_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass"), 460);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createDefaultClassContext", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "", "", "com.wewebu.ow.server.exceptions.OwException", "[Lcom.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;"), 477);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObjectClasses", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "[I:boolean:boolean", "iTypes_p:fExcludeHiddenAndNonInstantiable_p:fRootOnly_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Set"), 592);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "classesfromRootClass", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass:boolean:boolean", "objClass:fExcludeHiddenAndNonInstantiable_p:fRootOnly_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 644);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createObjectSkeleton", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.server.ecm.OwObjectClass:com.wewebu.ow.server.ecm.OwNetwork", "objectclass_p:network", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwObjectSkeleton"), 660);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObjectByPath", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.String:boolean", "path:refresh", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject"), 211);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.server.app.id.viid.OwVIId", "viid", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject"), 697);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNativeObjectClass", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.String", "objectClassName_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass"), 220);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNativeObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.String:java.util.Collection:java.util.Map", "objectNativeId:propertyNames:conversionParameters", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject"), 228);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObjectClass", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "java.lang.String", "objectClassName_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass"), 244);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createObject", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "boolean:java.lang.Object:java.lang.String:com.wewebu.ow.server.ecm.OwPropertyCollection:com.wewebu.ow.server.ecm.OwPermissionCollection:com.wewebu.ow.server.ecm.OwContentCollection:com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject:java.lang.String:java.lang.String:boolean", "promote_p:mode_p:objectClassName_p:properties_p:permissions_p:content_p:parent_p:mimeType_p:mimeParameter_p:keepCheckedOut_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 250);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "query", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.csqlc.ast.OwQueryStatement:com.wewebu.ow.server.collections.OwLoadContext", "statement:loadContext", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISQueryIterable"), 292);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "query", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.csqlc.ast.OwQueryStatement:com.wewebu.ow.server.collections.OwLoadContext:boolean:org.apache.chemistry.opencmis.commons.enums.IncludeRelationships:java.lang.String", "statement:loadContext:includeAllowableActions:includeRelationships:renditionFilter", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISQueryIterable"), 299);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "query", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession", "com.wewebu.ow.csqlc.ast.OwQueryStatement:boolean:boolean:org.apache.chemistry.opencmis.commons.enums.IncludeRelationships:java.lang.String:java.math.BigInteger:java.math.BigInteger", "statement:searchAllVersions:includeAllowableActions:includeRelationships:renditionFilter:maxItems:skipCount", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwObjectCollection"), 317);
    }
}

