/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis;

import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISExternalEntitiesResolver;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSession;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISQualifiedName;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISSQLStandardEntitiesResolver
implements OwSQLEntitiesResolver {
    private static final Logger LOG;
    private OwCMISNetwork network;
    private OwCMISExternalEntitiesResolver externalResolver = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        OwCMISSQLStandardEntitiesResolver.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISSQLStandardEntitiesResolver.class);
    }

    public OwCMISSQLStandardEntitiesResolver(OwCMISNetwork network_p) {
        this(network_p, null);
    }

    public OwCMISSQLStandardEntitiesResolver(OwCMISNetwork network_p, OwCMISExternalEntitiesResolver externalResolver_p) {
        this.network = network_p;
        this.externalResolver = externalResolver_p;
    }

    public Set<String> resolveQueryableColumnNames(String tableName_p, String resourceID_p) throws OwException {
        String string = tableName_p;
        String string2 = resourceID_p;
        try {
            HashSet<String> hashSet;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISResource resource = this.network.getResource(resourceID_p);
                OwCMISObjectClass objectClass = this.network.getObjectClass(tableName_p, resource);
                Set<OwCMISPropertyClass<?>> queryableProperties = objectClass.getQueryablePropertyClasses();
                HashSet<String> queryName = new HashSet<String>();
                for (OwCMISPropertyClass<?> prop : queryableProperties) {
                    queryName.add(prop.getQueryName());
                }
                if (objectClass.getType() == 4097) {
                    if (!queryName.contains("cmis:isLatestVersion")) {
                        queryName.add("cmis:isLatestVersion");
                    }
                    if (!queryName.contains("cmis:isMajorVersion")) {
                        queryName.add("cmis:isMajorVersion");
                    }
                    if (!queryName.contains("cmis:isVersionSeriesCheckedOut")) {
                        queryName.add("cmis:isVersionSeriesCheckedOut");
                    }
                    if (!queryName.contains("cmis:versionSeriesId")) {
                        queryName.add("cmis:versionSeriesId");
                    }
                    if (!queryName.contains("cmis:versionSeriesCheckedOutBy")) {
                        queryName.add("cmis:versionSeriesCheckedOutBy");
                    }
                    if (!queryName.contains("cmis:versionLabel")) {
                        queryName.add("cmis:versionLabel");
                    }
                    if (!queryName.contains("cmis:contentStreamMimeType")) {
                        queryName.add("cmis:contentStreamMimeType");
                    }
                    if (!queryName.contains("cmis:contentStreamId")) {
                        queryName.add("cmis:contentStreamId");
                    }
                }
                if (!queryName.contains("cmis:objectId")) {
                    queryName.add("cmis:objectId");
                }
                if (!queryName.contains("cmis:objectTypeId")) {
                    queryName.add("cmis:objectTypeId");
                }
                if (!queryName.contains("cmis:objectTypeId")) {
                    queryName.add("cmis:baseTypeId");
                }
                hashSet = queryName;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return hashSet;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public String resolveQueryTableName(String tableName_p, String resourceID_p) throws OwException {
        String string = tableName_p;
        String string2 = resourceID_p;
        try {
            String string3;
            block10: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    OwCMISResource resource = this.network.getResource(resourceID_p);
                    if (OwResource.m_ObjectNamePropertyClass.getClassName().equals(tableName_p)) {
                        string3 = null;
                        break block10;
                    }
                    try {
                        OwCMISObjectClass objectClass = this.network.getObjectClass(tableName_p, resource);
                        if (objectClass != null && objectClass.isQueryable()) {
                            string3 = objectClass.getQueryName();
                            break block10;
                        }
                        string3 = null;
                    }
                    catch (OwException e) {
                        LOG.debug((Object)("Could not solve object class for table name " + tableName_p), (Throwable)e);
                        string3 = null;
                    }
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return string3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public boolean canOrderBy(String tableName_p, String columnName_p, String repositoryID_p) throws OwException {
        String string = tableName_p;
        String string2 = columnName_p;
        String string3 = repositoryID_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISPropertyClass<?> cmisPropertyClass = this.resolvePropertyClass(tableName_p, columnName_p, repositoryID_p);
                bl = cmisPropertyClass != null && cmisPropertyClass.isOrderable();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, string2, string3};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    public String resolveDefaultRepositoryID() throws OwException {
        try {
            String string;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISResource defaultResource = this.network.getResource(null);
                string = defaultResource.getID();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public String resolveQueryFolderId(String resourceID_p, String path_p) throws OwException {
        String string = resourceID_p;
        String string2 = path_p;
        try {
            String string3;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String path = path_p;
                if (path_p.startsWith("/" + resourceID_p)) {
                    path = path_p.substring(resourceID_p.length() + 1);
                }
                OwCMISSession session = this.network.getSession(resourceID_p);
                OwCMISObject folder = session.getObjectByPath(path, false);
                string3 = OwObjectIDCodeUtil.decode((String)folder.getID());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public String resolveRepositoryID(String repositoryName_p) throws OwException {
        String string = repositoryName_p;
        try {
            String string2;
            block11: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    Iterator<String> resources = this.network.getResourceIDs();
                    while (resources.hasNext()) {
                        String id = resources.next();
                        OwCMISResource resource = this.network.getResource(id);
                        String resourceRepositoryName = resource.getName();
                        if (!resourceRepositoryName.equals(repositoryName_p)) continue;
                        string2 = id;
                        break block11;
                    }
                    if (this.externalResolver != null) {
                        string2 = this.externalResolver.resolveRepositoryID(repositoryName_p);
                    } else {
                        String prefix = String.valueOf(this.network.getDMSPrefix()) + "/";
                        if (repositoryName_p.startsWith(prefix)) {
                            string2 = this.resolveRepositoryID(repositoryName_p.substring(prefix.length()));
                        } else {
                            LOG.warn((Object)("OwCMISSQLStandardEntitiesResolver.resolveRepositoryID(): Unknown repository, name " + repositoryName_p));
                            string2 = null;
                        }
                    }
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return string2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public boolean isInternalRepositoryID(String repositoryID_p) throws OwException {
        String string = repositoryID_p;
        try {
            boolean bl;
            block8: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    if (repositoryID_p == null) {
                        bl = false;
                        break block8;
                    }
                    Iterator<String> iResources = this.network.getResourceIDs();
                    while (iResources.hasNext()) {
                        String resource = iResources.next();
                        if (!resource.equals(repositoryID_p)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public boolean isSubtable(String parentTable_p, String childTable_p, String repositoryID_p) throws OwException {
        String string = parentTable_p;
        String string2 = childTable_p;
        String string3 = repositoryID_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISObjectClass child = this.network.getObjectClass(childTable_p, this.network.getResource(repositoryID_p));
                OwCMISObjectClass parent = this.network.getObjectClass(parentTable_p, this.network.getResource(repositoryID_p));
                bl = parent.isAssignableFrom(child);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, string2, string3};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    public boolean isVersionable(String tableName_p, String repositoryID_p) throws OwException {
        String string = tableName_p;
        String string2 = repositoryID_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = false;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    public OwNetworkContext getNetworkContext() {
        return this.network.getContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OwCMISPropertyClass<?> resolvePropertyClass(String tableName_p, String columnName_p, String repositoryID_p) throws OwException {
        String string = tableName_p;
        String string2 = columnName_p;
        String string3 = repositoryID_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISPropertyClass<?> owCMISPropertyClass;
                OwCMISSession session = this.network.getSession(repositoryID_p);
                OwCMISObjectClass tableObjectClass = session.getObjectClass(tableName_p);
                OwCMISQualifiedName qualifiedName = new OwCMISQualifiedName(columnName_p);
                OwCMISPropertyClass<?> cmisPropertyClass = tableObjectClass.findPropertyClass(qualifiedName.getName());
                if (cmisPropertyClass == null) {
                    String className = qualifiedName.getNamespace();
                    String propName = qualifiedName.getName();
                    if (className == null) {
                        owCMISPropertyClass = null;
                        return owCMISPropertyClass;
                    }
                    OwCMISObjectClass columnObjectClass = session.getObjectClass(className);
                    cmisPropertyClass = columnObjectClass.getPropertyClass(propName);
                }
                owCMISPropertyClass = cmisPropertyClass;
                return owCMISPropertyClass;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
        }
        catch (CmisBaseException cmisBaseException) {
            if (OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) throw cmisBaseException;
            Object[] objectArray = new Object[]{string, string2, string3};
            OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray));
            throw cmisBaseException;
        }
    }

    public String resovleQueryColumnName(String tableName_p, String columnName_p, String repositoryID_p) throws OwException {
        String string = tableName_p;
        String string2 = columnName_p;
        String string3 = repositoryID_p;
        try {
            String string4;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String qName;
                OwCMISPropertyClass<?> cmisPropertyClass;
                string4 = this.isInternalRepositoryID(repositoryID_p) ? ((cmisPropertyClass = this.resolvePropertyClass(tableName_p, columnName_p, repositoryID_p)) == null ? columnName_p : (cmisPropertyClass.isQueryable() ? ((qName = cmisPropertyClass.getQueryName()) == null ? cmisPropertyClass.getNonQualifiedName() : qName) : null)) : columnName_p;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string4;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, string2, string3};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISSQLStandardEntitiesResolver.java", OwCMISSQLStandardEntitiesResolver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveQueryableColumnNames", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String", "tableName_p:resourceID_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Set"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveQueryTableName", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String", "tableName_p:resourceID_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 127);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resovleQueryColumnName", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String:java.lang.String", "tableName_p:columnName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 286);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canOrderBy", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String:java.lang.String", "tableName_p:columnName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 156);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveDefaultRepositoryID", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 163);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveQueryFolderId", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String", "resourceID_p:path_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 169);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveRepositoryID", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String", "repositoryName_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 183);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isInternalRepositoryID", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String", "repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 213);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSubtable", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String:java.lang.String", "parentTable_p:childTable_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 232);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isVersionable", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String", "tableName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 239);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "resolvePropertyClass", "com.wewebu.ow.server.ecmimpl.opencmis.OwCMISSQLStandardEntitiesResolver", "java.lang.String:java.lang.String:java.lang.String", "tableName_p:columnName_p:repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass"), 260);
    }
}

