/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAbstractAuthenticator;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;
import java.util.Map;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.alfresco.wd.ext.restlet.auth.OwRestletBasicAuthenticationHandler;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISCredentialsAuthenticator
extends OwCMISAbstractAuthenticator {
    private static final Logger LOG;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        OwCMISCredentialsAuthenticator.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISCredentialsAuthenticator.class);
    }

    public OwCMISCredentialsAuthenticator(OwBaseInitializer initializer) {
        super(initializer);
    }

    public OwCMISCredentialsAuthenticator(OwCMISNetwork network) {
        super(network);
    }

    public OwAuthentication authenticate(OwAuthentication authentication_p) throws OwAuthenticationException, OwConfigurationException, OwServerException {
        String userName = authentication_p.getUserName();
        String password = authentication_p.getPassword();
        if (userName != null && password != null) {
            OwCMISCredentials credentials = null;
            try {
                SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
                Map<String, String> opencmisParameters = this.buildOpenCmisParameters(userName, password, null);
                AuthenticationProvider authProv = this.createAuthenticationProvider(opencmisParameters);
                if (authProv != null) {
                    sessionFactory.getRepositories(opencmisParameters, null, authProv, null);
                } else {
                    sessionFactory.getRepositories(opencmisParameters);
                }
                credentials = this.createCredentials(userName, password, authProv);
            }
            catch (CmisPermissionDeniedException e) {
                LOG.debug((Object)"OwCMISCredentialsAuthenticator.authenticate(): Cmis exception unallowed!", (Throwable)e);
                throw new OwAuthenticationException(new OwString("opencmis.auth.OwCMISCredentialsAuthenticator.err.login.failed", "Login failed: Wrong username or password!"), (Throwable)e);
            }
            catch (OwException owe) {
                LOG.error((Object)"Could not create credentials!", (Throwable)owe);
                throw new OwServerException("Invalid configuration exception!", (Throwable)owe);
            }
            OwCredentialsAuthentication credentialsAuthentication = new OwCredentialsAuthentication((OwCredentials)credentials, userName, password);
            return credentialsAuthentication;
        }
        LOG.debug((Object)"OwCMISCredentialsAuthenticator.authenticate(): Login failed: Wrong username or password!");
        throw new OwAuthenticationException(new OwString("opencmis.auth.OwCMISCredentialsAuthenticator.err.login.failed", "Login failed: Wrong username or password!"));
    }

    protected OwCMISCredentials createCredentials(String user_p, String password_p, AuthenticationProvider nativeAuthProvider) throws OwException {
        String string = user_p;
        String string2 = password_p;
        AuthenticationProvider authenticationProvider = nativeAuthProvider;
        try {
            OwCMISCredentials owCMISCredentials;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISCredentials = new OwCMISCredentials(user_p, password_p, nativeAuthProvider);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISCredentials;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{string, string2, authenticationProvider};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwRestletAuthenticationHandler createRestletAuthenticationHandler(OwCMISCredentials cred) throws OwException {
        OwCMISCredentials owCMISCredentials = cred;
        try {
            OwRestletBasicAuthenticationHandler owRestletBasicAuthenticationHandler;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owRestletBasicAuthenticationHandler = new OwRestletBasicAuthenticationHandler(cred.getAuthInfo("USER"), cred.getAuthInfo("Password"));
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owRestletBasicAuthenticationHandler;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)owCMISCredentials)));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCredentialsAuthenticator.java", OwCMISCredentialsAuthenticator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createCredentials", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator", "java.lang.String:java.lang.String:org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider", "user_p:password_p:nativeAuthProvider", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRestletAuthenticationHandler", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentialsAuthenticator", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials", "cred", "com.wewebu.ow.server.exceptions.OwException", "org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler"), 129);
    }
}

