/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.auth.OwAuthentication;
import com.wewebu.ow.server.auth.OwAuthenticationContext;
import com.wewebu.ow.server.auth.OwCredentialsAuthentication;
import com.wewebu.ow.server.ecm.OwAuthenticationProvider;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUILoginModule;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.OwCMISUserSelectionModule;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.util.OwString;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISDefaultAuthenticationProvider<U extends OwUsersRepository>
implements OwAuthenticationProvider {
    private static final Logger LOG;
    private OwCMISCredentials credentials;
    private OwMandator mandator;
    protected OwCMISNetwork network;
    private U userRepository;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        OwCMISDefaultAuthenticationProvider.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISDefaultAuthenticationProvider.class);
    }

    public OwCMISDefaultAuthenticationProvider(OwCMISNetwork network) {
        this.network = network;
        this.mandator = this.network.getContext().getMandator();
    }

    public OwUILoginModul getLoginSubModul() throws OwException {
        try {
            OwCMISUILoginModule<OwCMISNetwork> owCMISUILoginModule;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISUILoginModule<OwCMISNetwork> module = new OwCMISUILoginModule<OwCMISNetwork>();
                module.init(this.network);
                owCMISUILoginModule = module;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISUILoginModule;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws OwException {
        String string = strID_p;
        int[] nArray = types_p;
        try {
            OwCMISUserSelectionModule owCMISUserSelectionModule;
            block10: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    if (this.canUserSelect()) {
                        OwCMISUserSelectionModule module = new OwCMISUserSelectionModule((OwUsersRepository)this.getUserRepository());
                        module.setFilter(types_p);
                        module.setCurrentUserID(strID_p);
                        try {
                            module.init(this.network);
                        }
                        catch (OwException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            String msg = "Cannot initialize the User selection module";
                            LOG.error((Object)msg, (Throwable)e);
                            throw new OwServerException(this.network.getContext().localize("opencmis.OwCMISNetwork.err.initUserSelectEx", "Cannot initialize the User Selection dialog."), (Throwable)e);
                        }
                        owCMISUserSelectionModule = module;
                        break block10;
                    }
                    OwString errMessage = new OwString("opencmis.auth.OwCMISDefaultAuthenticationProvider.err.userSelection.notImplemented", "User selection is not supported in this implementation!");
                    throw new OwInvalidOperationException(errMessage);
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return owCMISUserSelectionModule;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)nArray));
            }
            throw cmisBaseException;
        }
    }

    public boolean canUserSelect() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = this.getUserRepository() != null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public OwCredentials getCredentials() throws OwException {
        try {
            OwCMISCredentials owCMISCredentials;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISCredentials = this.credentials;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISCredentials;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public OwUserInfo getUserFromID(String strID_p) throws OwException {
        String string = strID_p;
        try {
            OwUserInfo owUserInfo;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.getUserRepository() == null) {
                    throw new OwNotSupportedException("This method is not supported, use canUserSelect to verify capability.");
                }
                owUserInfo = this.getUserRepository().findUserByID(strID_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owUserInfo;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public String getRoleDisplayName(String strRoleName_p) throws OwException {
        String string = strRoleName_p;
        try {
            String string2;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                string2 = strRoleName_p;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public void logout() throws OwException {
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.credentials != null) {
                    this.credentials.invalidate();
                    this.credentials = null;
                }
                this.userRepository = null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public void loginDefault(String strUser_p, String strPassword_p) throws OwException {
        String string = strUser_p;
        String string2 = strPassword_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwAuthenticationContext authenticationContext = this.network.getAuthenticationContext();
                if (authenticationContext.getAuthentication() == null) {
                    OwCMISAuthenticationInterceptor authenticator = this.createAuthenticator();
                    OwCredentialsAuthentication authentication = new OwCredentialsAuthentication(null, strUser_p, strPassword_p);
                    if ((authentication = authenticator.authenticate((OwAuthentication)authentication)).isAuthenticated()) {
                        OwCMISCredentials credentials = (OwCMISCredentials)authentication.getOWDCredentials();
                        credentials.setMandator(this.mandator);
                        this.credentials = credentials;
                        authenticationContext.setAuthentication((OwAuthentication)authentication);
                    }
                } else {
                    this.credentials = (OwCMISCredentials)authenticationContext.getAuthentication().getOWDCredentials();
                }
                U repo = this.createUserRepository(this.credentials);
                this.credentials.setUserRepository((OwUsersRepository)repo);
                this.setUserRepository(repo);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISAuthenticationInterceptor createAuthenticator() throws OwException {
        try {
            OwCMISAuthenticationInterceptor owCMISAuthenticationInterceptor;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISAuthenticationInterceptor = this.network.getAuthInterceptor();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISAuthenticationInterceptor;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public U getUserRepository() {
        return this.userRepository;
    }

    protected void setUserRepository(U userRepository) {
        this.userRepository = userRepository;
    }

    protected U createUserRepository(OwCMISCredentials credentials) throws OwException {
        OwCMISCredentials owCMISCredentials = credentials;
        try {
            U u;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                u = null;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return u;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)((Object)owCMISCredentials)));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISDefaultAuthenticationProvider.java", OwCMISDefaultAuthenticationProvider.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLoginSubModul", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.ui.OwUILoginModul"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSelectSubModul", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "java.lang.String:[I", "strID_p:types_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canUserSelect", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 103);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCredentials", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwCredentials"), 112);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserFromID", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "java.lang.String", "strID_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwUserInfo"), 121);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleDisplayName", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "java.lang.String", "strRoleName_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 137);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logout", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "void"), 147);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loginDefault", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "java.lang.String:java.lang.String", "strUser_p:strPassword_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 161);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createAuthenticator", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISAuthenticationInterceptor"), 190);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createUserRepository", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials", "credentials", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository"), 223);
    }
}

