/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.auth;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISDefaultAuthenticationProvider;
import com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISNetworkCfg;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepositoryLDAP;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISLDAPAuthenticationProvider
extends OwCMISDefaultAuthenticationProvider<OwUsersRepositoryLDAP> {
    private static final Logger LOG;
    private OwLdapConnector ldapCon;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OwCMISLDAPAuthenticationProvider.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISLDAPAuthenticationProvider.class);
    }

    public OwCMISLDAPAuthenticationProvider(OwCMISNetwork network) {
        super(network);
    }

    @Override
    public void loginDefault(String username_p, String password_p) throws OwException {
        String string = username_p;
        String string2 = password_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (username_p != null && password_p != null) {
                    this.authenticateOverLdap(username_p, password_p);
                }
                super.loginDefault(username_p, password_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    protected OwUsersRepositoryLDAP createLdapUserRepository(OwLdapConnector connector) {
        return new OwUsersRepositoryLDAP(connector);
    }

    @Override
    protected OwUsersRepositoryLDAP createUserRepository(OwCMISCredentials credentials) throws OwException {
        OwCMISCredentials owCMISCredentials = credentials;
        try {
            OwUsersRepositoryLDAP owUsersRepositoryLDAP;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owUsersRepositoryLDAP = this.createLdapUserRepository(this.getLdapConnector());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owUsersRepositoryLDAP;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)((Object)owCMISCredentials)));
            }
            throw cmisBaseException;
        }
    }

    private void authenticateOverLdap(String userName, String password) throws OwServerException, OwConfigurationException, OwAuthenticationException {
        OwLdapConnector conLdap;
        try {
            conLdap = this.getLdapConnector();
        }
        catch (OwException e1) {
            LOG.debug((Object)"LDAP connection cannot be retrieved", (Throwable)e1);
            throw new OwServerException("Faild to create LDAP connection", (Throwable)e1);
        }
        if (conLdap != null) {
            try {
                conLdap.authenticate(userName, password);
            }
            catch (OwAuthenticationException owa) {
                LOG.debug((Object)"Authentication Exception: Cloud not verify login against LDAP", (Throwable)owa);
                throw new OwAuthenticationException(new OwString("ecmimpl.opencmis.OwCMISNetwork.login.failed", "Login failed: Wrong username or password"), (Throwable)owa);
            }
        }
    }

    protected OwLdapConnector getLdapConnector() throws OwException {
        try {
            OwLdapConnector owLdapConnector;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (this.ldapCon != null) {
                    owLdapConnector = this.ldapCon;
                } else {
                    OwCMISNetworkCfg config = this.network.getNetworkConfiguration();
                    OwAuthenticationConfiguration authConf = config.getAuthenticationConfiguration();
                    if (authConf != null && "LDAP".equals(authConf.getMode())) {
                        this.ldapCon = this.createLDAPConnector(authConf);
                    }
                    owLdapConnector = this.ldapCon;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owLdapConnector;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    protected OwLdapConnector createLDAPConnector(OwAuthenticationConfiguration authConf) {
        return new OwLdapConnector(authConf.getConfiguration().getNode());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISLDAPAuthenticationProvider.java", OwCMISLDAPAuthenticationProvider.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loginDefault", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPAuthenticationProvider", "java.lang.String:java.lang.String", "username_p:password_p", "com.wewebu.ow.server.exceptions.OwException", "void"), 48);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createUserRepository", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPAuthenticationProvider", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISCredentials", "credentials", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepositoryLDAP"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getLdapConnector", "com.wewebu.ow.server.ecmimpl.opencmis.auth.OwCMISLDAPAuthenticationProvider", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.util.ldap.OwLdapConnector"), 107);
    }
}

