/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.collections;

import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISObjectIterator;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import java.util.Iterator;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;

public class OwCMISObjectIterable
extends OwIterableAttributeBag<OwCMISObject> {
    private ItemIterable<? extends CmisObject> iterable;
    private OwCMISNativeSession session;
    private long skipCount = 0L;

    public OwCMISObjectIterable(ItemIterable<? extends CmisObject> iterable, OwCMISNativeSession session) {
        this.iterable = iterable;
        this.session = session;
    }

    public OwIterable<OwCMISObject> skipTo(long position) {
        OwCMISObjectIterable skippedIterable = new OwCMISObjectIterable((ItemIterable<? extends CmisObject>)this.iterable.skipTo(position), this.session);
        skippedIterable.skipCount = position;
        return skippedIterable;
    }

    public OwIterable<OwCMISObject> getPage() {
        OwCMISObjectIterable page = new OwCMISObjectIterable((ItemIterable<? extends CmisObject>)this.iterable.getPage(), this.session);
        page.isPage = true;
        return page;
    }

    public OwIterable<OwCMISObject> getPage(int maxNumItems) {
        OwCMISObjectIterable page = new OwCMISObjectIterable((ItemIterable<? extends CmisObject>)this.iterable.getPage(maxNumItems), this.session);
        page.isPage = true;
        return page;
    }

    public Iterator<OwCMISObject> iterator() {
        if (this.isPage) {
            return new OwCMISObjectIterator(this.iterable.getPage().iterator(), this.session);
        }
        return new OwCMISObjectIterator(this.iterable.skipTo(this.skipCount).iterator(), this.session);
    }

    public long getPageNumItems() {
        return this.iterable.getPageNumItems();
    }

    public boolean getHasMoreItems() {
        return this.iterable.getHasMoreItems();
    }

    public long getTotalNumItems() {
        return this.iterable.getTotalNumItems();
    }
}

