/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.collections;

import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.collections.OwIterableAttributeBag;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositorySession;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISQueryResultIterator;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISQueryIterable
extends OwIterableAttributeBag<OwCMISObject> {
    private static Logger LOG;
    private ItemIterable<QueryResult> iterable = null;
    private OwCMISRepositorySession session;
    private OwQueryStatement queryStatement;
    private OwLoadContext context;
    private OwCMISNativeObjectClass<ObjectType, TransientCmisObject> mainObjectClass;
    private long skipCount = 0L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OwCMISQueryIterable.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISQueryIterable.class);
    }

    public OwCMISQueryIterable(OwCMISRepositorySession session, OwQueryStatement queryStatement, OwLoadContext context) throws OwException {
        this.session = session;
        this.queryStatement = queryStatement;
        this.context = context;
        this.findMainClass();
    }

    private OwCMISQueryIterable(ItemIterable<QueryResult> iterable, OwCMISRepositorySession session, OwQueryStatement queryStatement, OwLoadContext context, OwCMISNativeObjectClass<ObjectType, TransientCmisObject> mainObjectClass) {
        this.iterable = iterable;
        this.session = session;
        this.queryStatement = queryStatement;
        this.context = context;
        this.mainObjectClass = mainObjectClass;
    }

    private void findMainClass() throws OwException {
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String mainObjectClassId = this.queryStatement.getMainTableQualifier().getTargetObjectType();
                this.mainObjectClass = this.session.getObjectClass(mainObjectClassId);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this)));
            }
            throw cmisBaseException;
        }
    }

    public OwCMISQueryIterable skipTo(long position) {
        OwCMISQueryIterable skippedIterable = new OwCMISQueryIterable((ItemIterable<QueryResult>)this.getIterable().skipTo(position), this.session, this.queryStatement, this.context, this.mainObjectClass);
        skippedIterable.skipCount = position;
        return skippedIterable;
    }

    public OwCMISQueryIterable getPage(int maxNumItems) {
        OwCMISQueryIterable page = new OwCMISQueryIterable((ItemIterable<QueryResult>)this.getIterable().getPage(maxNumItems), this.session, this.queryStatement, this.context, this.mainObjectClass);
        page.isPage = true;
        return page;
    }

    public OwCMISQueryIterable getPage() {
        OwCMISQueryIterable page = new OwCMISQueryIterable((ItemIterable<QueryResult>)this.getIterable().getPage(), this.session, this.queryStatement, this.context, this.mainObjectClass);
        page.isPage = true;
        return page;
    }

    public Iterator<OwCMISObject> iterator() {
        if (this.isPage) {
            return new OwCMISQueryResultIterator(this.getIterable().getPage().iterator(), this.session, this.queryStatement, this.toOperationContext(this.context));
        }
        return new OwCMISQueryResultIterator(this.getIterable().skipTo(this.skipCount).iterator(), this.session, this.queryStatement, this.toOperationContext(this.context));
    }

    public long getPageNumItems() {
        return this.getIterable().getPageNumItems();
    }

    public boolean getHasMoreItems() {
        return this.getIterable().getHasMoreItems();
    }

    public long getTotalNumItems() {
        return this.getIterable().getTotalNumItems();
    }

    protected OperationContext toOperationContext(OwLoadContext context) {
        OperationContext operationContext = this.session.createOperationContext((Collection<String>)context.getPropertyNames(), context.getSorting(), context.getPageSize(), this.mainObjectClass);
        operationContext.setIncludeRelationships(IncludeRelationships.NONE);
        return operationContext;
    }

    private ItemIterable<QueryResult> getIterable() {
        if (this.iterable == null) {
            String sqlStatement = this.queryStatement.createSQLString().toString();
            LOG.debug((Object)("iterable-query: " + sqlStatement));
            this.iterable = this.session.getOpenCMISSession().query(sqlStatement, this.context.getVersionSelection() == 3, this.toOperationContext(this.context));
        }
        return this.iterable;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISQueryIterable.java", OwCMISQueryIterable.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findMainClass", "com.wewebu.ow.server.ecmimpl.opencmis.collections.OwCMISQueryIterable", "", "", "com.wewebu.ow.server.exceptions.OwException", "void"), 68);
    }
}

