/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.conf;

import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISQualifiedName;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OwCMISPreferredPropertyTypeCfg {
    private static final Logger LOG;
    private static final String ATT_TYPE = "type";
    private static final String PROPERTY_TYPE_USER = "user";
    private static final String PROPERTY_TYPE_SYSTEM = "system";
    private Map<String, PropertyType> preferredPropertyTypeMap = new HashMap<String, PropertyType>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        OwCMISPreferredPropertyTypeCfg.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISPreferredPropertyTypeCfg.class);
    }

    public OwCMISPreferredPropertyTypeCfg(OwXMLUtil configNode) {
        List properties = configNode.getSafeNodeList("PreferredPropertyType");
        for (Object object : properties) {
            Element propDefElem = (Element)object;
            String propType = OwXMLDOMUtil.getSafeStringAttributeValue((Node)propDefElem, (String)ATT_TYPE, null);
            String propName = OwXMLDOMUtil.getElementText((Element)propDefElem);
            if (propName == null || propType == null) continue;
            propType = propType.trim();
            propName = propName.trim();
            PropertyType propTypeValue = null;
            if (propType.equalsIgnoreCase(PROPERTY_TYPE_USER)) {
                propTypeValue = PropertyType.USER;
            } else if (propType.equalsIgnoreCase(PROPERTY_TYPE_SYSTEM)) {
                propTypeValue = PropertyType.SYSTEM;
            } else {
                LOG.error((Object)String.format("The value '%s' for the '%s' attribute is invalid.", propType, ATT_TYPE));
            }
            this.preferredPropertyTypeMap.put(propName, propTypeValue);
        }
    }

    public PropertyType getPreferredType(OwCMISPropertyClass propertyClass) throws OwException {
        OwCMISPropertyClass owCMISPropertyClass = propertyClass;
        try {
            PropertyType propertyType;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                PropertyType preferredType = this.getPreferredType(propertyClass.getNonQualifiedName(), propertyClass.getObjectClass());
                if (preferredType == null) {
                    preferredType = PropertyType.UNSET;
                }
                this.preferredPropertyTypeMap.put(propertyClass.getFullQualifiedName().toString(), preferredType);
                propertyType = preferredType;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return propertyType;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)owCMISPropertyClass));
            }
            throw cmisBaseException;
        }
    }

    private PropertyType getPreferredType(String shortName, OwCMISObjectClass inClass) throws OwException {
        String string = shortName;
        OwCMISObjectClass owCMISObjectClass = inClass;
        try {
            PropertyType propertyType;
            block10: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    OwCMISObjectClass parentClass;
                    PropertyType prefferedType = null;
                    OwCMISPropertyClass<?> property = null;
                    try {
                        property = inClass.getPropertyClass(shortName);
                    }
                    catch (OwObjectNotFoundException owObjectNotFoundException) {
                        propertyType = PropertyType.UNSET;
                        break block10;
                    }
                    OwCMISQualifiedName qName = property.getFullQualifiedName();
                    String longName = qName.toString();
                    prefferedType = this.getPropertyTypeFor(longName);
                    if (prefferedType == null) {
                        prefferedType = this.getPropertyTypeFor(shortName);
                    }
                    if (prefferedType == null && (parentClass = inClass.getParent()) != null) {
                        prefferedType = this.getPreferredType(shortName, parentClass);
                    }
                    propertyType = prefferedType;
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return propertyType;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)owCMISObjectClass));
            }
            throw cmisBaseException;
        }
    }

    protected PropertyType getPropertyTypeFor(String propName) {
        return this.preferredPropertyTypeMap.get(propName);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISPreferredPropertyTypeCfg.java", OwCMISPreferredPropertyTypeCfg.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPreferredType", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass", "propertyClass", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg$PropertyType"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getPreferredType", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg", "java.lang.String:com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass", "shortName:inClass", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.conf.OwCMISPreferredPropertyTypeCfg$PropertyType"), 89);
    }

    public static enum PropertyType {
        SYSTEM,
        USER,
        UNSET;

    }
}

