/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.cross;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwCrossMappings;
import com.wewebu.ow.server.ecm.OwExtendedCrossMappings;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISCrossInvocationHandler
implements InvocationHandler {
    private static final Logger LOG;
    private static Method GETPROPETYCLASS;
    private static Method GETPROPETY;
    private static Method GETPROPETIES;
    private static Method CLASS_GETCLASSNAME;
    private static Method OBJECT_GETCLASSNAME;
    private static Method NETWORK_CREATEOBJECTCOPY;
    private static Method CLASS_GETCHILDS;
    private static Method OBJECT_GETCHILDS;
    private static Method CLASS_GETPROPERTYCLASSNAMES;
    private static Method PROPERTYCLASS_GETCLASSNAME;
    private static Method NETWORK_CREATENEWOBJECT_1;
    private static Method NETWORK_CREATENEWOBJECT_2;
    private static final Map<Class<?>, Class<?>[]> interfaces;
    private OwCMISCrossNetwork crossNetwork;
    private OwCrossMappings mappings;
    private Object object;
    private static ThreadLocal<String> clientResourceID;
    private String serverResourceID;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        OwCMISCrossInvocationHandler.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISCrossInvocationHandler.class);
        try {
            GETPROPETYCLASS = OwObjectClass.class.getMethod("getPropertyClass", String.class);
            CLASS_GETCLASSNAME = OwObjectClass.class.getMethod("getClassName", new Class[0]);
            OBJECT_GETCLASSNAME = OwObject.class.getMethod("getClassName", new Class[0]);
            GETPROPETY = OwObject.class.getMethod("getProperty", String.class);
            GETPROPETIES = OwObject.class.getMethod("getProperties", Collection.class);
            CLASS_GETCHILDS = OwObjectClass.class.getMethod("getChilds", OwNetwork.class, Boolean.TYPE);
            CLASS_GETPROPERTYCLASSNAMES = OwObjectClass.class.getMethod("getPropertyClassNames", new Class[0]);
            PROPERTYCLASS_GETCLASSNAME = OwPropertyClass.class.getMethod("getClassName", new Class[0]);
            OBJECT_GETCHILDS = OwObject.class.getMethod("getChilds", int[].class, Collection.class, OwSort.class, Integer.TYPE, Integer.TYPE, OwSearchNode.class);
            NETWORK_CREATEOBJECTCOPY = OwNetwork.class.getMethod("createObjectCopy", OwObject.class, OwPropertyCollection.class, OwPermissionCollection.class, OwObject.class, int[].class);
            NETWORK_CREATENEWOBJECT_1 = OwNetwork.class.getMethod("createNewObject", Boolean.TYPE, Object.class, OwResource.class, String.class, OwPropertyCollection.class, OwPermissionCollection.class, OwContentCollection.class, OwObject.class, String.class, String.class);
            NETWORK_CREATENEWOBJECT_2 = OwNetwork.class.getMethod("createNewObject", OwResource.class, String.class, OwPropertyCollection.class, OwPermissionCollection.class, OwContentCollection.class, OwObject.class, String.class, String.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Inavlid java code base.", (Throwable)e);
        }
        interfaces = new HashMap();
        clientResourceID = new ThreadLocal();
    }

    private static synchronized Class[] allInterfacesOf(Class<?> class_p) {
        Class[] classInterfaces = interfaces.get(class_p);
        if (classInterfaces == null) {
            HashSet interfacesList = new HashSet();
            Class<?> current = class_p;
            while (current != null) {
                Class<?>[] currentInterfaces = current.getInterfaces();
                int i = 0;
                while (i < currentInterfaces.length) {
                    interfacesList.add(currentInterfaces[i]);
                    ++i;
                }
                current = current.getSuperclass();
            }
            classInterfaces = interfacesList.toArray(new Class[interfacesList.size()]);
            interfaces.put(class_p, classInterfaces);
        }
        return classInterfaces;
    }

    public static Object call(CrossCall call, String callClientResourceID) throws Exception {
        String stackedResource = clientResourceID.get();
        try {
            clientResourceID.set(callClientResourceID);
            Object object = call.call();
            return object;
        }
        finally {
            clientResourceID.set(stackedResource);
        }
    }

    public static <O> O createCrossNetworkObject(OwCMISCrossNetwork network_p, OwCrossMappings mappings_p, O object_p, String serverResourceID_p) {
        Class<?> clazz = object_p.getClass();
        Class[] interfaces = OwCMISCrossInvocationHandler.allInterfacesOf(clazz);
        return (O)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)new OwCMISCrossInvocationHandler(network_p, mappings_p, object_p, serverResourceID_p));
    }

    public OwCMISCrossInvocationHandler(OwCMISCrossNetwork crossNetwork_p, OwCrossMappings mappings_p, Object object_p, String serverResourceID_p) {
        this.crossNetwork = crossNetwork_p;
        this.mappings = mappings_p;
        this.object = object_p;
        this.serverResourceID = serverResourceID_p;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] crossArgs = this.toCrossArguments(method, args);
        if (crossArgs != null) {
            int i = 0;
            while (i < crossArgs.length) {
                if (crossArgs[i] instanceof OwNetwork) {
                    crossArgs[i] = this.crossNetwork.getNetwork(this.serverResourceID);
                }
                if (crossArgs[i] instanceof OwObject) {
                    OwObject objectArgument = (OwObject)crossArgs[i];
                    crossArgs[i] = this.mirrorObject(objectArgument);
                }
                ++i;
            }
        }
        String stackedResource = clientResourceID.get();
        try {
            clientResourceID.set(this.serverResourceID);
            Object returnValue = null;
            returnValue = method.getName().equals("equals") && 1 == crossArgs.length ? Boolean.valueOf(this.callEquals(crossArgs[0])) : method.invoke(this.object, crossArgs);
            clientResourceID.set(stackedResource);
            if (this.crossConversionRequired()) {
                if (this.overrides(CLASS_GETCLASSNAME, method) || this.overrides(OBJECT_GETCLASSNAME, method)) {
                    if (this.isExternal(clientResourceID.get())) {
                        String string = ((OwExtendedCrossMappings)this.mappings).getXClass((String)returnValue);
                        return string;
                    }
                    String string = ((OwExtendedCrossMappings)this.mappings).getIClass((String)returnValue);
                    return string;
                }
                Object object = this.toCrossReturnValue(returnValue);
                return object;
            }
            if (this.overrides(CLASS_GETCHILDS, method)) {
                Object object = this.crossConvertReturnValue(returnValue);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            clientResourceID.set(stackedResource);
        }
    }

    private boolean overrides(Method overriden_p, Method method_p) throws OwException {
        Method method = overriden_p;
        Method method2 = method_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (overriden_p == null || method_p == null) {
                    throw new OwInvalidOperationException("null method comparison " + (overriden_p == null ? "null" : overriden_p.toString()) + " vs. " + (method_p == null ? "null" : method_p.toString()));
                }
                bl = overriden_p.getDeclaringClass().isAssignableFrom(method_p.getDeclaringClass()) && overriden_p.getName().equals(method_p.getName()) && Arrays.equals(overriden_p.getParameterTypes(), method_p.getParameterTypes());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)method, (Object)method2));
            }
            throw cmisBaseException;
        }
    }

    private OwObject mirrorObject(OwObject object_p) throws OwInvalidOperationException {
        String resourceID = null;
        try {
            if (object_p.getResource() != null) {
                resourceID = object_p.getResourceID();
            }
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Invalidobject argument", (Throwable)e);
        }
        if (resourceID == null && this.serverResourceID != null || resourceID != null && !resourceID.equals(this.serverResourceID)) {
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this.crossNetwork, this.mappings, object_p, resourceID);
        }
        return object_p;
    }

    private boolean crossConversionRequired() throws Exception {
        if (clientResourceID.get() == null) {
            return this.serverResourceID != null && !this.crossNetwork.getResource(clientResourceID.get()).getID().equals(this.serverResourceID);
        }
        return !clientResourceID.get().equals(this.serverResourceID);
    }

    private boolean isExternal(String repositoryID_p) throws OwException {
        String string = repositoryID_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = this.crossNetwork.getNetwork(repositoryID_p) == this.crossNetwork.getExternalNetwork();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private Object[] toCrossArguments(Method method_p, Object[] args_p) throws Exception {
        if (this.crossConversionRequired()) {
            return this.crossConvertMehtodArguments(method_p, args_p);
        }
        return args_p;
    }

    private String toCrossPropertyName(String propertyName_p, String fromRepositoryID_p) throws OwException {
        String string = propertyName_p;
        String string2 = fromRepositoryID_p;
        try {
            String string3;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                string3 = this.isExternal(fromRepositoryID_p) ? ((OwExtendedCrossMappings)this.mappings).getIProperty(propertyName_p) : ((OwExtendedCrossMappings)this.mappings).getXProperty(propertyName_p);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    private Collection<String> toCrossPropertyNames(Collection propertyNames_p, String fromResourceID_p) throws OwException {
        Collection collection = propertyNames_p;
        String string = fromResourceID_p;
        try {
            Collection<String> collection2;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                collection2 = this.toCrossPropertyNames(propertyNames_p, fromResourceID_p, new LinkedList<String>());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection2;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)collection, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private Collection<String> toCrossPropertyNames(Collection propertyNames_p, String fromResourceID_p, Collection<String> crosssNames_p) throws OwException {
        Collection collection = propertyNames_p;
        String string = fromResourceID_p;
        Collection<String> collection2 = crosssNames_p;
        try {
            Collection<String> collection3;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (propertyNames_p != null) {
                    for (String name : propertyNames_p) {
                        crosssNames_p.add(this.toCrossPropertyName(name, fromResourceID_p));
                    }
                    collection3 = crosssNames_p;
                } else {
                    collection3 = null;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{collection, string, collection2};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    private Object[] crossConvertMehtodArguments(Method method_p, Object[] args_p) throws Exception {
        Object[] crossArgs = null;
        if (args_p != null) {
            crossArgs = new Object[args_p.length];
            System.arraycopy(args_p, 0, crossArgs, 0, args_p.length);
            if (this.overrides(GETPROPETYCLASS, method_p) || this.overrides(GETPROPETY, method_p)) {
                crossArgs[0] = this.toCrossPropertyName((String)crossArgs[0], clientResourceID.get());
            } else if (this.overrides(GETPROPETIES, method_p)) {
                crossArgs[0] = this.toCrossPropertyNames((Collection)crossArgs[0], clientResourceID.get());
            } else if (this.overrides(OBJECT_GETCHILDS, method_p)) {
                crossArgs[1] = this.toCrossPropertyNames((Collection)crossArgs[1], clientResourceID.get());
            } else if (this.overrides(NETWORK_CREATEOBJECTCOPY, method_p)) {
                crossArgs[1] = this.toCrossProperties((OwPropertyCollection)crossArgs[1], clientResourceID.get(), this.serverResourceID);
            } else if (this.overrides(NETWORK_CREATENEWOBJECT_1, method_p)) {
                crossArgs[3] = this.toCrossClassName((String)crossArgs[3], clientResourceID.get());
            } else if (this.overrides(NETWORK_CREATENEWOBJECT_2, method_p)) {
                crossArgs[1] = this.toCrossClassName((String)crossArgs[1], clientResourceID.get());
            }
        }
        return crossArgs;
    }

    private Object toCrossReturnValue(Object object_p) throws Exception {
        if (this.crossConversionRequired()) {
            return this.crossConvertReturnValue(object_p);
        }
        return object_p;
    }

    private Object crossConvertReturnValue(Object object_p) throws Exception {
        if (object_p == null) {
            return null;
        }
        if (object_p instanceof OwObject || object_p instanceof OwFieldDefinition || object_p instanceof OwObjectClass || object_p instanceof OwPropertyClass || object_p instanceof OwProperty) {
            return OwCMISCrossInvocationHandler.createCrossNetworkObject(this.crossNetwork, this.mappings, object_p, this.serverResourceID);
        }
        if (object_p instanceof List) {
            List list = (List)object_p;
            int listSize = list.size();
            int i = 0;
            while (i < listSize) {
                Object iCrossObject;
                Object e = list.get(i);
                if (e != (iCrossObject = this.crossConvertReturnValue(e))) {
                    list.remove(i);
                    list.add(i, iCrossObject);
                }
                ++i;
            }
            return list;
        }
        if (object_p instanceof Collection) {
            Collection collection = (Collection)object_p;
            Iterator i = collection.iterator();
            ArrayList<Object> toBeCrossed = new ArrayList<Object>();
            while (i.hasNext()) {
                Object iCrossObject;
                Object e = i.next();
                if (e == (iCrossObject = this.crossConvertReturnValue(e))) continue;
                i.remove();
                toBeCrossed.add(iCrossObject);
            }
            for (Object e : toBeCrossed) {
                collection.add(e);
            }
            return collection;
        }
        if (object_p instanceof OwPropertyCollection) {
            OwPropertyCollection propertyCollection = (OwPropertyCollection)object_p;
            OwStandardPropertyCollection interceptedCollection = new OwStandardPropertyCollection();
            Set propertyEntries = propertyCollection.entrySet();
            for (Map.Entry entry : propertyEntries) {
                OwProperty property = (OwProperty)entry.getValue();
                try {
                    OwProperty crossProperty = this.toCrossProperty(property, this.serverResourceID, clientResourceID.get());
                    interceptedCollection.put((Object)crossProperty.getPropertyClass().getClassName(), (Object)crossProperty);
                }
                catch (OwObjectNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Invalid property cross-conversion for " + (String)entry.getKey() + ". "), (Throwable)e);
                        continue;
                    }
                    LOG.warn((Object)("Invalid property cross-conversion for " + (String)entry.getKey() + ". " + e.getMessage()));
                }
            }
            return interceptedCollection;
        }
        return object_p;
    }

    private OwPropertyCollection toCrossProperties(OwPropertyCollection properties, String fromRepositoryID, String toResourceID) throws Exception {
        if (properties != null) {
            Set propertyEntries = properties.entrySet();
            OwStandardPropertyCollection crossPropertyCollection = new OwStandardPropertyCollection();
            for (Map.Entry entry : propertyEntries) {
                OwProperty crossProperty = this.toCrossProperty((OwProperty)entry.getValue(), fromRepositoryID, toResourceID);
                crossPropertyCollection.put((Object)crossProperty.getPropertyClass().getClassName(), (Object)crossProperty);
            }
            return crossPropertyCollection;
        }
        return null;
    }

    private OwProperty toCrossProperty(OwProperty property, String fromRepositoryID, String toResourceID) throws Exception {
        OwPropertyClass propertyClass = property.getPropertyClass();
        String propertyClassName = propertyClass.getClassName();
        String crossPropertyClassName = this.toCrossPropertyName(propertyClassName, fromRepositoryID);
        OwNetwork clientNetwrok = this.crossNetwork.getNetwork(toResourceID);
        OwResource clientResource = this.crossNetwork.getResource(toResourceID);
        OwPropertyClass crossPropertyClass = (OwPropertyClass)clientNetwrok.getFieldDefinition(crossPropertyClassName, clientResource.getID());
        return this.convert(property, crossPropertyClass);
    }

    private String toCrossClassName(String className, String fromRepositoryID) throws OwException {
        String string = className;
        String string2 = fromRepositoryID;
        try {
            String string3;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                string3 = this.isExternal(fromRepositoryID) ? ((OwExtendedCrossMappings)this.mappings).getIClass(className) : ((OwExtendedCrossMappings)this.mappings).getXClass(className);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2));
            }
            throw cmisBaseException;
        }
    }

    private OwProperty convert(OwProperty property, OwPropertyClass toClass) throws Exception {
        Object convertedValue = this.mappings.convert(property.getValue(), (OwFieldDefinition)property.getPropertyClass(), (OwFieldDefinition)toClass);
        return new OwStandardProperty(convertedValue, toClass);
    }

    private boolean callEquals(Object other) {
        Object naked = other;
        while (Proxy.isProxyClass(naked.getClass()) && Proxy.getInvocationHandler(naked).getClass() == OwCMISCrossInvocationHandler.class) {
            naked = ((OwCMISCrossInvocationHandler)Proxy.getInvocationHandler((Object)naked)).object;
        }
        return this.object.equals(naked);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISCrossInvocationHandler.java", OwCMISCrossInvocationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "overrides", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.lang.reflect.Method:java.lang.reflect.Method", "overriden_p:method_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 278);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isExternal", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.lang.String", "repositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 337);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toCrossPropertyName", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.lang.String:java.lang.String", "propertyName_p:fromRepositoryID_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 354);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toCrossPropertyNames", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.util.Collection:java.lang.String", "propertyNames_p:fromResourceID_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 366);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toCrossPropertyNames", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.util.Collection:java.lang.String:java.util.Collection", "propertyNames_p:fromResourceID_p:crosssNames_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 371);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toCrossClassName", "com.wewebu.ow.server.ecmimpl.opencmis.cross.OwCMISCrossInvocationHandler", "java.lang.String:java.lang.String", "className:fromRepositoryID", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 567);
    }

    public static interface CrossCall {
        public Object call() throws Exception;
    }
}

