/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.field;

import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.log4j.Logger;

public class OwCMISBooleanTextFormat
extends Format {
    private static final Logger LOG = OwLog.getLogger(OwCMISBooleanTextFormat.class);
    private static final long serialVersionUID = -6411421911069058729L;
    private String trueString;
    private String falseString;

    public OwCMISBooleanTextFormat() {
        this.trueString = "true";
        this.falseString = "false";
    }

    public OwCMISBooleanTextFormat(String trueString_p, String falseString_p) throws OwInvalidOperationException {
        if (trueString_p == null || falseString_p == null) {
            LOG.error((Object)"OwCMISBooleanTextFormat.OwCMISBooleanTextFormat(): both the true and false string should be specified!");
            throw new OwInvalidOperationException("Invalid format boolean strings!");
        }
        this.trueString = trueString_p;
        this.falseString = falseString_p;
    }

    public OwCMISBooleanTextFormat(String pattern_p) throws OwInvalidOperationException {
        String[] valuePatterns = pattern_p.split(":");
        if (valuePatterns.length != 2) {
            LOG.error((Object)("OwCMISBooleanTextFormat.OwCMISBooleanTextFormat():Cannot construct a boolean format from " + pattern_p + ". The pattern must contain a single ':' " + "character"));
            throw new OwInvalidOperationException("Cannot construct a boolean format from " + pattern_p + ". The pattern must contain a single ':' " + "character");
        }
        this.trueString = valuePatterns[0];
        this.falseString = valuePatterns[1];
    }

    @Override
    public StringBuffer format(Object obj_p, StringBuffer appendTo_p, FieldPosition pos_p) {
        if (obj_p != null && !(obj_p instanceof Boolean)) {
            LOG.error((Object)"OwCMISBooleanTextFormat.format():A non null Boolean object was expected!");
            throw new IllegalArgumentException("A non null Boolean object was expected!");
        }
        Boolean val = (Boolean)obj_p;
        if (val == null) {
            pos_p.setBeginIndex(0);
            pos_p.setEndIndex(0);
        } else if (val.booleanValue()) {
            appendTo_p.append(this.trueString);
            pos_p.setBeginIndex(0);
            pos_p.setEndIndex(this.trueString.length() - 1);
        } else {
            appendTo_p.append(this.falseString);
            pos_p.setBeginIndex(0);
            pos_p.setEndIndex(this.falseString.length() - 1);
        }
        return appendTo_p;
    }

    @Override
    public Boolean parseObject(String source_p, ParsePosition pos_p) {
        if (source_p == null) {
            LOG.error((Object)"OwCMISBooleanTextFormat.parseObject():The source is null!");
            throw new NullPointerException("The source is null!");
        }
        Boolean value = null;
        if (this.trueString.equalsIgnoreCase(source_p.trim())) {
            value = Boolean.TRUE;
            pos_p.setIndex(this.trueString.length());
        } else if (this.falseString.equalsIgnoreCase(source_p.trim())) {
            value = Boolean.FALSE;
            pos_p.setIndex(this.falseString.length());
        }
        if (value == null) {
            pos_p.setErrorIndex(0);
        }
        return value;
    }

    public Boolean parse(String text_p) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Boolean result = this.parseObject(text_p, parsePosition);
        if (parsePosition.getIndex() == 0) {
            LOG.debug((Object)("OwCMISBooleanTextFormat.parse():Unparseable boolean: \"" + text_p + "\" at possition " + parsePosition.getErrorIndex()));
            throw new ParseException("Unparseable boolean: \"" + text_p + '\"', parsePosition.getErrorIndex());
        }
        return result;
    }
}

