/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.objectclass;

import com.wewebu.ow.csqlc.ast.OwQueryStatement;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativePropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISRepositoryObjectSkeleton;
import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.content.OwCMISContentFactory;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISBulkTransientObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISTransientObject;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractSessionObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISPropertySorter;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISQueryResultConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISQueryResultConverterImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISAclDiff;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISBoundVirtualProperty;
import com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISClassDescriptionPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwCMISQualifiedName;
import com.wewebu.ow.server.ecmimpl.opencmis.util.OwPropertyDefinitionHelper;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.api.TransientFolder;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class OwCMISAbstractNativeObjectClass<T extends ObjectType, O extends TransientCmisObject>
extends OwCMISAbstractSessionObjectClass<OwCMISNativeSession>
implements OwCMISNativeObjectClass<T, O> {
    private static final Logger LOG;
    private T objectType;
    private Map<String, OwCMISNativePropertyClass<?, ?, ?>> localProps;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        OwCMISAbstractNativeObjectClass.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAbstractNativeObjectClass.class);
    }

    public OwCMISAbstractNativeObjectClass(T objectType_p, OwCMISNativeSession session_p) {
        super(session_p);
        this.objectType = objectType_p;
        if (objectType_p.getParentTypeId() == null) {
            this.initializeAsHierarchyRoot();
            OwCMISClassDescriptionPropertyClass classDescription = new OwCMISClassDescriptionPropertyClass(this);
            this.addVirtualPropertyClass(classDescription);
        }
    }

    public final int getType() {
        BaseTypeId baseTypeId = this.objectType.getBaseTypeId();
        switch (baseTypeId) {
            case CMIS_DOCUMENT: {
                return 4097;
            }
            case CMIS_FOLDER: {
                return 8193;
            }
            case CMIS_POLICY: {
                return 12289;
            }
            case CMIS_RELATIONSHIP: {
                return 12291;
            }
        }
        return 0;
    }

    public String getClassName() {
        return this.objectType.getId();
    }

    @Override
    public String getDescription(Locale locale_p) {
        return OwString.localize((Locale)locale_p, (String)(String.valueOf(this.getClassName()) + ".Desc"), (String)this.objectType.getDescription());
    }

    @Override
    public String getMimetype() {
        BaseTypeId baseTypeId = this.objectType.getBaseTypeId();
        switch (baseTypeId) {
            case CMIS_DOCUMENT: {
                return null;
            }
            case CMIS_FOLDER: {
                return "ow_folder/" + this.objectType.getId();
            }
            case CMIS_POLICY: {
                return "ow_policy/" + this.objectType.getId();
            }
            case CMIS_RELATIONSHIP: {
                return "ow_relationship/" + this.objectType.getId();
            }
        }
        return null;
    }

    @Override
    public boolean isQueryable() {
        return this.objectType.isQueryable();
    }

    @Override
    public String getQueryName() {
        return this.objectType.getQueryName();
    }

    public String getDisplayName(Locale locale_p) {
        return OwString.localizeLabel((Locale)locale_p, (String)this.getClassName(), (String)this.objectType.getDisplayName());
    }

    @Override
    public boolean canCreateNewObject() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = this.objectType.isCreatable();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public T getNativeObject() {
        return this.objectType;
    }

    @Override
    public Map<String, OwCMISPropertyClass<?>> getPropertyClasses() throws OwException {
        try {
            Map<String, OwCMISPropertyClass<?>> map;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Map<String, OwCMISPropertyClass<?>> classes = super.getPropertyClasses();
                classes.putAll(this.getNativePropertyClasses(true));
                map = classes;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return map;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public Map<String, OwCMISNativePropertyClass<?, ?, ?>> getNativePropertyClasses(boolean localOnly_p) throws OwException {
        boolean bl = localOnly_p;
        try {
            Map<String, OwCMISNativePropertyClass<?, ?, ?>> map;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Map<String, OwCMISNativePropertyClass<?, ?, ?>> orderedClasses;
                OwObjectClass parent;
                LinkedHashMap classes = new LinkedHashMap();
                OwCMISNativeSession session = (OwCMISNativeSession)this.getSession();
                OwCMISNativePropertyClassFactory propertyClassFactory = session.getNativePropertyClassFactory();
                Map propertyDefinitions = this.objectType.getPropertyDefinitions();
                Set entries = Collections.EMPTY_SET;
                if (propertyDefinitions != null) {
                    entries = propertyDefinitions.entrySet();
                }
                if (!localOnly_p && (parent = this.getParent()) != null) {
                    Map<String, OwCMISNativePropertyClass<Object, ?, ?>> parentClasses = parent.getNativePropertyClasses(false);
                    classes.putAll(parentClasses);
                }
                if (this.localProps == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Creating local property classes for = " + this.getClassName()));
                    }
                    parent = this.getParent();
                    this.localProps = new LinkedHashMap();
                    for (Map.Entry entry : entries) {
                        PropertyDefinition propDef = (PropertyDefinition)entry.getValue();
                        if (propDef.isInherited().booleanValue()) {
                            PropertyDefinition parentProp;
                            if (parent == null || !OwPropertyDefinitionHelper.isInheritanceDifferent(propDef, parentProp = (PropertyDefinition)parent.getNativeObject().getPropertyDefinitions().get(entry.getKey()))) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("OwCMISAbstractNativeObjectClass.getNativePropertyClasses: Inherited but different prop-definition: " + propDef));
                            }
                            OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> propertyClass = propertyClassFactory.createPropertyClass(null, propDef, this);
                            this.localProps.put(propertyClass.getClassName(), propertyClass);
                            continue;
                        }
                        OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> propertyClass = propertyClassFactory.createPropertyClass(null, propDef, this);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Local property class = " + propertyClass.getClassName()));
                        }
                        this.localProps.put(propertyClass.getClassName(), propertyClass);
                    }
                }
                classes.putAll(this.localProps);
                List<String> preferredPropertyOrder = ((OwCMISNativeSession)this.getSession()).getNetwork().getNetworkConfiguration().getPreferedPropertyOrder();
                map = orderedClasses = new OwCMISPropertySorter(preferredPropertyOrder).reorderProperties(classes);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return map;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISPropertyClass<?> findPropertyClass(String className_p) {
        OwCMISPropertyClass<Object> propertyClass = this.getNativePropertyClass(className_p);
        if (propertyClass == null) {
            propertyClass = super.findPropertyClass(className_p);
        }
        return propertyClass;
    }

    @Override
    public OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> getNativePropertyClass(String className_p) {
        OwCMISQualifiedName qName = new OwCMISQualifiedName(className_p);
        OwCMISNativeSession session = (OwCMISNativeSession)this.getSession();
        OwCMISNativePropertyClassFactory propertyClassFactory = session.getNativePropertyClassFactory();
        Map propertyDefinitions = this.objectType.getPropertyDefinitions();
        PropertyDefinition definition = null;
        if (propertyDefinitions != null) {
            definition = (PropertyDefinition)propertyDefinitions.get(qName.getName());
        }
        OwObjectClass parent = this.getParent();
        if (this.getClassName().equals(qName.getNamespace()) && definition != null) {
            try {
                return propertyClassFactory.createPropertyClass(className_p, definition, this);
            }
            catch (OwException e) {
                LOG.error((Object)("Could not create property class " + className_p), (Throwable)e);
                return null;
            }
        }
        if (qName.getNamespace() == null && definition != null && !definition.isInherited().booleanValue()) {
            try {
                return propertyClassFactory.createPropertyClass(className_p, definition, this);
            }
            catch (OwException e) {
                LOG.error((Object)("Could not create property class " + className_p), (Throwable)e);
                return null;
            }
        }
        if (parent != null) {
            return parent.getNativePropertyClass(className_p);
        }
        return null;
    }

    @Override
    public OwCMISNativeObjectClass<T, O> getParent() {
        if (this.objectType.getParentTypeId() != null) {
            try {
                return ((OwCMISNativeSession)this.getSession()).getNativeObjectClass(this.objectType.getParentTypeId());
            }
            catch (OwException e) {
                LOG.error((Object)("Could not retrieve parent class of " + this.getClassName()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String createNewObject(boolean promote_p, Object mode_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String mimeType_p, String mimeParameter_p, boolean keepCheckedOut_p) throws OwException {
        boolean bl = promote_p;
        Object object = mode_p;
        OwPropertyCollection owPropertyCollection = properties_p;
        OwPermissionCollection owPermissionCollection = permissions_p;
        OwContentCollection owContentCollection = content_p;
        OwObject owObject = parent_p;
        String string = mimeType_p;
        String string2 = mimeParameter_p;
        boolean bl2 = keepCheckedOut_p;
        try {
            String string3;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                ObjectId nativeParent = this.getNativeParentFromObject(parent_p);
                Map<String, Object> cmisProperties = this.convertToNativeProperties(properties_p);
                OwCMISContentFactory contentFactory = new OwCMISContentFactory((OwCMISNativeSession)this.getSession());
                ContentStream contentStream = contentFactory.createContentStream(content_p);
                if (!cmisProperties.containsKey("cmis:objectTypeId")) {
                    OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> objectTypeIdPropClass = this.getNativePropertyClass("cmis:objectTypeId");
                    OwCMISNativeProperty<Object, ?> objectTypeIdProp = objectTypeIdPropClass.from(this.getClassName());
                    Property<?> nativeProp = objectTypeIdProp.getNativeObject();
                    cmisProperties.put(nativeProp.getId(), nativeProp.getValue());
                }
                List<Policy> policies = null;
                List<Ace> addAce = null;
                List<Ace> removeAce = null;
                if (permissions_p != null) {
                    OwCMISPermissionCollection perms = (OwCMISPermissionCollection)permissions_p;
                    OwCMISAclDiff diff = perms.getDiff();
                    addAce = diff.getAdded();
                    removeAce = diff.getDeleted();
                }
                ObjectId newId = this.createNativeObject(cmisProperties, nativeParent, contentStream, promote_p, keepCheckedOut_p, policies, addAce, removeAce);
                string3 = newId.getId();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return string3;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl), object, owPropertyCollection, owPermissionCollection, owContentCollection, owObject, string, string2, Conversions.booleanObject((boolean)bl2)};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ObjectId getNativeParentFromObject(OwObject parent_p) throws OwException {
        OwObject owObject = parent_p;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                TransientFolder nativeParentFolder = null;
                if (parent_p != null) {
                    if (!(parent_p instanceof OwCMISNativeObject)) {
                        String msg = "Unsupported/Invalid parent type provided, ow java-class = " + parent_p.getClass();
                        LOG.warn((Object)msg);
                        throw new OwInvalidOperationException(msg);
                    }
                    OwCMISNativeObject parent = (OwCMISNativeObject)parent_p;
                    Object natObj = parent.getNativeObject();
                    if (natObj instanceof TransientFolder) {
                        nativeParentFolder = (TransientFolder)natObj;
                    } else {
                        String msg = "Invalid parent type provided, native java-class = " + (natObj != null ? natObj.getClass() : "null");
                        LOG.warn((Object)msg);
                        throw new OwInvalidOperationException(msg);
                    }
                }
                TransientFolder transientFolder = nativeParentFolder;
                return transientFolder;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
        }
        catch (CmisBaseException cmisBaseException) {
            if (OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) throw cmisBaseException;
            OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)owObject));
            throw cmisBaseException;
        }
    }

    protected abstract ObjectId createNativeObject(Map<String, Object> var1, ObjectId var2, ContentStream var3, boolean var4, boolean var5, List<Policy> var6, List<Ace> var7, List<Ace> var8);

    @Override
    public Map<String, Object> convertToNativeProperties(OwPropertyCollection properties_p) throws OwException {
        OwPropertyCollection owPropertyCollection = properties_p;
        try {
            HashMap<String, Object> hashMap;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                HashMap<String, Object> cmisProperties = new HashMap<String, Object>();
                if (properties_p != null) {
                    Set entries = properties_p.entrySet();
                    for (Map.Entry entry : entries) {
                        OwProperty property = (OwProperty)entry.getValue();
                        Property<?> cmisProperty = this.convertToNativeProperty(property);
                        if (cmisProperty == null) continue;
                        cmisProperties.put(cmisProperty.getId(), cmisProperty.getValue());
                    }
                }
                hashMap = cmisProperties;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return hashMap;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)owPropertyCollection));
            }
            throw cmisBaseException;
        }
    }

    private Property<?> convertToNativeProperty(OwProperty property) throws OwException, OwInvalidOperationException {
        OwProperty owProperty = property;
        try {
            Object object;
            block14: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    Object cmisProperty = null;
                    if (property instanceof OwCMISNativeProperty) {
                        OwCMISNativeProperty nativeProperty = (OwCMISNativeProperty)property;
                        cmisProperty = nativeProperty.getNativeObject();
                    } else {
                        if (property instanceof OwCMISBoundVirtualProperty) {
                            OwCMISBoundVirtualProperty boundProperty = (OwCMISBoundVirtualProperty)property;
                            OwCMISProperty innerProperty = boundProperty.getBoundProperty();
                            if (innerProperty instanceof OwCMISBoundVirtualProperty) {
                                throw new OwInvalidOperationException("This is way too much for me to handle.");
                            }
                            object = this.convertToNativeProperty(innerProperty);
                            break block14;
                        }
                        OwPropertyClass propertyClass = null;
                        try {
                            propertyClass = property.getPropertyClass();
                            OwCMISNativePropertyClass<?, ?, PropertyDefinition<?>> nativePropertyClass = this.getNativePropertyClass(propertyClass.getClassName());
                            if (nativePropertyClass != null) {
                                OwCMISNativeProperty<Object, ?> nativeProperty = nativePropertyClass.from(property.getValue());
                                cmisProperty = nativeProperty.getNativeObject();
                            }
                        }
                        catch (OwException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new OwInvalidOperationException("Could not convert properties. PropertyClass = " + (propertyClass != null ? propertyClass.getClassName() : "null"), (Throwable)e);
                        }
                    }
                    object = cmisProperty;
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return object;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)owProperty));
            }
            throw cmisBaseException;
        }
    }

    protected OperationContext createContext(Map<String, ?> conversionParameters) {
        OperationContext creationContext = null;
        if (conversionParameters != null) {
            creationContext = (OperationContext)conversionParameters.get("cmis.object.creation.context");
        }
        if (creationContext == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            LOG.warn((Object)("Creating default OperationContext because of null creation-OperationContext in call stack " + Arrays.asList(stackTrace)));
            creationContext = ((OwCMISNativeSession)this.getSession()).getOpenCMISSession().createOperationContext();
        }
        return creationContext;
    }

    @Override
    public List<OwCMISObjectClass> getChilds(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p) throws OwException {
        OwNetwork owNetwork = network_p;
        boolean bl = fExcludeHiddenAndNonInstantiable_p;
        try {
            LinkedList<OwCMISObjectClass> linkedList;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                LinkedList<OwCMISObjectClass> children = new LinkedList<OwCMISObjectClass>();
                ItemIterable itemIt = this.getNativeObject().getChildren();
                for (ObjectType type : itemIt) {
                    children.add(((OwCMISNativeSession)this.getSession()).getObjectClass(type.getId()));
                }
                linkedList = children;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return linkedList;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)owNetwork, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public <N extends TransientCmisObject> OwCMISTransientObject<N> newTransientObject(N cmisObject, OperationContext creationContext) {
        return new OwCMISBulkTransientObject<N>(cmisObject, creationContext, ((OwCMISNativeSession)this.getSession()).getOpenCMISSession());
    }

    @Override
    public OwCMISQueryResultConverter<O> getQueryResultConverter(QueryResult queryResult, OwQueryStatement statement, OperationContext context) throws OwException {
        QueryResult queryResult2 = queryResult;
        OwQueryStatement owQueryStatement = statement;
        OperationContext operationContext = context;
        try {
            OwCMISQueryResultConverterImpl owCMISQueryResultConverterImpl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISQueryResultConverterImpl = new OwCMISQueryResultConverterImpl(((OwCMISNativeSession)this.getSession()).getOpenCMISSession());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISQueryResultConverterImpl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{queryResult2, owQueryStatement, operationContext};
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwObjectSkeleton createSkeletonObject(OwNetwork network_p, OwCMISResource res_p, OwCMISNativeSession ses_p, OwXMLUtil initValues_p) throws Exception {
        return new OwCMISRepositoryObjectSkeleton(network_p, this, res_p, ses_p, initValues_p);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAbstractNativeObjectClass.java", OwCMISAbstractNativeObjectClass.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canCreateNewObject", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 188);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyClasses", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Map"), 200);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNativePropertyClasses", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "boolean", "localOnly_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Map"), 208);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createNewObject", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "boolean:java.lang.Object:com.wewebu.ow.server.ecm.OwPropertyCollection:com.wewebu.ow.server.ecm.OwPermissionCollection:com.wewebu.ow.server.ecm.OwContentCollection:com.wewebu.ow.server.ecm.OwObject:java.lang.String:java.lang.String:boolean", "promote_p:mode_p:properties_p:permissions_p:content_p:parent_p:mimeType_p:mimeParameter_p:keepCheckedOut_p", "com.wewebu.ow.server.exceptions.OwException", "java.lang.String"), 370);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNativeParentFromObject", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "com.wewebu.ow.server.ecm.OwObject", "parent_p", "com.wewebu.ow.server.exceptions.OwException", "org.apache.chemistry.opencmis.client.api.ObjectId"), 408);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertToNativeProperties", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "com.wewebu.ow.server.ecm.OwPropertyCollection", "properties_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.Map"), 453);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertToNativeProperty", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "com.wewebu.ow.server.ecm.OwProperty", "property", "com.wewebu.ow.server.exceptions.OwException:com.wewebu.ow.server.exceptions.OwInvalidOperationException", "org.apache.chemistry.opencmis.client.api.Property"), 473);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChilds", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "com.wewebu.ow.server.ecm.OwNetwork:boolean", "network_p:fExcludeHiddenAndNonInstantiable_p", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 538);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryResultConverter", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISAbstractNativeObjectClass", "org.apache.chemistry.opencmis.client.api.QueryResult:com.wewebu.ow.csqlc.ast.OwQueryStatement:org.apache.chemistry.opencmis.client.api.OperationContext", "queryResult:statement:context", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISQueryResultConverter"), 558);
    }
}

