/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.permission;

import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.permission.OwCMISPrivilege;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.chemistry.opencmis.commons.data.Ace;

public class OwCMISPrivilegeSet
implements OwPrivilegeSet {
    public static final int INHERITANCE_DEPTH_PROPAGATED = 100;
    private Ace ace;
    private OwUserInfo principal;

    public OwCMISPrivilegeSet(OwUserInfo principal, Ace ace) {
        this.ace = ace;
        this.principal = principal;
    }

    public OwUserInfo getPrincipal() {
        return this.principal;
    }

    public boolean isDenied() {
        return false;
    }

    public Collection getPrivileges() {
        LinkedList<OwCMISPrivilege> privileges = new LinkedList<OwCMISPrivilege>();
        for (String name : this.ace.getPermissions()) {
            privileges.add(new OwCMISPrivilege(this.ace, name));
        }
        return privileges;
    }

    public int getInheritanceDepth() {
        return this.ace.isDirect() ? 0 : -1;
    }

    public Ace nativeObject() {
        return this.ace;
    }

    public int hashCode() {
        int result = this.ace.isDirect() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        result = 811 * result + this.ace.getPrincipalId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OwCMISPrivilegeSet other = (OwCMISPrivilegeSet)obj;
        if (this.ace == null) {
            if (other.ace != null) {
                return false;
            }
        } else {
            if (!this.principal.getUserID().equals(other.principal.getUserID())) {
                return false;
            }
            if (this.ace.isDirect() != other.ace.isDirect()) {
                return false;
            }
            if (this.ace.getPermissions().size() != other.ace.getPermissions().size()) {
                return false;
            }
        }
        return true;
    }
}

