/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.propertyclass;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNativeSession;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.converter.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.objectclass.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISNativePropertyImpl;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractPropertyClass;
import com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwStandardEnum;
import com.wewebu.ow.server.field.OwStandardEnumCollection;
import com.wewebu.ow.server.util.OwString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class OwCMISAbstractNativePropertyClass<O, N, P extends PropertyDefinition<N>>
extends OwCMISAbstractPropertyClass<O, OwCMISNativeObjectClass<?, ?>>
implements OwCMISNativePropertyClass<O, N, P> {
    private static final Logger LOG;
    private static final List<String> NAME_PROPERTIES;
    private P propertyDefinition;
    private OwCMISValueConverter<N, O> converter;
    private Class<O> javaClass;
    private Collection<Integer> operators;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        OwCMISAbstractNativePropertyClass.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISAbstractNativePropertyClass.class);
        NAME_PROPERTIES = new ArrayList<String>();
        NAME_PROPERTIES.add("cmis:name");
        NAME_PROPERTIES.add("bpm:description");
    }

    public OwCMISAbstractNativePropertyClass(String className, P propertyDefinition, OwCMISValueConverter<N, O> converter, Class<O> javaClass, Collection<Integer> operators, OwCMISNativeObjectClass<?, ?> objectClass) {
        super(className, objectClass);
        this.propertyDefinition = propertyDefinition;
        this.converter = converter;
        this.javaClass = javaClass;
        this.operators = operators;
    }

    public final Collection<Integer> getOperators() throws OwException {
        try {
            Collection<Integer> collection;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                collection = this.operators;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return collection;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    protected OwCMISValueConverter<N, O> getConverter() {
        return this.converter;
    }

    protected Property<N> newProperty(List<N> nativeValues_p) {
        OwCMISNativeSession session = ((OwCMISNativeObjectClass)this.getObjectClass()).getSession();
        Session nativeSession = session.getOpenCMISSession();
        ObjectFactory objectFactory = nativeSession.getObjectFactory();
        return objectFactory.createProperty(this.getNativeType(), nativeValues_p);
    }

    @Override
    public OwCMISNativeProperty<O, N> from(O ... value_p) throws OwException {
        O[] OArray = value_p;
        try {
            OwCMISNativePropertyImpl owCMISNativePropertyImpl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                List<Object> nativeValues = new LinkedList();
                if (value_p != null) {
                    if (this.isArray()) {
                        nativeValues = 1 == value_p.length ? this.converter.fromArrayValue((Object[])value_p[0]) : this.converter.fromArrayValue(value_p);
                    } else {
                        Object singleValue = null;
                        if (value_p.length > 0) {
                            singleValue = value_p[0];
                        }
                        nativeValues = this.converter.fromValue(singleValue);
                    }
                }
                owCMISNativePropertyImpl = new OwCMISNativePropertyImpl(this, this.newProperty(nativeValues), this.converter);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativePropertyImpl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, OArray));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public OwCMISNativeProperty<O, N> from(Property<N> property_p) throws OwException {
        Property<N> property = property_p;
        try {
            OwCMISNativePropertyImpl<O, N> owCMISNativePropertyImpl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (property_p == null) {
                    property_p = this.newProperty(new LinkedList());
                }
                owCMISNativePropertyImpl = new OwCMISNativePropertyImpl<O, N>(this, property_p, this.converter);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISNativePropertyImpl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, property));
            }
            throw cmisBaseException;
        }
    }

    public Object getDefaultValue() throws OwException {
        try {
            Object object;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                List nativeDefault = this.getNativeType().getDefaultValue();
                object = this.isArray() ? this.converter.toArrayValue(nativeDefault) : this.converter.toValue(nativeDefault);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return object;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public boolean isSystem() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = this.propertyDefinition.getUpdatability().equals((Object)Updatability.READONLY);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public boolean isNameProperty() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = NAME_PROPERTIES.contains(this.propertyDefinition.getId());
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public boolean isReadOnly(int context_p) throws OwException {
        int n = context_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                switch (this.propertyDefinition.getUpdatability()) {
                    case READONLY: {
                        bl = true;
                        break;
                    }
                    case READWRITE: {
                        bl = false;
                        break;
                    }
                    case WHENCHECKEDOUT: {
                        if (context_p != 2) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case ONCREATE: {
                        if (context_p != 1) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw cmisBaseException;
        }
    }

    public String getDisplayName(Locale locale_p) {
        return OwString.localizeLabel((Locale)locale_p, (String)this.getClassName(), (String)this.propertyDefinition.getDisplayName());
    }

    public String getDescription(Locale locale_p) {
        return OwString.localizeLabel((Locale)locale_p, (String)(String.valueOf(this.getClassName()) + ".Desc"), (String)this.propertyDefinition.getDescription());
    }

    @Override
    public P getNativeType() {
        return this.propertyDefinition;
    }

    public boolean isRequired() throws OwException {
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                Boolean val = this.propertyDefinition.isRequired();
                if (val != null) {
                    bl = val;
                } else {
                    LOG.warn((Object)("Undefined isRequired state for propDef = " + this.propertyDefinition.getId()));
                    bl = false;
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    @Override
    public boolean isArray() {
        return Cardinality.MULTI.equals((Object)this.propertyDefinition.getCardinality());
    }

    @Override
    public String getNonQualifiedName() {
        return this.propertyDefinition.getId();
    }

    @Override
    public String getQueryName() {
        return this.propertyDefinition.getQueryName();
    }

    @Override
    public boolean isQueryable() {
        Boolean val = this.propertyDefinition.isQueryable();
        if (val != null) {
            return val;
        }
        LOG.warn((Object)("Undefined isQueryable state for propDef = " + this.propertyDefinition.getId()));
        return false;
    }

    @Override
    public boolean isOrderable() {
        Boolean val = this.propertyDefinition.isOrderable();
        if (val != null) {
            return val;
        }
        LOG.warn((Object)("Undefined isOrderable state for propDef = " + this.propertyDefinition.getId()));
        return false;
    }

    @Override
    public OwEnumCollection getEnums() throws OwException {
        try {
            OwStandardEnumCollection owStandardEnumCollection;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                List nativeChoices = this.getNativeType().getChoices();
                OwStandardEnumCollection enumCollection = new OwStandardEnumCollection();
                if (nativeChoices != null) {
                    for (Choice choice : nativeChoices) {
                        List nativeChoiceValue = choice.getValue();
                        Object value = null;
                        value = this.converter.toValue(nativeChoiceValue);
                        String localizeKey = this.getFullQualifiedName() + "." + choice.getDisplayName();
                        OwStandardEnum stdEnum = new OwStandardEnum(value, choice.getDisplayName(), localizeKey);
                        enumCollection.add((Object)stdEnum);
                    }
                }
                owStandardEnumCollection = enumCollection;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owStandardEnumCollection;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this));
            }
            throw cmisBaseException;
        }
    }

    public final String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public boolean isHidden(int iContext_p) throws OwException {
        int n = iContext_p;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                bl = false;
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.intObject((int)n)));
            }
            throw cmisBaseException;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("class(native,");
        builder.append(this.getClassName());
        builder.append(",");
        builder.append(this.getClass().getSimpleName());
        String hiddenString = "<err-hidden-status>";
        try {
            hiddenString = this.isHidden(2) ? "hidden" : "visible";
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve the hidden status of the class !", (Throwable)e);
        }
        builder.append(",");
        builder.append(hiddenString);
        builder.append(",queryable=");
        builder.append(this.isQueryable());
        builder.append(")");
        return builder.toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISAbstractNativePropertyClass.java", OwCMISAbstractNativePropertyClass.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getOperators", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.util.Collection"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "from", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "[Ljava.lang.Object;", "value_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISNativeProperty"), 95);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "from", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "org.apache.chemistry.opencmis.client.api.Property", "property_p", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecmimpl.opencmis.property.OwCMISNativeProperty"), 127);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultValue", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "java.lang.Object"), 137);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSystem", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 151);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isNameProperty", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 160);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "int", "context_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 166);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isRequired", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 207);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEnums", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "", "", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.field.OwEnumCollection"), 270);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHidden", "com.wewebu.ow.server.ecmimpl.opencmis.propertyclass.OwCMISAbstractNativePropertyClass", "int", "iContext_p", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 298);
    }
}

