/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.ui.acl;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwInsertLabelHelper;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeEditorDocument;
import com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISRestrictedUserSelectDialog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OwCMISPrivilegeSetEditor
extends OwStandardDialog
implements OwDialog.OwDialogListener {
    private static final Logger LOG;
    public static final String CHOICE = "owrolerecent";
    public static final String ROW_IDX = "rowIdx";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        OwCMISPrivilegeSetEditor.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISPrivilegeSetEditor.class);
    }

    protected void init() throws Exception {
        super.init();
        this.setTitle(this.getContext().localize("opencmis.ui.acl.OwCMISPrivilegeSetEditor.title", "Privilege Editor"));
        if (this.getDocument().getSelectedPrincipal() != null) {
            this.processSelection();
        }
    }

    protected OwUserSelectDialog createOwUserSelectDialog(int[] filter, boolean multiSelect) throws OwException {
        int[] nArray = filter;
        boolean bl = multiSelect;
        try {
            OwUserSelectDialog owUserSelectDialog;
            block11: {
                OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
                try {
                    OwRoleManagerContext roleCtx = (OwRoleManagerContext)this.getContext().getRegisteredInterface(OwRoleManagerContext.class);
                    if (roleCtx != null) {
                        block10: {
                            OwNetwork network = roleCtx.getNetwork();
                            try {
                                if (!network.canUserSelect()) break block10;
                                owUserSelectDialog = new OwUserSelectDialog(filter, multiSelect);
                                break block11;
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Could not evaluate user selection of network", (Throwable)e);
                                throw new OwServerException(this.getContext().localize("opencmis.ui.acl.OwCMISPrivilegeSetEditor.createOwUserSelectDialog.error", "Evaluation of user selection failed."), (Throwable)e);
                            }
                        }
                        Session ses = this.getDocument().getPermissions().getSession();
                        owUserSelectDialog = new OwCMISRestrictedUserSelectDialog(ses.getRepositoryInfo());
                        break block11;
                    }
                    throw new OwServerException("Editor was not initialised or missing reference to current context");
                }
                finally {
                    OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
                }
            }
            return owUserSelectDialog;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)nArray, (Object)Conversions.booleanObject((boolean)bl)));
            }
            throw cmisBaseException;
        }
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        if (iRegion_p != 2) {
            super.renderRegion(w_p, iRegion_p);
        } else if (this.isRegion(2)) {
            super.renderRegion(w_p, iRegion_p);
        } else {
            this.renderMainRegion(w_p);
        }
    }

    protected void renderMainRegion(Writer w_p) throws Exception, IOException {
        OwCMISPrivilegeEditorDocument doc = this.getDocument();
        w_p.write("<div class=\"OwCMISPrivilegeSetEditor\">");
        w_p.write("<div class=\"OwInlineMenu\"><script type=\"text/javascript\">");
        w_p.write(" function changePrincipal() {\n");
        w_p.write("  var value = \"");
        w_p.write(CHOICE);
        w_p.write("=\" + arguments[1].id;\n");
        w_p.write("  window.location.href=\"");
        w_p.write(this.getEventURL("PrincipalChanged", ""));
        w_p.write("\" + value;\n}</script>\n");
        OwDefaultComboModel recentRolesModel = new OwDefaultComboModel(false, false, doc.getSelectedPrincipal(), this.createComboItemList(doc.getPrincipalSelection()));
        OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer((OwComboModel)recentRolesModel, CHOICE, null, null, null);
        renderer.addEvent("onchange", "changePrincipal()");
        String changePrincipalDisplayName = this.getContext().localize("OwCMISPrivilegeSetEditor.changePrincipalRole", "Change Principal Role");
        OwInsertLabelHelper.insertLabelValue((Writer)w_p, (String)changePrincipalDisplayName, (String)CHOICE);
        renderer.renderCombo(w_p);
        if (this.getDocument().getModifySets() == null) {
            w_p.write("<div class=\"UserSelectionButton\">");
            w_p.write("<input type=\"button\" value=\"");
            w_p.write(this.getContext().localize("opencmis.ui.acl.OwCMISPrivilegeSetEditor.btn.userSelect", "Select Principal"));
            w_p.write("\" onclick=\"");
            w_p.write(this.getFormEventFunction("OpenUserSelection", null));
            w_p.write("\" /></div>");
        }
        w_p.write("</div>\n");
        w_p.write("<div class=\"Privileges\">\n");
        this.renderMainContent(w_p, doc.getRenderList(), doc.getSelectedList());
        w_p.write("</div>");
        w_p.write("</div>");
    }

    protected void renderMainContent(Writer w_p, List<OwPrivilege> render, List<OwPrivilege> selected) throws Exception, IOException {
        if (render != null && !render.isEmpty()) {
            w_p.write("<table class=\"OwGeneralList_table\"><thead><tr><th></th><th width=\"99%\">");
            w_p.write(OwString.localizeLabel((Locale)this.getContext().getLocale(), (String)"Ace(s)"));
            w_p.write("</th></thead><tbody>");
            Iterator<OwPrivilege> it = render.iterator();
            int i = 0;
            while (it.hasNext()) {
                OwPrivilege row = it.next();
                w_p.write("<tr class=\"");
                w_p.write(i % 2 == 0 ? "EvenRow" : "OddRow");
                w_p.write("\"><td><input type=\"checkbox\" value=\"");
                w_p.write(Integer.toString(i));
                w_p.write("\" name=\"");
                w_p.write(ROW_IDX);
                w_p.write("\"");
                if (selected.contains(row)) {
                    w_p.write(" checked ");
                }
                w_p.write("/></td><td>");
                w_p.write(OwString.localizeLabel((Locale)this.getContext().getLocale(), (String)row.getName()));
                w_p.write("</td></tr>\n");
                ++i;
            }
            w_p.write("</tbody></table>");
            w_p.write("<div class=\"SaveBtn\">");
            w_p.write("<input type=\"button\" value=\"");
            w_p.write(this.getContext().localize("opencmis.ui.acl.OwCMISPrivilegeSetEditor.btn.save", "Save"));
            w_p.write("\" onclick=\"");
            w_p.write(this.getFormEventFunction("Save", null));
            w_p.write("\" /></div>");
        }
    }

    public OwCMISPrivilegeEditorDocument getDocument() {
        return (OwCMISPrivilegeEditorDocument)super.getDocument();
    }

    protected void processSelection() throws OwException {
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwCMISPrivilegeEditorDocument doc = this.getDocument();
                LinkedList<Object> renderLst = new LinkedList<OwPrivilege>();
                LinkedList<OwPrivilege> selected = new LinkedList<OwPrivilege>();
                if (doc.getModifySets() == null) {
                    if (doc.getSelectedPrincipal() != null) {
                        OwUserInfo usr = this.createUserInfo(doc.getSelectedPrincipal());
                        renderLst = new LinkedList(doc.getPermissions().getAvailablePrivileges(usr));
                    }
                } else if (doc.getSelectedPrincipal() != null) {
                    for (OwPrivilegeSet set : doc.getPermissions().getAppliedPrivilegeSets()) {
                        try {
                            if (!doc.getSelectedPrincipal().equals(set.getPrincipal().getUserName()) || set.getInheritanceDepth() != 0) continue;
                            selected.addAll(set.getPrivileges());
                        }
                        catch (OwException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Could not retrieve user name from PrivilegeSet, class = " + set.getClass() + " principal = " + set.getPrincipal()), (Throwable)e);
                            throw new OwServerException("Cannot evaluate principal object", (Throwable)e);
                        }
                    }
                    renderLst = new LinkedList(doc.getPermissions().getAvailablePrivileges(null));
                }
                doc.setRenderList(renderLst);
                doc.setSelectedList(selected);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this)));
            }
            throw cmisBaseException;
        }
    }

    public void onPrincipalChanged(HttpServletRequest req) throws OwException {
        HttpServletRequest httpServletRequest = req;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                this.getDocument().setSelectedPrincipal(req.getParameter(CHOICE));
                this.processSelection();
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest));
            }
            throw cmisBaseException;
        }
    }

    public void onOpenUserSelection(HttpServletRequest req) throws OwException {
        HttpServletRequest httpServletRequest = req;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwUserSelectDialog usrDlg = this.createOwUserSelectDialog(new int[]{2, 1}, false);
                try {
                    this.getContext().openDialog((OwDialog)usrDlg, (OwDialog.OwDialogListener)this);
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot open user selection dialog", (Throwable)e);
                    throw new OwServerException("Failed to open User selection dialog.", (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest));
            }
            throw cmisBaseException;
        }
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        if (dialogView_p instanceof OwUserSelectDialog) {
            OwUserSelectDialog dlg = (OwUserSelectDialog)dialogView_p;
            if (dlg.getSelectedUsers() != null && !dlg.getSelectedUsers().isEmpty()) {
                OwUserInfo usr = (OwUserInfo)dlg.getSelectedUsers().get(0);
                this.getDocument().setSelectedPrincipal(usr.getUserName());
                this.processSelection();
            } else if (dlg.getSelectedRoles() != null && !dlg.getSelectedRoles().isEmpty()) {
                String role = (String)dlg.getSelectedRoles().get(0);
                this.getDocument().setSelectedPrincipal(role);
                this.processSelection();
            }
        }
    }

    public void onSave(HttpServletRequest req) throws OwException {
        HttpServletRequest httpServletRequest = req;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                String[] arr = req.getParameterValues(ROW_IDX);
                if (arr != null) {
                    List<OwPrivilege> avlst = this.getDocument().getRenderList();
                    List<OwPrivilege> currentSelected = this.getDocument().getSelectedList();
                    LinkedList<OwPrivilege> newSelection = new LinkedList<OwPrivilege>();
                    LinkedList<OwPrivilege> deleted = new LinkedList<OwPrivilege>(currentSelected);
                    String[] stringArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String idx = stringArray[n2];
                        OwPrivilege a = avlst.get(Integer.valueOf(idx));
                        deleted.remove(a);
                        newSelection.add(a);
                        ++n2;
                    }
                    OwUserInfo usr = this.createUserInfo(this.getDocument().getSelectedPrincipal());
                    if (this.getDocument().getModifySets() == null) {
                        this.getDocument().getPermissions().addPrivilegeSet(usr, newSelection, false, 0);
                    } else {
                        Iterator<OwPrivilegeSet> it = this.getDocument().getModifySets().iterator();
                        OwPrivilegeSet set = null;
                        while (it.hasNext()) {
                            OwPrivilegeSet next = it.next();
                            try {
                                if (!usr.getUserName().equals(next.getPrincipal().getUserName())) continue;
                                set = next;
                                it.remove();
                                break;
                            }
                            catch (OwException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot compare the user name", (Throwable)e);
                                throw new OwServerException("Faild to get current edited PrivilegeSet object", (Throwable)e);
                            }
                        }
                        if (set != null) {
                            this.getDocument().getPermissions().removePrivilegeSet(set);
                            set = this.getDocument().getPermissions().addPrivilegeSet(usr, newSelection, false, 0);
                            this.getDocument().getModifySets().add(set);
                        }
                    }
                    this.getDocument().setSelectedList(newSelection);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest));
            }
            throw cmisBaseException;
        }
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected List<OwComboItem> createComboItemList(List<String> values) {
        LinkedList<OwComboItem> cmbItems = new LinkedList<OwComboItem>();
        if (values != null) {
            for (String value : values) {
                cmbItems.add((OwComboItem)new OwDefaultComboItem(value, value));
            }
        }
        return cmbItems;
    }

    protected OwUserInfo createUserInfo(String principalId) throws OwException {
        String string = principalId;
        try {
            OwCMISUserInfo owCMISUserInfo;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                owCMISUserInfo = new OwCMISUserInfo(principalId, null);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return owCMISUserInfo;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwCMISPrivilegeSetEditor.java", OwCMISPrivilegeSetEditor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createOwUserSelectDialog", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "[I:boolean", "filter:multiSelect", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.app.OwUserSelectDialog"), 79);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "processSelection", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "", "", "com.wewebu.ow.server.exceptions.OwException", "void"), 228);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onPrincipalChanged", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "javax.servlet.http.HttpServletRequest", "req", "com.wewebu.ow.server.exceptions.OwException", "void"), 282);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onOpenUserSelection", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "javax.servlet.http.HttpServletRequest", "req", "com.wewebu.ow.server.exceptions.OwException", "void"), 293);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onSave", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "javax.servlet.http.HttpServletRequest", "req", "com.wewebu.ow.server.exceptions.OwException", "void"), 338);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "createUserInfo", "com.wewebu.ow.server.ecmimpl.opencmis.ui.acl.OwCMISPrivilegeSetEditor", "java.lang.String", "principalId", "com.wewebu.ow.server.exceptions.OwException", "com.wewebu.ow.server.ecm.OwUserInfo"), 426);
    }
}

