/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.users;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.info.OwCMISLDAPUserInfo;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwGroup;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUser;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUserRepositoryException;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUserRole;
import com.wewebu.ow.server.ecmimpl.opencmis.users.OwUsersRepository;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwUsersRepositoryLDAP
implements OwUsersRepository {
    private static final Logger LOG = OwLog.getLogger(OwUsersRepositoryLDAP.class);
    private OwLdapConnector ldapConnector;

    public OwUsersRepositoryLDAP(OwLdapConnector ldapConnector) {
        this.ldapConnector = ldapConnector;
    }

    @Override
    public OwUserInfo findUserByID(String id) throws OwUserRepositoryException {
        try {
            OwUserInfo userInfo = null;
            try {
                userInfo = this.getLdapConnector().findUserByDNAnonymously(id);
            }
            catch (OwObjectNotFoundException owObjectNotFoundException) {}
            if (userInfo == null) {
                try {
                    userInfo = this.getLdapConnector().findUserByIdAnonymously(id);
                }
                catch (OwObjectNotFoundException owObjectNotFoundException) {}
            }
            if (userInfo == null) {
                userInfo = this.getLdapConnector().findUserByLoginAnonymously(id);
            }
            OwCMISLDAPUserInfo user = new OwCMISLDAPUserInfo(userInfo.getUserName(), this.getLdapConnector());
            return user;
        }
        catch (Exception owEx) {
            throw new OwUserRepositoryException(owEx);
        }
    }

    @Override
    public Set<OwGroup> findGroupsMatching(String pattern) throws OwUserRepositoryException {
        try {
            HashSet<OwGroup> result = new HashSet<OwGroup>();
            OwObjectCollection groups = this.getLdapConnector().findGroupsMatching(pattern);
            for (Object object : groups) {
                OwUserInfo groupInfo = (OwUserInfo)object;
                result.add(new OwGroup(groupInfo.getUserID(), groupInfo.getUserShortName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new OwUserRepositoryException(new OwString("opencmis.users.OwUserRepositoryLDAP.err_groupInfo", "Cannot retrieve GroupInformation"), (Throwable)e);
        }
    }

    @Override
    public Set<OwGroup> findGroupsForUserID(String userId) throws OwUserRepositoryException {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public OwObjectCollection findUsersMatching(String pattern) throws OwUserRepositoryException {
        if (!pattern.contains("*") && pattern.length() != 0) {
            pattern = "*" + pattern + "*";
        }
        try {
            OwObjectCollection dnames = this.getLdapConnector().findUserDNsMatching(pattern);
            OwStandardObjectCollection lst = new OwStandardObjectCollection();
            for (Object dname : dnames) {
                String displayName = this.getLdapConnector().getUserDisplayName((String)dname);
                String userLogin = this.getLdapConnector().getUserLogin((String)dname);
                if (displayName == null) {
                    LOG.warn((Object)("Could not get DisplayName for " + dname));
                    continue;
                }
                if (userLogin == null) {
                    LOG.warn((Object)("Could not get uid for " + dname));
                    continue;
                }
                lst.add((Object)new OwUser(userLogin, displayName, this));
            }
            lst.setComplete(dnames.isComplete());
            return lst;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception owEx) {
            throw new OwUserRepositoryException(owEx);
        }
    }

    @Override
    public Set<OwUserRole> findRolesMatching(String pattern) throws OwUserRepositoryException {
        try {
            HashSet<OwUserRole> result = new HashSet<OwUserRole>();
            OwObjectCollection groups = this.getLdapConnector().findGroupsMatching(pattern);
            for (Object object : groups) {
                OwUserInfo groupInfo = (OwUserInfo)object;
                result.add(new OwUserRole(groupInfo.getUserShortName(), groupInfo.getUserShortName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new OwUserRepositoryException(new OwString("opencmis.users.OwUserRepositoryLDAP.err_roleInfo", "Cannot retrieve RoleInformation"), (Throwable)e);
        }
    }

    public OwLdapConnector getLdapConnector() {
        return this.ldapConnector;
    }
}

