/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.viewer.info;

import com.wewebu.ow.server.ecmimpl.opencmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISObject;
import com.wewebu.ow.server.ui.viewer.OwAbstractInfoProvider;
import com.wewebu.ow.server.ui.viewer.OwDocInfoEnum;
import com.wewebu.ow.server.ui.viewer.OwInfoRequest;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwCMISInfoProvider
extends OwAbstractInfoProvider {
    private static final String APPLICATION_PDF_MIME = "application/pdf";
    private static final String IMAGE_TIFF_MIME = "image/tiff";
    private static final Logger LOG = OwLog.getLogger(OwCMISInfoProvider.class);
    private OwCMISNetwork network;
    private OwCMISObject obj;

    public OwCMISInfoProvider(OwCMISNetwork network_p) {
        this.network = network_p;
    }

    public String getContext() {
        return this.network.getDMSPrefix();
    }

    public void handleRequest(OwInfoRequest request_p, OutputStream answer_p) throws IOException {
        String dmsid = request_p.getParameter("dmsid");
        try {
            try {
                this.obj = (OwCMISObject)this.getNetwork().getObjectFromDMSID(dmsid, false);
                super.handleRequest(request_p, answer_p);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)("Object could not be retrieved by DMSID = " + dmsid), (Throwable)e);
                this.obj = null;
            }
        }
        finally {
            this.obj = null;
        }
    }

    protected String process(Node item_p) {
        Node sub = item_p.getFirstChild();
        String result = null;
        if (sub.getNodeType() == 3) {
            String nodeValue = sub.getNodeValue();
            try {
                switch (OwDocInfoEnum.getEnumFromName((String)nodeValue)) {
                    case HAS_PERM_TO_CHECKOUT: {
                        result = Boolean.FALSE.toString();
                        if (this.obj.hasVersionSeries() && !this.obj.getVersion().isCheckedOut(2)) {
                            boolean canCheckOut = this.obj.getVersion().canCheckout(2);
                            result = Boolean.toString(canCheckOut);
                        }
                        break;
                    }
                    case HAS_PERM_TO_CHECKIN: {
                        result = Boolean.FALSE.toString();
                        if (this.obj.hasVersionSeries() && this.obj.getVersion().isCheckedOut(2)) {
                            boolean canCheckIn = this.obj.getVersion().canCheckin(2);
                            result = Boolean.toString(canCheckIn);
                        }
                        break;
                    }
                    case HAS_PERM_TO_CANCEL_CHECKOUT: {
                        result = Boolean.FALSE.toString();
                        if (this.obj.hasVersionSeries() && this.obj.getVersion().isCheckedOut(2)) {
                            boolean canCancelCheckOut = this.obj.getVersion().canCancelcheckout(2) && this.obj.getVersion().isMyCheckedOut(2);
                            result = Boolean.toString(canCancelCheckOut);
                        }
                        break;
                    }
                    case HAS_PERM_TO_CREATE_ANNOTATIONS: {
                        result = Boolean.FALSE.toString();
                        break;
                    }
                    case NUMBER_OF_PARENTS: {
                        result = Integer.toString(this.obj.getParents().size());
                        break;
                    }
                    case HAS_PERM_TO_CREATE_DOCUMENT: {
                        result = "" + this.obj.getObjectClass().canCreateNewObject();
                        break;
                    }
                    case IS_CHECKOUT: {
                        result = Boolean.FALSE.toString();
                        if (this.obj.hasVersionSeries() && this.obj.getVersion().isCheckedOut(2)) {
                            result = Boolean.TRUE.toString();
                        }
                        break;
                    }
                    case IS_VERSIONABLE: {
                        result = Boolean.FALSE.toString();
                        if (this.obj.hasVersionSeries()) {
                            result = Boolean.TRUE.toString();
                        }
                        break;
                    }
                    case HAS_PERM_TO_MOD: {
                        result = Boolean.FALSE.toString();
                        String mimeType = this.obj.getMIMEType();
                        result = Boolean.valueOf(IMAGE_TIFF_MIME.equals(mimeType) || APPLICATION_PDF_MIME.equals(mimeType)).toString();
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot compute the value of the " + nodeValue + " property."), (Throwable)e);
            }
        }
        return result;
    }

    protected OwCMISNetwork getNetwork() {
        return this.network;
    }
}

