/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.opencmis.wd.service;

import com.wewebu.ow.server.app.OwGlobalParametersConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecmimpl.opencmis.aspects.OwCMISExceptionManagement;
import com.wewebu.ow.server.ecmimpl.opencmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISNativeObject;
import com.wewebu.ow.server.ecmimpl.opencmis.object.OwCMISRendition;
import com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwCMISRenditionService;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwRequestContext;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.service.rendition.OwConfigurableRenditionService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.alfresco.wd.ext.restlet.auth.OwRestletAuthenticationHandler;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class OwAlfrescoCMISRenditionService
extends OwCMISRenditionService
implements OwConfigurableRenditionService {
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIST = "list";
    private static final String TAG_KEY = "key";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_MAP = "map";
    private static final String TAG_PROPERTY = "property";
    private static final String SERVICE_URI = "/service/wd/webscript/rendition";
    private static final Logger LOG;
    private Map<String, List<String>> kindToThumbnailNames = new HashMap<String, List<String>>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        OwAlfrescoCMISRenditionService.ajc$preClinit();
        LOG = OwLog.getLogger(OwCMISRenditionService.class);
    }

    public OwMainAppContext getContext() {
        HttpServletRequest request_p = OwRequestContext.getLocalThreadRequest();
        HttpSession Session2 = request_p.getSession();
        OwMainAppContext context = (OwMainAppContext)Session2.getAttribute("ow_Context");
        return context;
    }

    public void createRendition(OwObject obj, String type) throws OwException {
        OwObject owObject = obj;
        String string = type;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                OwGlobalParametersConfiguration util = this.getContext().getConfiguration().getGlobalParameters();
                String baseUri = util.getSafeString("EcmBaseUrl", null);
                if (baseUri != null) {
                    String id = obj.getID();
                    Map<String, List<String>> map = this.getRenditionKindMapping();
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("title = " + entry.getKey()));
                            LOG.debug((Object)("kinds = " + entry.getValue()));
                        }
                        if (!entry.getKey().equals(type)) continue;
                        JSONObject json = new JSONObject();
                        boolean success = false;
                        for (String rnd : entry.getValue()) {
                            try {
                                json.put("ID", (Object)id);
                                json.put("REND_DEF", (Object)rnd);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("json = " + json.toString()));
                                }
                                this.renditionServicePost(baseUri, id, json);
                                success = true;
                            }
                            catch (JSONException e) {
                                LOG.warn((Object)"Unable to create JSON object", (Throwable)e);
                            }
                            catch (OwServerException es) {
                                LOG.warn((Object)"Failure to retrieve or create rendition.", (Throwable)es);
                            }
                        }
                        if (success) continue;
                        throw new OwServerException("All renditions have failed.");
                    }
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private void renditionServicePost(String baseUri, String id, JSONObject json) throws OwServerException {
        String connectionUrl = String.valueOf(baseUri) + SERVICE_URI;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ::renditionServicePost() [" + connectionUrl + "] " + json.toString()));
        }
        OwRestletAuthenticationHandler restletAuthenticationHandler = null;
        try {
            restletAuthenticationHandler = (OwRestletAuthenticationHandler)this.getContext().getNetwork().getInterface(OwRestletAuthenticationHandler.class.getCanonicalName(), null);
        }
        catch (Exception e) {
            throw new OwServerException("Failed to retrieve the OwRestletAuthenticationHandler.", (Throwable)e);
        }
        ClientResource cr = new ClientResource(connectionUrl);
        restletAuthenticationHandler.prepareCall(cr);
        try {
            try {
                JsonRepresentation jsonEntity = new JsonRepresentation(json);
                cr.post((Representation)jsonEntity);
            }
            catch (ResourceException re) {
                throw new OwServerException("Could not create rendition of type for object with ID: " + id, (Throwable)re);
            }
        }
        finally {
            Representation responseEntity = cr.getResponseEntity();
            if (responseEntity != null) {
                try {
                    responseEntity.exhaust();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                responseEntity.release();
            }
        }
    }

    public boolean canCreateRendition(OwObject obj, String type) throws OwException {
        OwObject owObject = obj;
        String string = type;
        try {
            boolean bl;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                try {
                    bl = obj.hasContent(2);
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OwInvalidOperationException("Could not check content.", (Throwable)e);
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return bl;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    private List<OwCMISRendition> getRenditions(OwObject obj, String filter) throws OwException {
        OwObject owObject = obj;
        String string = filter;
        try {
            List<OwCMISRendition> list;
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (filter == null) {
                    filter = "*";
                }
                OwCMISNativeObject cmisObject = (OwCMISNativeObject)obj;
                HashSet<String> renditions = new HashSet<String>();
                renditions.add(filter);
                list = cmisObject.retrieveRenditions(renditions, false);
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return list;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)owObject, (Object)string));
            }
            throw cmisBaseException;
        }
    }

    public void init(OwXMLUtil serviceXMLUtil) throws OwException {
        OwXMLUtil owXMLUtil = serviceXMLUtil;
        try {
            OwCMISExceptionManagement.ajc$cflowCounter$0.inc();
            try {
                if (LOG.isDebugEnabled()) {
                    String className = serviceXMLUtil.getSafeStringAttributeValue("class", null);
                    LOG.debug((Object)("Read mapping parameter for " + className));
                }
                try {
                    List props = serviceXMLUtil.getSafeUtilList(TAG_PROPERTY);
                    if (!props.isEmpty()) {
                        for (OwXMLUtil prop : props) {
                            OwXMLUtil map = prop.getSubUtil(TAG_MAP);
                            List entries = map.getSafeUtilList(TAG_ENTRY);
                            for (OwXMLUtil entry : entries) {
                                String key = entry.getSafeStringAttributeValue(TAG_KEY, null);
                                List values = entry.getSafeUtilList(TAG_LIST, TAG_VALUE);
                                LinkedList<String> valueslst = new LinkedList<String>();
                                for (OwXMLUtil value : values) {
                                    String strValues = value.getSafeTextValue(TAG_VALUE);
                                    valueslst.add(strValues);
                                }
                                this.kindToThumbnailNames.put(key, valueslst);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new OwConfigurationException("Unable to parse configuration, reading mapping");
                }
            }
            finally {
                OwCMISExceptionManagement.ajc$cflowCounter$0.dec();
            }
            return;
        }
        catch (CmisBaseException cmisBaseException) {
            if (!OwCMISExceptionManagement.ajc$cflowCounter$0.isValid()) {
                OwCMISExceptionManagement.aspectOf().ajc$afterThrowing$com_wewebu_ow_server_ecmimpl_opencmis_aspects_OwCMISExceptionManagement$1$74b69fe1(cmisBaseException, Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)owXMLUtil));
            }
            throw cmisBaseException;
        }
    }

    private Map<String, List<String>> getRenditionKindMapping() {
        return this.kindToThumbnailNames;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OwAlfrescoCMISRenditionService.java", OwAlfrescoCMISRenditionService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRendition", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwAlfrescoCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:type", "com.wewebu.ow.server.exceptions.OwException", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "canCreateRendition", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwAlfrescoCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:type", "com.wewebu.ow.server.exceptions.OwException", "boolean"), 215);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRenditions", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwAlfrescoCMISRenditionService", "com.wewebu.ow.server.ecm.OwObject:java.lang.String", "obj:filter", "com.wewebu.ow.server.exceptions.OwException", "java.util.List"), 231);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.wewebu.ow.server.ecmimpl.opencmis.wd.service.OwAlfrescoCMISRenditionService", "com.wewebu.ow.server.util.OwXMLUtil", "serviceXMLUtil", "com.wewebu.ow.server.exceptions.OwException", "void"), 245);
    }
}

