/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransientCmisObject
implements TransientCmisObject {
    protected Session session;
    protected CmisObject object;
    protected Map<String, Property<?>> properties;
    protected AllowableActions allowableActions;
    protected List<Rendition> renditions;
    protected Acl acl;
    protected Map<AclPropagation, List<AceChangeHolder>> addAces;
    protected Map<AclPropagation, List<AceChangeHolder>> removeAces;
    protected List<Policy> policies;
    protected Set<String> addPolicies;
    protected Set<String> removePolicies;
    protected List<Relationship> relationships;
    protected Map<ExtensionLevel, List<CmisExtensionElement>> inputExtensions;
    protected Map<ExtensionLevel, List<CmisExtensionElement>> ouputExtensions;
    protected boolean isModified;
    protected boolean isPropertyUpdateRequired;
    protected boolean isMarkedForDelete;
    protected boolean deleteAllVersions;

    protected void initialize(Session session, CmisObject object) {
        this.session = session;
        this.object = object;
        ObjectFactory of = this.getObjectFactory();
        this.properties = new LinkedHashMap();
        for (Property property : object.getProperties()) {
            this.properties.put(property.getId(), of.createProperty(property.getDefinition(), new ArrayList(property.getValues())));
        }
        this.isPropertyUpdateRequired = false;
        this.allowableActions = object.getAllowableActions();
        this.policies = new ArrayList<Policy>();
        if (object.getPolicies() != null) {
            this.policies.addAll(object.getPolicies());
        }
        this.addPolicies = new HashSet<String>();
        this.removePolicies = new HashSet<String>();
        this.acl = object.getAcl();
        this.addAces = new HashMap<AclPropagation, List<AceChangeHolder>>();
        this.removeAces = new HashMap<AclPropagation, List<AceChangeHolder>>();
        this.relationships = object.getRelationships();
        this.renditions = object.getRenditions();
        this.inputExtensions = new HashMap<ExtensionLevel, List<CmisExtensionElement>>();
        for (ExtensionLevel level : ExtensionLevel.values()) {
            List extension = object.getExtensions(level);
            if (extension == null) continue;
            this.inputExtensions.put(level, extension);
        }
        this.ouputExtensions = new HashMap<ExtensionLevel, List<CmisExtensionElement>>();
        this.isModified = false;
        this.deleteAllVersions = true;
        this.isMarkedForDelete = false;
    }

    public CmisObject getCmisObject() {
        return this.object;
    }

    protected Session getSession() {
        return this.session;
    }

    protected String getRepositoryId() {
        return this.getSession().getRepositoryInfo().getId();
    }

    protected CmisBinding getBinding() {
        return this.getSession().getBinding();
    }

    protected ObjectFactory getObjectFactory() {
        return this.getSession().getObjectFactory();
    }

    protected ObjectId getObjectId() {
        return this.getSession().createObjectId(this.getId());
    }

    public ObjectType getBaseType() {
        return this.object.getBaseType();
    }

    public BaseTypeId getBaseTypeId() {
        return this.object.getBaseTypeId();
    }

    public ObjectType getType() {
        return this.object.getType();
    }

    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    public String getId() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    public void setName(String name) {
        this.setPropertyValue("cmis:name", name);
    }

    public List<Property<?>> getProperties() {
        return Collections.unmodifiableList(new ArrayList(this.properties.values()));
    }

    public <T> Property<T> getProperty(String id) {
        return this.properties.get(id);
    }

    public <T> T getPropertyValue(String id) {
        Property<T> property = this.getProperty(id);
        if (property == null) {
            return null;
        }
        return (T)property.getValue();
    }

    public <T> void setPropertyValue(String id, Object value) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getType().getPropertyDefinitions().get(id);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Unknown property '" + id + "'!");
        }
        if (propertyDefinition.getUpdatability() == Updatability.READONLY) {
            throw new IllegalArgumentException("Property is read-only!");
        }
        List<T> values = AbstractTransientCmisObject.checkProperty(propertyDefinition, value);
        Property newProperty = this.getObjectFactory().createProperty(propertyDefinition, values);
        this.properties.put(id, newProperty);
        this.isPropertyUpdateRequired = true;
        this.isModified = true;
    }

    public AllowableActions getAllowableActions() {
        return this.allowableActions;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<Rendition> getRenditions() {
        return this.renditions;
    }

    public void delete(boolean allVersions) {
        this.deleteAllVersions = allVersions;
        this.isMarkedForDelete = true;
        this.isModified = true;
    }

    public void applyPolicy(Policy ... policyIds) {
        for (Policy policy : policyIds) {
            if (policy == null || policy.getId() == null) continue;
            this.addPolicies.add(policy.getId());
            this.addPolicyToPolicyList(policy);
        }
    }

    public void removePolicy(Policy ... policyIds) {
        for (Policy policy : policyIds) {
            if (policy == null || policy.getId() == null) continue;
            this.removePolicies.add(policy.getId());
            this.removePolicyFromPolicyList(policy);
        }
    }

    public List<Policy> getPolicies() {
        return this.policies;
    }

    private void addPolicyToPolicyList(Policy policy) {
        for (Policy p : this.policies) {
            if (!policy.getId().equals(p.getId())) continue;
            return;
        }
        this.policies.add(policy);
    }

    private void removePolicyFromPolicyList(Policy policy) {
        Iterator<Policy> iter = this.policies.iterator();
        while (iter.hasNext()) {
            Policy p = iter.next();
            if (!policy.getId().equals(p.getId())) continue;
            iter.remove();
        }
    }

    public Acl getOriginalAcl() {
        return this.acl;
    }

    public void addAce(String principalId, List<String> permissions, AclPropagation aclPropagation) {
        AceChangeHolder ach = new AceChangeHolder(principalId, permissions, aclPropagation);
        List<AceChangeHolder> list = this.addAces.get(aclPropagation);
        if (list == null) {
            list = new ArrayList<AceChangeHolder>();
            this.addAces.put(aclPropagation, list);
        }
        list.add(ach);
    }

    public void removeAce(String principalId, List<String> permissions, AclPropagation aclPropagation) {
        AceChangeHolder ach = new AceChangeHolder(principalId, permissions, aclPropagation);
        List<AceChangeHolder> list = this.removeAces.get(aclPropagation);
        if (list == null) {
            list = new ArrayList<AceChangeHolder>();
            this.removeAces.put(aclPropagation, list);
        }
        list.add(ach);
    }

    public List<CmisExtensionElement> getInputExtensions(ExtensionLevel level) {
        return this.inputExtensions.get(level);
    }

    public List<CmisExtensionElement> getOutputExtensions(ExtensionLevel level) {
        return this.ouputExtensions.get(level);
    }

    public void setOutputExtensions(ExtensionLevel level, List<CmisExtensionElement> extensions) {
        this.ouputExtensions.put(level, extensions);
    }

    public boolean isMarkedForDelete() {
        return this.isMarkedForDelete;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void reset() {
        this.initialize(this.session, this.object);
    }

    public void refreshAndReset() {
        this.object.refresh();
        this.reset();
    }

    public ObjectId save() {
        if (!this.isModified()) {
            return this.getObjectId();
        }
        String objectId = this.getId();
        if (this.saveDelete(objectId)) {
            return null;
        }
        String newObjectId = this.saveProperties(this.getId(), this.getChangeToken());
        this.saveACL(newObjectId);
        this.savePolicies(newObjectId);
        return this.getSession().createObjectId(newObjectId);
    }

    protected String getLatestChangeToken(String objectId) {
        PropertyDefinition objectIdPropDef = (PropertyDefinition)this.getCmisObject().getType().getPropertyDefinitions().get("cmis:objectId");
        if (objectIdPropDef == null) {
            return null;
        }
        String objectIdQueryName = objectIdPropDef.getQueryName();
        if (objectIdQueryName == null) {
            return null;
        }
        PropertyDefinition changeTokenPropDef = (PropertyDefinition)this.getCmisObject().getType().getPropertyDefinitions().get("cmis:changeToken");
        if (changeTokenPropDef == null) {
            return null;
        }
        String changeTokenQueryName = changeTokenPropDef.getQueryName();
        if (changeTokenQueryName == null) {
            return null;
        }
        Properties properties = this.getBinding().getObjectService().getProperties(this.getRepositoryId(), objectId, objectIdQueryName + "," + changeTokenQueryName, null);
        PropertyData changeToken = (PropertyData)properties.getProperties().get("cmis:changeToken");
        if (changeToken == null || changeToken.getFirstValue() == null) {
            return null;
        }
        return changeToken.getFirstValue().toString();
    }

    protected boolean saveDelete(String objectId) {
        if (this.isMarkedForDelete) {
            this.getBinding().getObjectService().deleteObject(this.getRepositoryId(), objectId, Boolean.valueOf(this.deleteAllVersions), null);
            return true;
        }
        return false;
    }

    protected Properties prepareProperties() {
        HashSet<Updatability> updatebility = new HashSet<Updatability>();
        updatebility.add(Updatability.READWRITE);
        Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
        if (isCheckedOut != null && isCheckedOut.booleanValue()) {
            updatebility.add(Updatability.WHENCHECKEDOUT);
        }
        Properties result = this.getObjectFactory().convertProperties(this.properties, this.getType(), updatebility);
        List<CmisExtensionElement> extensions = this.ouputExtensions.get(ExtensionLevel.PROPERTIES);
        if (extensions != null) {
            result.setExtensions(extensions);
        }
        return result;
    }

    protected String saveProperties(String objectId, String changeToken) {
        if (this.isPropertyUpdateRequired) {
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder changeTokenHolder = new Holder((Object)changeToken);
            Properties props = this.prepareProperties();
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, props, null);
            if (objectIdHolder.getValue() != null) {
                return (String)objectIdHolder.getValue();
            }
        }
        return objectId;
    }

    protected void savePolicies(String objectId) {
        for (String policyId : this.addPolicies) {
            this.getBinding().getPolicyService().applyPolicy(this.getRepositoryId(), policyId, objectId, null);
        }
        for (String policyId : this.removePolicies) {
            this.getBinding().getPolicyService().removePolicy(this.getRepositoryId(), policyId, objectId, null);
        }
    }

    protected Acl prepareAcl(List<AceChangeHolder> achList) {
        if (achList == null || achList.isEmpty()) {
            return null;
        }
        ObjectFactory of = this.getObjectFactory();
        ArrayList<Ace> aces = new ArrayList<Ace>();
        for (AceChangeHolder ach : achList) {
            aces.add(of.createAce(ach.getPrincipalId(), ach.getPermissions()));
        }
        return of.createAcl(aces);
    }

    protected void saveACL(String objectId) {
        for (AclPropagation ap : AclPropagation.values()) {
            if (!this.addAces.containsKey(ap) && !this.removeAces.containsKey(ap)) continue;
            this.getBinding().getAclService().applyAcl(this.getRepositoryId(), objectId, this.prepareAcl(this.addAces.get(ap)), this.prepareAcl(this.removeAces.get(ap)), ap, null);
        }
        if (this.addAces.containsKey(null) || this.removeAces.containsKey(null)) {
            this.getBinding().getAclService().applyAcl(this.getRepositoryId(), objectId, this.prepareAcl(this.addAces.get(null)), this.prepareAcl(this.removeAces.get(null)), null, null);
        }
    }

    private static <T> List<T> checkProperty(PropertyDefinition<T> propertyDefinition, Object value) {
        if (value == null) {
            return null;
        }
        List<Object> values = null;
        if (value instanceof List) {
            if (propertyDefinition.getCardinality() != Cardinality.MULTI) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a multi value property!");
            }
            values = (List<Object>)value;
            if (values.isEmpty()) {
                return values;
            }
        } else {
            if (propertyDefinition.getCardinality() != Cardinality.SINGLE) {
                throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' is not a single value property!");
            }
            values = Collections.singletonList(value);
        }
        for (Object o : values) {
            if (o != null) continue;
            throw new IllegalArgumentException("Property '" + propertyDefinition.getId() + "' contains null values!");
        }
        boolean typeMatch = false;
        Object firstValue = values.get(0);
        switch (propertyDefinition.getPropertyType()) {
            case STRING: 
            case ID: 
            case URI: 
            case HTML: {
                typeMatch = firstValue instanceof String;
                break;
            }
            case INTEGER: {
                typeMatch = firstValue instanceof BigInteger || firstValue instanceof Byte || firstValue instanceof Short || firstValue instanceof Integer || firstValue instanceof Long;
                break;
            }
            case DECIMAL: {
                typeMatch = firstValue instanceof BigDecimal;
                break;
            }
            case BOOLEAN: {
                typeMatch = firstValue instanceof Boolean;
                break;
            }
            case DATETIME: {
                typeMatch = firstValue instanceof GregorianCalendar;
            }
        }
        if (!typeMatch) {
            throw new IllegalArgumentException("Value of property '" + propertyDefinition.getId() + "' does not match property type!");
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AceChangeHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String principalId;
        private final List<String> permissions;
        private final AclPropagation aclPropagation;

        public AceChangeHolder(String principalId, List<String> permissions, AclPropagation aclPropagation) {
            if (principalId == null || principalId.length() == 0) {
                throw new IllegalArgumentException("Principal id must be set!");
            }
            if (permissions == null || permissions.size() == 0) {
                throw new IllegalArgumentException("Permissions id must be set!");
            }
            this.principalId = principalId;
            this.permissions = permissions;
            this.aclPropagation = aclPropagation;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public List<String> getPermissions() {
            return this.permissions;
        }

        public AclPropagation getAclPropagation() {
            return this.aclPropagation;
        }
    }
}

