/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.docimport;

import com.wewebu.ow.server.app.OwDocumentImporter;
import com.wewebu.ow.server.app.OwDocumentImporterCallback;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.docimport.OwNoContentDocumentImporterView;
import com.wewebu.ow.server.docimport.log.OwLog;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;

public class OwNoContentDocumentImporter
implements OwDocumentImporter {
    private static final Logger LOG = OwLog.getLogger(OwNoContentDocumentImporter.class);
    protected OwMainAppContext m_context;
    protected OwXMLUtil m_config;

    public void init(OwMainAppContext context_p, OwXMLUtil config_p) throws OwConfigurationException {
        if (context_p == null) {
            throw new IllegalArgumentException("OwNoContentDocumentImporter.init() must not be called without context_p");
        }
        if (config_p == null) {
            throw new IllegalArgumentException("OwNoContentDocumentImporter.init() must not be called without config_p");
        }
        this.m_context = context_p;
        this.m_config = config_p;
    }

    protected OwMainAppContext getContext() {
        if (this.m_context == null) {
            throw new IllegalStateException("OwNoContentDocumentImporter.getContext() must not be called before this view is initialized");
        }
        return this.m_context;
    }

    public String getDisplayName() {
        return this.getContext().localize("plug.docimport.OwNoContentDocumentImporter.DisplayName", "No content");
    }

    public String getIconURL() {
        try {
            return this.getContext().getDesignURL() + this.m_config.getSafeTextValue("icon", "/images/docimport/no_file.png");
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get design URL", (Throwable)e);
            return null;
        }
    }

    public void setSingleFileImports(boolean singleFileImports_p) {
    }

    public OwView getView(int context_p, OwDocumentImporterCallback callback_p) {
        return new OwNoContentDocumentImporterView(this, callback_p);
    }

    public void releaseAll() {
    }

    public OwView getPostProcessView(int importContext_p, OwObject savedObj_p) {
        return null;
    }

    public boolean hasPostProcessView(int importContext_p) {
        return Boolean.FALSE;
    }

    protected void finalize() throws Throwable {
        this.releaseAll();
        super.finalize();
    }
}

