/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedAclService;

public class AclServiceImpl
extends AbstractAtomPubService
implements AclService,
ExtendedAclService {
    public AclServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        Acl originalAces = this.getAcl(repositoryId, objectId, false, null);
        if (!this.isAclMergeRequired(addAces, removeAces)) {
            return originalAces;
        }
        Acl newACL = this.mergeAcls(originalAces, addAces, removeAces);
        AtomAcl acl = this.updateAcl(repositoryId, objectId, newACL, aclPropagation);
        Acl result = Converter.convert((CmisAccessControlListType)acl.getACL(), null);
        return result;
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        return this.getAclInternal(repositoryId, objectId, onlyBasicPermissions, extension);
    }

    public Acl setAcl(String repositoryId, String objectId, Acl aces) {
        AtomAcl acl = this.updateAcl(repositoryId, objectId, aces, AclPropagation.OBJECTONLY);
        Acl result = Converter.convert((CmisAccessControlListType)acl.getACL(), null);
        return result;
    }
}

