/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationServiceImpl
extends AbstractBrowserBindingService
implements NavigationService {
    public NavigationServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "children");
        url.addParameter("filter", (Object)filter);
        url.addParameter("orderBy", (Object)orderBy);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePathSegment", (Object)includePathSegment);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectInFolderList(json, (TypeCache)typeCache);
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "descendants");
        url.addParameter("depth", (Object)depth);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePathSegment", (Object)includePathSegment);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertDescendants(json, (TypeCache)typeCache);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "folder");
        url.addParameter("depth", (Object)depth);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePathSegment", (Object)includePathSegment);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertDescendants(json, (TypeCache)typeCache);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "parents");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includeRelativePathSegment", (Object)includeRelativePathSegment);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectParents(json, (TypeCache)typeCache);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "parent");
        url.addParameter("filter", (Object)filter);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId, "checkedout") : this.getRepositoryUrl(repositoryId, "checkedout");
        url.addParameter("filter", (Object)filter);
        url.addParameter("orderBy", (Object)orderBy);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectList(json, (TypeCache)typeCache, (boolean)false);
    }
}

