/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.weaver.CompressingDataOutputStream;

public class IncrementalStateManager {
    public static boolean recordIncrementalStates = false;
    public static boolean debugIncrementalStates = false;
    private static Hashtable incrementalStates = new Hashtable();

    public static void recordSuccessfulBuild(String buildConfig, AjState state) {
        if (!recordIncrementalStates) {
            return;
        }
        incrementalStates.put(buildConfig, state);
    }

    public static void persist() {
        Set entries = incrementalStates.entrySet();
        for (Map.Entry entry : entries) {
            System.out.println("Name " + entry.getKey());
            File f = new File("n:/temp/foo.ajstate");
            try {
                AjState state = (AjState)entry.getValue();
                CompressingDataOutputStream dos = new CompressingDataOutputStream(new FileOutputStream(f));
                state.write(dos);
                dos.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean removeIncrementalStateInformationFor(String buildConfig) {
        return incrementalStates.remove(buildConfig) != null;
    }

    public static void clearIncrementalStates() {
        for (AjState element : incrementalStates.values()) {
            element.wipeAllKnowledge();
        }
        incrementalStates.clear();
    }

    public static Set getConfigFilesKnown() {
        return incrementalStates.keySet();
    }

    public static AjState retrieveStateFor(String configFile) {
        return (AjState)incrementalStates.get(configFile);
    }

    public static AjState findStateManagingOutputLocation(File location) {
        Collection allStates = incrementalStates.values();
        if (debugIncrementalStates) {
            System.err.println("> findStateManagingOutputLocation(" + location + ") has " + allStates.size() + " states to look through");
        }
        for (AjState element : allStates) {
            AjBuildConfig ajbc = element.getBuildConfig();
            if (ajbc == null) {
                if (!debugIncrementalStates) continue;
                System.err.println("  No build configuration for state " + element);
                continue;
            }
            File outputDir = ajbc.getOutputDir();
            if (outputDir != null && outputDir.equals(location)) {
                if (debugIncrementalStates) {
                    System.err.println("< findStateManagingOutputLocation(" + location + ") returning " + element);
                }
                return element;
            }
            CompilationResultDestinationManager outputManager = ajbc.getCompilationResultDestinationManager();
            if (outputManager != null) {
                List outputDirs = outputManager.getAllOutputLocations();
                for (File dir : outputDirs) {
                    if (!dir.equals(location)) continue;
                    if (debugIncrementalStates) {
                        System.err.println("< findStateManagingOutputLocation(" + location + ") returning " + element);
                    }
                    return element;
                }
            }
            if (outputDir != null || outputManager != null || !debugIncrementalStates) continue;
            System.err.println("  output directory and output location manager for " + ajbc + " are null");
        }
        if (debugIncrementalStates) {
            System.err.println("< findStateManagingOutputLocation(" + location + ") returning null");
        }
        return null;
    }
}

