/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.SourceJavadocParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.aspectj.org.eclipse.jdt.internal.core.util.CommentRecorderParser;

public class SourceElementParser
extends CommentRecorderParser {
    public ISourceElementRequestor requestor;
    ISourceType sourceType;
    boolean reportReferenceInfo;
    char[][] typeNames;
    char[][] superTypeNames;
    int nestedTypeIndex;
    LocalDeclarationVisitor localDeclarationVisitor = null;
    CompilerOptions options;
    HashtableOfObjectToInt sourceEnds = new HashtableOfObjectToInt();
    HashMap nodesToCategories = new HashMap();
    boolean useSourceJavadocParser = true;

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals) {
        this(requestor, problemFactory, options, reportLocalDeclarations, optimizeStringLiterals, true);
    }

    public SourceElementParser(ISourceElementRequestor requestor, IProblemFactory problemFactory, CompilerOptions options, boolean reportLocalDeclarations, boolean optimizeStringLiterals, boolean useSourceJavadocParser) {
        super(new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, problemFactory), optimizeStringLiterals);
        this.problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, problemFactory){

            public void record(CategorizedProblem problem, CompilationResult unitResult, ReferenceContext context) {
                unitResult.record(problem, context);
                SourceElementParser.this.requestor.acceptProblem(problem);
            }
        };
        this.requestor = requestor;
        this.typeNames = new char[4][];
        this.superTypeNames = new char[4][];
        this.nestedTypeIndex = 0;
        this.options = options;
        if (reportLocalDeclarations) {
            this.localDeclarationVisitor = new LocalDeclarationVisitor();
        }
        this.useSourceJavadocParser = useSourceJavadocParser;
        if (useSourceJavadocParser) {
            this.javadocParser = new SourceJavadocParser(this);
        }
    }

    private void acceptJavadocTypeReference(Expression expression) {
        if (expression instanceof JavadocSingleTypeReference) {
            JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)expression;
            this.requestor.acceptTypeReference(singleRef.token, singleRef.sourceStart);
        } else if (expression instanceof JavadocQualifiedTypeReference) {
            JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)expression;
            this.requestor.acceptTypeReference(qualifiedRef.tokens, qualifiedRef.sourceStart, qualifiedRef.sourceEnd);
        }
    }

    public void addUnknownRef(NameReference nameRef) {
        if (nameRef instanceof SingleNameReference) {
            this.requestor.acceptUnknownReference(((SingleNameReference)nameRef).token, nameRef.sourceStart);
        } else {
            this.requestor.acceptUnknownReference(((QualifiedNameReference)nameRef).tokens, nameRef.sourceStart, nameRef.sourceEnd);
        }
    }

    public void checkComment() {
        if (!(this.diet && this.dietInt == 0 || this.scanner.commentPtr < 0)) {
            this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        }
        int lastComment = this.scanner.commentPtr;
        if (this.modifiersSourceStart >= 0) {
            while (lastComment >= 0 && Math.abs(this.scanner.commentStarts[lastComment]) > this.modifiersSourceStart) {
                --lastComment;
            }
        }
        if (lastComment >= 0) {
            this.modifiersSourceStart = Math.abs(this.scanner.commentStarts[0]);
            while (lastComment >= 0 && this.scanner.commentStops[lastComment] < 0) {
                --lastComment;
            }
            if (lastComment >= 0 && this.javadocParser != null) {
                int commentEnd = this.scanner.commentStops[lastComment] - 1;
                boolean bl = this.javadocParser.reportProblems = this.currentElement == null || commentEnd > this.lastJavadocEnd;
                if (this.javadocParser.checkDeprecation(lastComment)) {
                    this.checkAndSetModifiers(0x100000);
                }
                this.javadoc = this.javadocParser.docComment;
                if (this.currentElement == null) {
                    this.lastJavadocEnd = commentEnd;
                }
            }
        }
        if (this.reportReferenceInfo && this.javadocParser.checkDocComment && this.javadoc != null) {
            Expression[] references;
            TypeReference[] thrownExceptions = this.javadoc.exceptionReferences;
            if (thrownExceptions != null) {
                int i = 0;
                int max = thrownExceptions.length;
                while (i < max) {
                    TypeReference typeRef = thrownExceptions[i];
                    if (typeRef instanceof JavadocSingleTypeReference) {
                        JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                        this.requestor.acceptTypeReference(singleRef.token, singleRef.sourceStart);
                    } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                        JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                        this.requestor.acceptTypeReference(qualifiedRef.tokens, qualifiedRef.sourceStart, qualifiedRef.sourceEnd);
                    }
                    ++i;
                }
            }
            if ((references = this.javadoc.seeReferences) != null) {
                int i = 0;
                int max = references.length;
                while (i < max) {
                    int argCount;
                    Expression reference = references[i];
                    this.acceptJavadocTypeReference(reference);
                    if (reference instanceof JavadocFieldReference) {
                        JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
                        this.requestor.acceptFieldReference(fieldRef.token, fieldRef.sourceStart);
                        if (fieldRef.receiver != null && !fieldRef.receiver.isThis()) {
                            this.acceptJavadocTypeReference(fieldRef.receiver);
                        }
                    } else if (reference instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)reference;
                        argCount = messageSend.arguments == null ? 0 : messageSend.arguments.length;
                        this.requestor.acceptMethodReference(messageSend.selector, argCount, messageSend.sourceStart);
                        this.requestor.acceptConstructorReference(messageSend.selector, argCount, messageSend.sourceStart);
                        if (messageSend.receiver != null && !messageSend.receiver.isThis()) {
                            this.acceptJavadocTypeReference(messageSend.receiver);
                        }
                    } else if (reference instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression constructor = (JavadocAllocationExpression)reference;
                        int n = argCount = constructor.arguments == null ? 0 : constructor.arguments.length;
                        if (constructor.type != null) {
                            char[][] compoundName = constructor.type.getParameterizedTypeName();
                            this.requestor.acceptConstructorReference(compoundName[compoundName.length - 1], argCount, constructor.sourceStart);
                            if (!constructor.type.isThis()) {
                                this.acceptJavadocTypeReference(constructor.type);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void classInstanceCreation(boolean alwaysQualified) {
        boolean previousFlag = this.reportReferenceInfo;
        this.reportReferenceInfo = false;
        super.classInstanceCreation(alwaysQualified);
        this.reportReferenceInfo = previousFlag;
        if (this.reportReferenceInfo) {
            AllocationExpression alloc = (AllocationExpression)this.expressionStack[this.expressionPtr];
            TypeReference typeRef = alloc.type;
            this.requestor.acceptConstructorReference(typeRef instanceof SingleTypeReference ? ((SingleTypeReference)typeRef).token : CharOperation.concatWith(alloc.type.getParameterizedTypeName(), '.'), alloc.arguments == null ? 0 : alloc.arguments.length, alloc.sourceStart);
        }
    }

    private long[] collectAnnotationPositions(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        int length = annotations.length;
        long[] result = new long[length];
        int i = 0;
        while (i < length) {
            Annotation annotation = annotations[i];
            result[i] = ((long)annotation.sourceStart << 32) + (long)annotation.declarationSourceEnd;
            ++i;
        }
        return result;
    }

    protected void consumeAnnotationAsModifier() {
        super.consumeAnnotationAsModifier();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(annotation.type.getTypeName(), annotation.sourceStart, annotation.sourceEnd);
        }
    }

    protected void consumeClassInstanceCreationExpressionQualifiedWithTypeArguments() {
        boolean previousFlag = this.reportReferenceInfo;
        this.reportReferenceInfo = false;
        super.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
        this.reportReferenceInfo = previousFlag;
        if (this.reportReferenceInfo) {
            AllocationExpression alloc = (AllocationExpression)this.expressionStack[this.expressionPtr];
            TypeReference typeRef = alloc.type;
            this.requestor.acceptConstructorReference(typeRef instanceof SingleTypeReference ? ((SingleTypeReference)typeRef).token : CharOperation.concatWith(alloc.type.getParameterizedTypeName(), '.'), alloc.arguments == null ? 0 : alloc.arguments.length, alloc.sourceStart);
        }
    }

    protected void consumeAnnotationTypeDeclarationHeaderName() {
        int currentAstPtr = this.astPtr;
        super.consumeAnnotationTypeDeclarationHeaderName();
        if (this.astPtr > currentAstPtr) {
            this.rememberCategories();
        }
    }

    protected void consumeClassHeaderName1() {
        int currentAstPtr = this.astPtr;
        super.consumeClassHeaderName1();
        if (this.astPtr > currentAstPtr) {
            this.rememberCategories();
        }
    }

    protected void consumeClassInstanceCreationExpressionWithTypeArguments() {
        boolean previousFlag = this.reportReferenceInfo;
        this.reportReferenceInfo = false;
        super.consumeClassInstanceCreationExpressionWithTypeArguments();
        this.reportReferenceInfo = previousFlag;
        if (this.reportReferenceInfo) {
            AllocationExpression alloc = (AllocationExpression)this.expressionStack[this.expressionPtr];
            TypeReference typeRef = alloc.type;
            this.requestor.acceptConstructorReference(typeRef instanceof SingleTypeReference ? ((SingleTypeReference)typeRef).token : CharOperation.concatWith(alloc.type.getParameterizedTypeName(), '.'), alloc.arguments == null ? 0 : alloc.arguments.length, alloc.sourceStart);
        }
    }

    protected void consumeConstructorHeaderName() {
        long selectorSourcePositions = this.identifierPositionStack[this.identifierPtr];
        int selectorSourceEnd = (int)selectorSourcePositions;
        int currentAstPtr = this.astPtr;
        super.consumeConstructorHeaderName();
        if (this.astPtr > currentAstPtr) {
            this.sourceEnds.put(this.astStack[this.astPtr], selectorSourceEnd);
            this.rememberCategories();
        }
    }

    protected void consumeConstructorHeaderNameWithTypeParameters() {
        long selectorSourcePositions = this.identifierPositionStack[this.identifierPtr];
        int selectorSourceEnd = (int)selectorSourcePositions;
        int currentAstPtr = this.astPtr;
        super.consumeConstructorHeaderNameWithTypeParameters();
        if (this.astPtr > currentAstPtr) {
            this.sourceEnds.put(this.astStack[this.astPtr], selectorSourceEnd);
            this.rememberCategories();
        }
    }

    protected void consumeEnumConstantWithClassBody() {
        super.consumeEnumConstantWithClassBody();
        if ((this.currentToken == 37 || this.currentToken == 27) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeEnumConstantNoClassBody() {
        super.consumeEnumConstantNoClassBody();
        if ((this.currentToken == 37 || this.currentToken == 27) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeEnumHeaderName() {
        int currentAstPtr = this.astPtr;
        super.consumeEnumHeaderName();
        if (this.astPtr > currentAstPtr) {
            this.rememberCategories();
        }
    }

    protected void consumeExitVariableWithInitialization() {
        super.consumeExitVariableWithInitialization();
        if ((this.currentToken == 37 || this.currentToken == 27) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeExitVariableWithoutInitialization() {
        super.consumeExitVariableWithoutInitialization();
        if ((this.currentToken == 37 || this.currentToken == 27) && this.astStack[this.astPtr] instanceof FieldDeclaration) {
            this.sourceEnds.put(this.astStack[this.astPtr], this.scanner.currentPosition - 1);
            this.rememberCategories();
        }
    }

    protected void consumeFieldAccess(boolean isSuperAccess) {
        super.consumeFieldAccess(isSuperAccess);
        FieldReference fr = (FieldReference)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptFieldReference(fr.token, fr.sourceStart);
        }
    }

    protected void consumeFormalParameter(boolean isVarArgs) {
        super.consumeFormalParameter(isVarArgs);
        this.flushCommentsDefinedPriorTo(this.scanner.currentPosition);
    }

    protected void consumeInterfaceHeaderName1() {
        int currentAstPtr = this.astPtr;
        super.consumeInterfaceHeaderName1();
        if (this.astPtr > currentAstPtr) {
            this.rememberCategories();
        }
    }

    protected void consumeMemberValuePair() {
        super.consumeMemberValuePair();
        MemberValuePair memberValuepair = (MemberValuePair)this.astStack[this.astPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(memberValuepair.name, 0, memberValuepair.sourceStart);
        }
    }

    protected void consumeMarkerAnnotation() {
        super.consumeMarkerAnnotation();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(annotation.type.getTypeName(), annotation.sourceStart, annotation.sourceEnd);
        }
    }

    protected void consumeMethodHeaderName(boolean isAnnotationMethod) {
        long selectorSourcePositions = this.identifierPositionStack[this.identifierPtr];
        int selectorSourceEnd = (int)selectorSourcePositions;
        int currentAstPtr = this.astPtr;
        super.consumeMethodHeaderName(isAnnotationMethod);
        if (this.astPtr > currentAstPtr) {
            this.sourceEnds.put(this.astStack[this.astPtr], selectorSourceEnd);
            this.rememberCategories();
        }
    }

    protected void consumeMethodHeaderNameWithTypeParameters(boolean isAnnotationMethod) {
        long selectorSourcePositions = this.identifierPositionStack[this.identifierPtr];
        int selectorSourceEnd = (int)selectorSourcePositions;
        int currentAstPtr = this.astPtr;
        super.consumeMethodHeaderNameWithTypeParameters(isAnnotationMethod);
        if (this.astPtr > currentAstPtr) {
            this.sourceEnds.put(this.astStack[this.astPtr], selectorSourceEnd);
        }
        this.rememberCategories();
    }

    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeMethodInvocationNameWithTypeArguments() {
        super.consumeMethodInvocationNameWithTypeArguments();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeMethodInvocationPrimary() {
        super.consumeMethodInvocationPrimary();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeMethodInvocationPrimaryWithTypeArguments() {
        super.consumeMethodInvocationPrimaryWithTypeArguments();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeMethodInvocationSuper() {
        super.consumeMethodInvocationSuper();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeMethodInvocationSuperWithTypeArguments() {
        super.consumeMethodInvocationSuperWithTypeArguments();
        MessageSend messageSend = (MessageSend)this.expressionStack[this.expressionPtr];
        Expression[] args = messageSend.arguments;
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(messageSend.selector, args == null ? 0 : args.length, (int)(messageSend.nameSourcePosition >>> 32));
        }
    }

    protected void consumeNormalAnnotation() {
        super.consumeNormalAnnotation();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(annotation.type.getTypeName(), annotation.sourceStart, annotation.sourceEnd);
        }
    }

    protected void consumeSingleMemberAnnotation() {
        super.consumeSingleMemberAnnotation();
        SingleMemberAnnotation member = (SingleMemberAnnotation)this.expressionStack[this.expressionPtr];
        if (this.reportReferenceInfo) {
            this.requestor.acceptMethodReference(TypeConstants.VALUE, 0, member.sourceStart);
        }
    }

    protected void consumeSingleStaticImportDeclarationName() {
        int length = this.identifierLengthStack[this.identifierLengthPtr--];
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        ImportReference impt = this.newImportReference(tokens, positions, false, 8);
        this.pushOnAstStack(impt);
        this.modifiers = 0;
        this.modifiersSourceStart = -1;
        impt.declarationSourceEnd = this.currentToken == 27 ? this.scanner.currentPosition - 1 : impt.sourceEnd;
        impt.declarationEnd = impt.declarationSourceEnd;
        impt.declarationSourceStart = this.intStack[this.intPtr--];
        if (!this.statementRecoveryActivated && this.options.sourceLevel < 0x310000L && this.lastErrorEndPositionBeforeRecovery < this.scanner.currentPosition) {
            impt.modifiers = 0;
            this.problemReporter().invalidUsageOfStaticImports(impt);
        }
        if (this.currentElement != null) {
            this.lastCheckPoint = impt.declarationSourceEnd + 1;
            this.currentElement = this.currentElement.add(impt, 0);
            this.lastIgnoredToken = -1;
            this.restartRecovery = true;
        }
        if (this.reportReferenceInfo) {
            int tokensLength = impt.tokens.length - 1;
            int start = (int)(impt.sourcePositions[tokensLength] >>> 32);
            char[] last = impt.tokens[tokensLength];
            this.requestor.acceptFieldReference(last, start);
            this.requestor.acceptMethodReference(last, 0, start);
            this.requestor.acceptTypeReference(last, start);
            if (tokensLength > 0) {
                char[][] compoundName = new char[tokensLength][];
                System.arraycopy(impt.tokens, 0, compoundName, 0, tokensLength);
                int end = (int)impt.sourcePositions[tokensLength - 1];
                this.requestor.acceptTypeReference(compoundName, impt.sourceStart, end);
            }
        }
    }

    protected void consumeSingleTypeImportDeclarationName() {
        int length = this.identifierLengthStack[this.identifierLengthPtr--];
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        ImportReference impt = this.newImportReference(tokens, positions, false, 0);
        this.pushOnAstStack(impt);
        impt.declarationSourceEnd = this.currentToken == 27 ? this.scanner.currentPosition - 1 : impt.sourceEnd;
        impt.declarationEnd = impt.declarationSourceEnd;
        impt.declarationSourceStart = this.intStack[this.intPtr--];
        if (this.currentElement != null) {
            this.lastCheckPoint = impt.declarationSourceEnd + 1;
            this.currentElement = this.currentElement.add(impt, 0);
            this.lastIgnoredToken = -1;
            this.restartRecovery = true;
        }
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(impt.tokens, impt.sourceStart, impt.sourceEnd);
        }
    }

    protected void consumeStaticImportOnDemandDeclarationName() {
        int length = this.identifierLengthStack[this.identifierLengthPtr--];
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        ImportReference impt = new ImportReference(tokens, positions, true, 8);
        this.pushOnAstStack(impt);
        this.modifiers = 0;
        this.modifiersSourceStart = -1;
        impt.declarationSourceEnd = this.currentToken == 27 ? this.scanner.currentPosition - 1 : impt.sourceEnd;
        impt.declarationEnd = impt.declarationSourceEnd;
        impt.declarationSourceStart = this.intStack[this.intPtr--];
        if (!this.statementRecoveryActivated && this.options.sourceLevel < 0x310000L && this.lastErrorEndPositionBeforeRecovery < this.scanner.currentPosition) {
            impt.modifiers = 0;
            this.problemReporter().invalidUsageOfStaticImports(impt);
        }
        if (this.currentElement != null) {
            this.lastCheckPoint = impt.declarationSourceEnd + 1;
            this.currentElement = this.currentElement.add(impt, 0);
            this.lastIgnoredToken = -1;
            this.restartRecovery = true;
        }
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(impt.tokens, impt.sourceStart, impt.sourceEnd);
        }
    }

    protected void consumeTypeImportOnDemandDeclarationName() {
        int length = this.identifierLengthStack[this.identifierLengthPtr--];
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        ImportReference impt = new ImportReference(tokens, positions, true, 0);
        this.pushOnAstStack(impt);
        impt.declarationSourceEnd = this.currentToken == 27 ? this.scanner.currentPosition - 1 : impt.sourceEnd;
        impt.declarationEnd = impt.declarationSourceEnd;
        impt.declarationSourceStart = this.intStack[this.intPtr--];
        if (this.currentElement != null) {
            this.lastCheckPoint = impt.declarationSourceEnd + 1;
            this.currentElement = this.currentElement.add(impt, 0);
            this.lastIgnoredToken = -1;
            this.restartRecovery = true;
        }
        if (this.reportReferenceInfo) {
            this.requestor.acceptUnknownReference(impt.tokens, impt.sourceStart, impt.sourceEnd);
        }
    }

    public MethodDeclaration convertToMethodDeclaration(ConstructorDeclaration c, CompilationResult compilationResult) {
        char[][] categories;
        MethodDeclaration methodDeclaration = super.convertToMethodDeclaration(c, compilationResult);
        int selectorSourceEnd = this.sourceEnds.removeKey(c);
        if (selectorSourceEnd != -1) {
            this.sourceEnds.put(methodDeclaration, selectorSourceEnd);
        }
        if ((categories = (char[][])this.nodesToCategories.remove(c)) != null) {
            this.nodesToCategories.put(methodDeclaration, categories);
        }
        return methodDeclaration;
    }

    protected CompilationUnitDeclaration endParse(int act) {
        if (this.sourceType != null) {
            switch (TypeDeclaration.kind(this.sourceType.getModifiers())) {
                case 1: {
                    this.consumeClassDeclaration();
                    break;
                }
                case 2: {
                    this.consumeInterfaceDeclaration();
                    break;
                }
                case 3: {
                    this.consumeEnumDeclaration();
                    break;
                }
                case 4: {
                    this.consumeAnnotationTypeDeclaration();
                }
            }
        }
        if (this.compilationUnit != null) {
            CompilationUnitDeclaration result = super.endParse(act);
            return result;
        }
        return null;
    }

    private ISourceElementRequestor.TypeParameterInfo[] getTypeParameterInfos(TypeParameter[] typeParameters) {
        if (typeParameters == null) {
            return null;
        }
        int typeParametersLength = typeParameters.length;
        ISourceElementRequestor.TypeParameterInfo[] result = new ISourceElementRequestor.TypeParameterInfo[typeParametersLength];
        int i = 0;
        while (i < typeParametersLength) {
            TypeParameter typeParameter = typeParameters[i];
            TypeReference firstBound = typeParameter.type;
            TypeReference[] otherBounds = typeParameter.bounds;
            Object typeParameterBounds = null;
            if (firstBound != null) {
                if (otherBounds != null) {
                    int otherBoundsLength = otherBounds.length;
                    char[][] boundNames = new char[otherBoundsLength + 1][];
                    boundNames[0] = CharOperation.concatWith(firstBound.getParameterizedTypeName(), '.');
                    int j = 0;
                    while (j < otherBoundsLength) {
                        boundNames[j + 1] = CharOperation.concatWith(otherBounds[j].getParameterizedTypeName(), '.');
                        ++j;
                    }
                    typeParameterBounds = boundNames;
                } else {
                    typeParameterBounds = new char[][]{CharOperation.concatWith(firstBound.getParameterizedTypeName(), '.')};
                }
            } else {
                typeParameterBounds = CharOperation.NO_CHAR_CHAR;
            }
            ISourceElementRequestor.TypeParameterInfo typeParameterInfo = new ISourceElementRequestor.TypeParameterInfo();
            typeParameterInfo.declarationStart = typeParameter.declarationSourceStart;
            typeParameterInfo.declarationEnd = typeParameter.declarationSourceEnd;
            typeParameterInfo.name = typeParameter.name;
            typeParameterInfo.nameSourceStart = typeParameter.sourceStart;
            typeParameterInfo.nameSourceEnd = typeParameter.sourceEnd;
            typeParameterInfo.bounds = typeParameterBounds;
            result[i] = typeParameterInfo;
            ++i;
        }
        return result;
    }

    public TypeReference getTypeReference(int dim) {
        int numberOfIdentifiers;
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) < 0) {
            TypeReference ref = TypeReference.baseTypeReference(-length, dim);
            ref.sourceStart = this.intStack[this.intPtr--];
            if (dim == 0) {
                ref.sourceEnd = this.intStack[this.intPtr--];
            } else {
                --this.intPtr;
                ref.sourceEnd = this.endPosition;
            }
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.getParameterizedTypeName(), ref.sourceStart, ref.sourceEnd);
            }
            return ref;
        }
        if (length != (numberOfIdentifiers = this.genericsIdentifiersLengthStack[this.genericsIdentifiersLengthPtr--]) || this.genericsLengthStack[this.genericsLengthPtr] != 0) {
            TypeReference ref = this.getTypeReferenceForGenericType(dim, length, numberOfIdentifiers);
            if (this.reportReferenceInfo) {
                if (length == 1 && numberOfIdentifiers == 1) {
                    ParameterizedSingleTypeReference parameterizedSingleTypeReference = (ParameterizedSingleTypeReference)ref;
                    this.requestor.acceptTypeReference(parameterizedSingleTypeReference.token, parameterizedSingleTypeReference.sourceStart);
                } else {
                    ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = (ParameterizedQualifiedTypeReference)ref;
                    this.requestor.acceptTypeReference(parameterizedQualifiedTypeReference.tokens, parameterizedQualifiedTypeReference.sourceStart, parameterizedQualifiedTypeReference.sourceEnd);
                }
            }
            return ref;
        }
        if (length == 1) {
            --this.genericsLengthPtr;
            if (dim == 0) {
                SingleTypeReference ref = new SingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
                if (this.reportReferenceInfo) {
                    this.requestor.acceptTypeReference(ref.token, ref.sourceStart);
                }
                return ref;
            }
            ArrayTypeReference ref = new ArrayTypeReference(this.identifierStack[this.identifierPtr], dim, this.identifierPositionStack[this.identifierPtr--]);
            ref.sourceEnd = this.endPosition;
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.token, ref.sourceStart);
            }
            return ref;
        }
        --this.genericsLengthPtr;
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        long[] positions = new long[length];
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        if (dim == 0) {
            QualifiedTypeReference ref = new QualifiedTypeReference(tokens, positions);
            if (this.reportReferenceInfo) {
                this.requestor.acceptTypeReference(ref.tokens, ref.sourceStart, ref.sourceEnd);
            }
            return ref;
        }
        ArrayQualifiedTypeReference ref = new ArrayQualifiedTypeReference(tokens, dim, positions);
        ref.sourceEnd = this.endPosition;
        if (this.reportReferenceInfo) {
            this.requestor.acceptTypeReference(ref.tokens, ref.sourceStart, ref.sourceEnd);
        }
        return ref;
    }

    public NameReference getUnspecifiedReference() {
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            SingleNameReference ref = this.newSingleNameReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
            if (this.reportReferenceInfo) {
                this.addUnknownRef(ref);
            }
            return ref;
        }
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        long[] positions = new long[length];
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        QualifiedNameReference ref = this.newQualifiedNameReference(tokens, positions, (int)(this.identifierPositionStack[this.identifierPtr + 1] >> 32), (int)this.identifierPositionStack[this.identifierPtr + length]);
        if (this.reportReferenceInfo) {
            this.addUnknownRef(ref);
        }
        return ref;
    }

    public NameReference getUnspecifiedReferenceOptimized() {
        int length;
        if ((length = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            SingleNameReference ref = this.newSingleNameReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr--]);
            ref.bits &= 0xFFFFFFF8;
            ref.bits |= 3;
            if (this.reportReferenceInfo) {
                this.addUnknownRef(ref);
            }
            return ref;
        }
        char[][] tokens = new char[length][];
        this.identifierPtr -= length;
        System.arraycopy(this.identifierStack, this.identifierPtr + 1, tokens, 0, length);
        long[] positions = new long[length];
        System.arraycopy(this.identifierPositionStack, this.identifierPtr + 1, positions, 0, length);
        QualifiedNameReference ref = this.newQualifiedNameReference(tokens, positions, (int)(this.identifierPositionStack[this.identifierPtr + 1] >> 32), (int)this.identifierPositionStack[this.identifierPtr + length]);
        ref.bits &= 0xFFFFFFF8;
        ref.bits |= 3;
        if (this.reportReferenceInfo) {
            this.addUnknownRef(ref);
        }
        return ref;
    }

    private boolean hasDeprecatedAnnotation(Annotation[] annotations) {
        if (annotations != null) {
            int i = 0;
            int length = annotations.length;
            while (i < length) {
                Annotation annotation = annotations[i];
                if (CharOperation.equals(annotation.type.getLastToken(), TypeConstants.JAVA_LANG_DEPRECATED[2])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected ImportReference newImportReference(char[][] tokens, long[] positions, boolean onDemand, int mod) {
        return new ImportReference(tokens, positions, onDemand, mod);
    }

    protected QualifiedNameReference newQualifiedNameReference(char[][] tokens, long[] positions, int sourceStart, int sourceEnd) {
        return new QualifiedNameReference(tokens, positions, sourceStart, sourceEnd);
    }

    protected SingleNameReference newSingleNameReference(char[] source, long positions) {
        return new SingleNameReference(source, positions);
    }

    public void notifySourceElementRequestor(CompilationUnitDeclaration parsedUnit) {
        if (parsedUnit == null) {
            if (this.astStack[0] instanceof AbstractMethodDeclaration) {
                this.notifySourceElementRequestor((AbstractMethodDeclaration)this.astStack[0]);
                return;
            }
            return;
        }
        boolean isInRange = this.scanner.initialPosition <= parsedUnit.sourceStart && this.scanner.eofPosition >= parsedUnit.sourceEnd;
        int length = 0;
        ASTNode[] nodes = null;
        if (this.sourceType == null) {
            int max;
            int i;
            if (isInRange) {
                this.requestor.enterCompilationUnit();
            }
            ImportReference currentPackage = parsedUnit.currentPackage;
            ImportReference[] imports = parsedUnit.imports;
            TypeDeclaration[] types = parsedUnit.types;
            length = (currentPackage == null ? 0 : 1) + (imports == null ? 0 : imports.length) + (types == null ? 0 : types.length);
            nodes = new ASTNode[length];
            int index = 0;
            if (currentPackage != null) {
                nodes[index++] = currentPackage;
            }
            if (imports != null) {
                i = 0;
                max = imports.length;
                while (i < max) {
                    nodes[index++] = imports[i];
                    ++i;
                }
            }
            if (types != null) {
                i = 0;
                max = types.length;
                while (i < max) {
                    nodes[index++] = types[i];
                    ++i;
                }
            }
        } else {
            TypeDeclaration[] types = parsedUnit.types;
            if (types != null) {
                length = types.length;
                nodes = new ASTNode[length];
                int i = 0;
                int max = types.length;
                while (i < max) {
                    nodes[i] = types[i];
                    ++i;
                }
            }
        }
        if (nodes != null && length > 0) {
            SourceElementParser.quickSort(nodes, 0, length - 1);
            int i = 0;
            while (i < length) {
                ASTNode node = nodes[i];
                if (node instanceof ImportReference) {
                    ImportReference importRef = (ImportReference)node;
                    if (node == parsedUnit.currentPackage) {
                        this.notifySourceElementRequestor(importRef, true);
                    } else {
                        this.notifySourceElementRequestor(importRef, false);
                    }
                } else {
                    this.notifySourceElementRequestor((TypeDeclaration)node, this.sourceType == null, null);
                }
                ++i;
            }
        }
        if (this.sourceType == null && isInRange) {
            this.requestor.exitCompilationUnit(parsedUnit.sourceEnd);
        }
    }

    public void notifySourceElementRequestor(AbstractMethodDeclaration methodDeclaration) {
        int currentModifiers;
        boolean isInRange;
        boolean bl = isInRange = this.scanner.initialPosition <= methodDeclaration.declarationSourceStart && this.scanner.eofPosition >= methodDeclaration.declarationSourceEnd;
        if (methodDeclaration.isClinit()) {
            this.visitIfNeeded(methodDeclaration);
            return;
        }
        if (methodDeclaration.isDefaultConstructor()) {
            if (this.reportReferenceInfo) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            return;
        }
        Object argumentTypes = null;
        Object argumentNames = null;
        boolean isVarArgs = false;
        Argument[] arguments = methodDeclaration.arguments;
        if (arguments != null) {
            int argumentLength = arguments.length;
            argumentTypes = new char[argumentLength][];
            argumentNames = new char[argumentLength][];
            int i = 0;
            while (i < argumentLength) {
                argumentTypes[i] = CharOperation.concatWith(arguments[i].type.getParameterizedTypeName(), '.');
                argumentNames[i] = arguments[i].name;
                ++i;
            }
            isVarArgs = arguments[argumentLength - 1].isVarArgs();
        }
        Object thrownExceptionTypes = null;
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionLength = thrownExceptions.length;
            thrownExceptionTypes = new char[thrownExceptionLength][];
            int i = 0;
            while (i < thrownExceptionLength) {
                thrownExceptionTypes[i] = CharOperation.concatWith(thrownExceptions[i].getParameterizedTypeName(), '.');
                ++i;
            }
        }
        int selectorSourceEnd = -1;
        if (methodDeclaration.isConstructor()) {
            selectorSourceEnd = this.sourceEnds.get(methodDeclaration);
            if (isInRange) {
                currentModifiers = methodDeclaration.modifiers;
                if (isVarArgs) {
                    currentModifiers |= 0x80;
                }
                boolean deprecated = (currentModifiers & 0x100000) != 0 || this.hasDeprecatedAnnotation(methodDeclaration.annotations);
                ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
                methodInfo.isConstructor = true;
                methodInfo.declarationStart = methodDeclaration.declarationSourceStart;
                methodInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                methodInfo.name = methodDeclaration.selector;
                methodInfo.nameSourceStart = methodDeclaration.sourceStart;
                methodInfo.nameSourceEnd = selectorSourceEnd;
                methodInfo.parameterTypes = argumentTypes;
                methodInfo.parameterNames = argumentNames;
                methodInfo.exceptionTypes = thrownExceptionTypes;
                methodInfo.typeParameters = this.getTypeParameterInfos(methodDeclaration.typeParameters());
                methodInfo.annotationPositions = this.collectAnnotationPositions(methodDeclaration.annotations);
                methodInfo.categories = (char[][])this.nodesToCategories.get(methodDeclaration);
                this.requestor.enterConstructor(methodInfo);
            }
            if (this.reportReferenceInfo) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
                ExplicitConstructorCall constructorCall = constructorDeclaration.constructorCall;
                if (constructorCall != null) {
                    switch (constructorCall.accessMode) {
                        case 3: {
                            this.requestor.acceptConstructorReference(this.typeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.requestor.acceptConstructorReference(this.superTypeNames[this.nestedTypeIndex - 1], constructorCall.arguments == null ? 0 : constructorCall.arguments.length, constructorCall.sourceStart);
                        }
                    }
                }
            }
            this.visitIfNeeded(methodDeclaration);
            if (isInRange) {
                this.requestor.exitConstructor(methodDeclaration.declarationSourceEnd);
            }
            return;
        }
        selectorSourceEnd = this.sourceEnds.get(methodDeclaration);
        if (isInRange) {
            currentModifiers = methodDeclaration.modifiers;
            if (isVarArgs) {
                currentModifiers |= 0x80;
            }
            boolean deprecated = (currentModifiers & 0x100000) != 0 || this.hasDeprecatedAnnotation(methodDeclaration.annotations);
            TypeReference returnType = methodDeclaration instanceof MethodDeclaration ? ((MethodDeclaration)methodDeclaration).returnType : null;
            ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
            methodInfo.isAnnotation = methodDeclaration instanceof AnnotationMethodDeclaration;
            methodInfo.declarationStart = methodDeclaration.declarationSourceStart;
            methodInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
            methodInfo.returnType = returnType == null ? null : CharOperation.concatWith(returnType.getParameterizedTypeName(), '.');
            methodInfo.name = methodDeclaration.selector;
            methodInfo.nameSourceStart = methodDeclaration.sourceStart;
            methodInfo.nameSourceEnd = selectorSourceEnd;
            methodInfo.parameterTypes = argumentTypes;
            methodInfo.parameterNames = argumentNames;
            methodInfo.exceptionTypes = thrownExceptionTypes;
            methodInfo.typeParameters = this.getTypeParameterInfos(methodDeclaration.typeParameters());
            methodInfo.annotationPositions = this.collectAnnotationPositions(methodDeclaration.annotations);
            methodInfo.categories = (char[][])this.nodesToCategories.get(methodDeclaration);
            this.requestor.enterMethod(methodInfo);
        }
        this.visitIfNeeded(methodDeclaration);
        if (isInRange) {
            if (methodDeclaration instanceof AnnotationMethodDeclaration) {
                AnnotationMethodDeclaration annotationMethodDeclaration = (AnnotationMethodDeclaration)methodDeclaration;
                Expression expression = annotationMethodDeclaration.defaultValue;
                if (expression != null) {
                    this.requestor.exitMethod(methodDeclaration.declarationSourceEnd, expression.sourceStart, expression.sourceEnd);
                    return;
                }
            }
            this.requestor.exitMethod(methodDeclaration.declarationSourceEnd, -1, -1);
        }
    }

    public void notifySourceElementRequestor(FieldDeclaration fieldDeclaration, TypeDeclaration declaringType) {
        boolean isInRange = this.scanner.initialPosition <= fieldDeclaration.declarationSourceStart && this.scanner.eofPosition >= fieldDeclaration.declarationSourceEnd;
        switch (fieldDeclaration.getKind()) {
            case 3: {
                if (fieldDeclaration.initialization instanceof AllocationExpression) {
                    AllocationExpression alloc = (AllocationExpression)fieldDeclaration.initialization;
                    this.requestor.acceptConstructorReference(declaringType.name, alloc.arguments == null ? 0 : alloc.arguments.length, alloc.sourceStart);
                }
            }
            case 1: {
                int fieldEndPosition = this.sourceEnds.get(fieldDeclaration);
                if (fieldEndPosition == -1) {
                    fieldEndPosition = fieldDeclaration.declarationSourceEnd;
                }
                if (isInRange) {
                    int currentModifiers = fieldDeclaration.modifiers;
                    boolean deprecated = (currentModifiers & 0x100000) != 0 || this.hasDeprecatedAnnotation(fieldDeclaration.annotations);
                    char[] typeName = null;
                    if (fieldDeclaration.type == null) {
                        typeName = declaringType.name;
                        currentModifiers |= 0x4000;
                    } else {
                        typeName = CharOperation.concatWith(fieldDeclaration.type.getParameterizedTypeName(), '.');
                    }
                    ISourceElementRequestor.FieldInfo fieldInfo = new ISourceElementRequestor.FieldInfo();
                    fieldInfo.declarationStart = fieldDeclaration.declarationSourceStart;
                    fieldInfo.name = fieldDeclaration.name;
                    fieldInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                    fieldInfo.type = typeName;
                    fieldInfo.nameSourceStart = fieldDeclaration.sourceStart;
                    fieldInfo.nameSourceEnd = fieldDeclaration.sourceEnd;
                    fieldInfo.annotationPositions = this.collectAnnotationPositions(fieldDeclaration.annotations);
                    fieldInfo.categories = (char[][])this.nodesToCategories.get(fieldDeclaration);
                    this.requestor.enterField(fieldInfo);
                }
                this.visitIfNeeded(fieldDeclaration, declaringType);
                if (!isInRange) break;
                this.requestor.exitField(fieldDeclaration.initialization == null || fieldDeclaration.initialization instanceof ArrayInitializer || fieldDeclaration.initialization instanceof AllocationExpression || fieldDeclaration.initialization instanceof ArrayAllocationExpression || fieldDeclaration.initialization instanceof Assignment || fieldDeclaration.initialization instanceof ClassLiteralAccess || fieldDeclaration.initialization instanceof MessageSend || fieldDeclaration.initialization instanceof ArrayReference || fieldDeclaration.initialization instanceof ThisReference ? -1 : fieldDeclaration.initialization.sourceStart, fieldEndPosition, fieldDeclaration.declarationSourceEnd);
                break;
            }
            case 2: {
                if (isInRange) {
                    this.requestor.enterInitializer(fieldDeclaration.declarationSourceStart, fieldDeclaration.modifiers);
                }
                this.visitIfNeeded((Initializer)fieldDeclaration);
                if (!isInRange) break;
                this.requestor.exitInitializer(fieldDeclaration.declarationSourceEnd);
            }
        }
    }

    public void notifySourceElementRequestor(ImportReference importReference, boolean isPackage) {
        if (isPackage) {
            this.requestor.acceptPackage(importReference.declarationSourceStart, importReference.declarationSourceEnd, CharOperation.concatWith(importReference.getImportName(), '.'));
        } else {
            this.requestor.acceptImport(importReference.declarationSourceStart, importReference.declarationSourceEnd, importReference.tokens, (importReference.bits & 0x20000) != 0, importReference.modifiers);
        }
    }

    public void notifySourceElementRequestor(TypeDeclaration typeDeclaration, boolean notifyTypePresence, TypeDeclaration declaringType) {
        if (CharOperation.equals(TypeConstants.PACKAGE_INFO_NAME, typeDeclaration.name)) {
            return;
        }
        boolean isInRange = this.scanner.initialPosition <= typeDeclaration.declarationSourceStart && this.scanner.eofPosition >= typeDeclaration.declarationSourceEnd;
        FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int fieldCounter = fields == null ? 0 : fields.length;
        int methodCounter = methods == null ? 0 : methods.length;
        int memberTypeCounter = memberTypes == null ? 0 : memberTypes.length;
        int fieldIndex = 0;
        int methodIndex = 0;
        int memberTypeIndex = 0;
        if (notifyTypePresence) {
            QualifiedAllocationExpression alloc;
            Object interfaceNames = null;
            int superInterfacesLength = 0;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces != null) {
                superInterfacesLength = superInterfaces.length;
                interfaceNames = new char[superInterfacesLength][];
            } else if ((typeDeclaration.bits & 0x200) != 0 && (alloc = typeDeclaration.allocation) != null && alloc.type != null) {
                superInterfaces = new TypeReference[]{alloc.type};
                superInterfacesLength = 1;
                interfaceNames = new char[1][];
            }
            if (superInterfaces != null) {
                int i = 0;
                while (i < superInterfacesLength) {
                    interfaceNames[i] = CharOperation.concatWith(superInterfaces[i].getParameterizedTypeName(), '.');
                    ++i;
                }
            }
            int kind = TypeDeclaration.kind(typeDeclaration.modifiers);
            char[] implicitSuperclassName = TypeConstants.CharArray_JAVA_LANG_OBJECT;
            if (isInRange) {
                char[] superclassName;
                boolean isEnumInit;
                int currentModifiers = typeDeclaration.modifiers;
                boolean deprecated = (currentModifiers & 0x100000) != 0 || this.hasDeprecatedAnnotation(typeDeclaration.annotations);
                boolean bl = isEnumInit = typeDeclaration.allocation != null && typeDeclaration.allocation.enumConstant != null;
                if (isEnumInit) {
                    currentModifiers |= 0x4000;
                    superclassName = declaringType.name;
                } else {
                    TypeReference superclass = typeDeclaration.superclass;
                    superclassName = superclass != null ? CharOperation.concatWith(superclass.getParameterizedTypeName(), '.') : null;
                }
                ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
                typeInfo.declarationStart = typeDeclaration.declarationSourceStart;
                typeInfo.modifiers = deprecated ? currentModifiers & 0xFFFF | 0x100000 : currentModifiers & 0xFFFF;
                typeInfo.name = typeDeclaration.name;
                typeInfo.nameSourceStart = typeDeclaration.sourceStart;
                typeInfo.nameSourceEnd = this.sourceEnd(typeDeclaration);
                typeInfo.superclass = superclassName;
                typeInfo.superinterfaces = interfaceNames;
                typeInfo.typeParameters = this.getTypeParameterInfos(typeDeclaration.typeParameters);
                typeInfo.annotationPositions = this.collectAnnotationPositions(typeDeclaration.annotations);
                typeInfo.categories = (char[][])this.nodesToCategories.get(typeDeclaration);
                typeInfo.secondary = typeDeclaration.isSecondary();
                typeInfo.anonymousMember = typeDeclaration.allocation != null && typeDeclaration.allocation.enclosingInstance != null;
                this.requestor.enterType(typeInfo);
                switch (kind) {
                    case 1: {
                        if (superclassName == null) break;
                        implicitSuperclassName = superclassName;
                        break;
                    }
                    case 2: {
                        implicitSuperclassName = TypeConstants.CharArray_JAVA_LANG_OBJECT;
                        break;
                    }
                    case 3: {
                        implicitSuperclassName = TypeConstants.CharArray_JAVA_LANG_ENUM;
                        break;
                    }
                    case 4: {
                        implicitSuperclassName = TypeConstants.CharArray_JAVA_LANG_ANNOTATION_ANNOTATION;
                    }
                }
            }
            if (this.nestedTypeIndex == this.typeNames.length) {
                char[][] cArrayArray = new char[this.nestedTypeIndex * 2][];
                this.typeNames = cArrayArray;
                System.arraycopy(this.typeNames, 0, cArrayArray, 0, this.nestedTypeIndex);
                char[][] cArrayArray2 = new char[this.nestedTypeIndex * 2][];
                this.superTypeNames = cArrayArray2;
                System.arraycopy(this.superTypeNames, 0, cArrayArray2, 0, this.nestedTypeIndex);
            }
            this.typeNames[this.nestedTypeIndex] = typeDeclaration.name;
            this.superTypeNames[this.nestedTypeIndex++] = implicitSuperclassName;
        }
        while (fieldIndex < fieldCounter || memberTypeIndex < memberTypeCounter || methodIndex < methodCounter) {
            FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldIndex < fieldCounter) {
                nextFieldDeclaration = fields[fieldIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodIndex < methodCounter) {
                nextMethodDeclaration = methods[methodIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (memberTypeIndex < memberTypeCounter) {
                nextMemberDeclaration = memberTypes[memberTypeIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    ++fieldIndex;
                    this.notifySourceElementRequestor(nextFieldDeclaration, typeDeclaration);
                    break;
                }
                case 1: {
                    ++methodIndex;
                    this.notifySourceElementRequestor(nextMethodDeclaration);
                    break;
                }
                case 2: {
                    ++memberTypeIndex;
                    this.notifySourceElementRequestor(nextMemberDeclaration, true, null);
                }
            }
        }
        if (notifyTypePresence) {
            if (isInRange) {
                this.requestor.exitType(typeDeclaration.declarationSourceEnd);
            }
            --this.nestedTypeIndex;
        }
    }

    public void parseCompilationUnit(ICompilationUnit unit, int start, int end, boolean fullParse) {
        this.reportReferenceInfo = fullParse;
        boolean old = this.diet;
        try {
            try {
                this.diet = true;
                CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
                CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult, start, end);
                if (this.scanner.recordLineSeparator) {
                    this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
                }
                if (this.localDeclarationVisitor != null || fullParse) {
                    this.diet = false;
                    this.getMethodBodies(parsedUnit);
                }
                this.scanner.resetTo(start, end);
                this.notifySourceElementRequestor(parsedUnit);
            }
            catch (AbortCompilation abortCompilation) {
                this.diet = old;
                this.reset();
            }
        }
        finally {
            this.diet = old;
            this.reset();
        }
    }

    public CompilationUnitDeclaration parseCompilationUnit(ICompilationUnit unit, boolean fullParse) {
        boolean old = this.diet;
        try {
            this.diet = true;
            this.reportReferenceInfo = fullParse;
            CompilationResult compilationUnitResult = new CompilationResult(unit, 0, 0, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parse(unit, compilationUnitResult);
            if (this.scanner.recordLineSeparator) {
                this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
            }
            int initialStart = this.scanner.initialPosition;
            int initialEnd = this.scanner.eofPosition;
            if (this.localDeclarationVisitor != null || fullParse) {
                this.diet = false;
                this.getMethodBodies(parsedUnit);
            }
            this.scanner.resetTo(initialStart, initialEnd);
            this.notifySourceElementRequestor(parsedUnit);
            CompilationUnitDeclaration compilationUnitDeclaration = parsedUnit;
            return compilationUnitDeclaration;
        }
        catch (AbortCompilation abortCompilation) {
        }
        finally {
            this.diet = old;
            this.reset();
        }
        return null;
    }

    public void parseTypeMemberDeclarations(ISourceType type, ICompilationUnit sourceUnit, int start, int end, boolean needReferenceInfo) {
        boolean old = this.diet;
        CompilationResult compilationUnitResult = new CompilationResult(sourceUnit, 0, 0, this.options.maxProblemsPerUnit);
        try {
            this.diet = !needReferenceInfo;
            this.reportReferenceInfo = needReferenceInfo;
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{type}, 0, this.problemReporter(), compilationUnitResult);
            if (unit == null || unit.types == null || unit.types.length != 1) {
                return;
            }
            try {
                this.sourceType = type;
                try {
                    this.initialize();
                    this.goForClassBodyDeclarations();
                    this.scanner.setSource(sourceUnit.getContents());
                    this.scanner.resetTo(start, end);
                    this.compilationUnit = unit;
                    this.referenceContext = this.compilationUnit;
                    this.pushOnAstStack(unit.types[0]);
                    this.parse();
                    this.notifySourceElementRequestor(unit);
                }
                finally {
                    unit = this.compilationUnit;
                    this.compilationUnit = null;
                }
            }
            catch (AbortCompilation abortCompilation) {}
        }
        finally {
            if (this.scanner.recordLineSeparator) {
                this.requestor.acceptLineSeparatorPositions(compilationUnitResult.getLineSeparatorPositions());
            }
            this.diet = old;
            this.reset();
        }
    }

    public void parseTypeMemberDeclarations(char[] contents, int start, int end) {
        boolean old = this.diet;
        try {
            try {
                this.diet = true;
                this.initialize();
                this.goForClassBodyDeclarations();
                this.scanner.setSource(contents);
                this.scanner.recordLineSeparator = false;
                this.scanner.taskTags = null;
                this.scanner.taskPriorities = null;
                this.scanner.resetTo(start, end);
                this.referenceContext = null;
                this.parse();
                this.notifySourceElementRequestor((CompilationUnitDeclaration)null);
            }
            catch (AbortCompilation abortCompilation) {
                this.diet = old;
                this.reset();
            }
        }
        finally {
            this.diet = old;
            this.reset();
        }
    }

    private static void quickSort(ASTNode[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        ASTNode mid = sortedCollection[left + (right - left) / 2];
        while (true) {
            if (sortedCollection[left].sourceStart < mid.sourceStart) {
                ++left;
                continue;
            }
            while (mid.sourceStart < sortedCollection[right].sourceStart) {
                --right;
            }
            if (left <= right) {
                ASTNode tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            SourceElementParser.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            SourceElementParser.quickSort(sortedCollection, left, original_right);
        }
    }

    private void rememberCategories() {
        if (this.useSourceJavadocParser) {
            SourceJavadocParser sourceJavadocParser = (SourceJavadocParser)this.javadocParser;
            char[][] categories = sourceJavadocParser.categories;
            if (categories.length > 0) {
                this.nodesToCategories.put(this.astStack[this.astPtr], categories);
                sourceJavadocParser.categories = CharOperation.NO_CHAR_CHAR;
            }
        }
    }

    private void reset() {
        this.sourceEnds = new HashtableOfObjectToInt();
        this.nodesToCategories = new HashMap();
        this.typeNames = new char[4][];
        this.superTypeNames = new char[4][];
        this.nestedTypeIndex = 0;
    }

    private int sourceEnd(TypeDeclaration typeDeclaration) {
        if ((typeDeclaration.bits & 0x200) != 0) {
            QualifiedAllocationExpression allocation = typeDeclaration.allocation;
            if (allocation.type == null) {
                return typeDeclaration.sourceEnd;
            }
            return allocation.type.sourceEnd;
        }
        return typeDeclaration.sourceEnd;
    }

    private void visitIfNeeded(AbstractMethodDeclaration method) {
        if (this.localDeclarationVisitor != null && (method.bits & 2) != 0) {
            if (method instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)method;
                if (constructorDeclaration.constructorCall != null) {
                    constructorDeclaration.constructorCall.traverse(this.localDeclarationVisitor, method.scope);
                }
            }
            if (method.statements != null) {
                int statementsLength = method.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    method.statements[i].traverse(this.localDeclarationVisitor, method.scope);
                    ++i;
                }
            }
        }
    }

    private void visitIfNeeded(FieldDeclaration field, TypeDeclaration declaringType) {
        if (this.localDeclarationVisitor != null && (field.bits & 2) != 0 && field.initialization != null) {
            try {
                this.localDeclarationVisitor.pushDeclaringType(declaringType);
                field.initialization.traverse((ASTVisitor)this.localDeclarationVisitor, (BlockScope)null);
            }
            finally {
                this.localDeclarationVisitor.popDeclaringType();
            }
        }
    }

    private void visitIfNeeded(Initializer initializer) {
        if (this.localDeclarationVisitor != null && (initializer.bits & 2) != 0 && initializer.block != null) {
            initializer.block.traverse(this.localDeclarationVisitor, null);
        }
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        ArrayList declaringTypes;

        public void pushDeclaringType(TypeDeclaration declaringType) {
            if (this.declaringTypes == null) {
                this.declaringTypes = new ArrayList();
            }
            this.declaringTypes.add(declaringType);
        }

        public void popDeclaringType() {
            this.declaringTypes.remove(this.declaringTypes.size() - 1);
        }

        public TypeDeclaration peekDeclaringType() {
            if (this.declaringTypes == null) {
                return null;
            }
            int size = this.declaringTypes.size();
            if (size == 0) {
                return null;
            }
            return (TypeDeclaration)this.declaringTypes.get(size - 1);
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null, this.peekDeclaringType());
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration, ClassScope scope) {
            SourceElementParser.this.notifySourceElementRequestor(typeDeclaration, SourceElementParser.this.sourceType == null, this.peekDeclaringType());
            return false;
        }
    }
}

