package com.wewebu.ow.server.ui.preview;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ui.OwAppContext;

/**
 *<p>
 * Interface for the context of integrated preview. 
 *</p>
 *
 *<p><font size="-2">
 * Alfresco Workdesk<br/>
 * Copyright (c) Alfresco Software, Inc.<br/>
 * All rights reserved.<br/>
 * <br/>
 * For licensing information read the license.txt file or<br/>
 * go to: http://wiki.alfresco.com<br/>
 *</font></p>
 *@since 4.2.0.0
 */
public interface OwPreviewContext
{
    /**
     * Object which is defined for preview.
     * @return OwObject
     */
    OwObject getObject();

    /**
     * Application context the preview is handled by.
     * @return OwAppContext
     */
    OwAppContext getAppContext();

    /**
     * Defined default rendition type for preview.
     * @return String
     */
    String getRenditionType();
}
